/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v1;

import com.google.gson.annotations.SerializedName;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.hyperledger.aries.api.credentials.CredentialAttributes;
import org.hyperledger.aries.api.credentials.CredentialPreview;

public class V1CredentialProposalRequest {
    private Boolean autoOffer;
    @Nullable
    private Boolean autoRemove;
    @Nullable
    private String comment;
    @NonNull
    private String connectionId;
    @Nullable
    @SerializedName(value="cred_def_id", alternate={"credential_definition_id"})
    private String credentialDefinitionId;
    @Nullable
    private CredentialPreview credentialProposal;
    @Nullable
    private String issuerDid;
    @Nullable
    private String schemaId;
    @Nullable
    private String schemaIssuerDid;
    @Nullable
    private String schemaName;
    @Nullable
    private String schemaVersion;
    @Nullable
    private Boolean trace;

    public <T> V1CredentialProposalRequest(@NonNull String connectionId, @NonNull String credentialDefinitionId, @NonNull T instance) {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (credentialDefinitionId == null) {
            throw new NullPointerException("credentialDefinitionId is marked non-null but is null");
        }
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        this.connectionId = connectionId;
        this.credentialDefinitionId = credentialDefinitionId;
        this.credentialProposal = new CredentialPreview(CredentialAttributes.from(instance));
    }

    public static V1CredentialProposalRequestBuilder builder() {
        return new V1CredentialProposalRequestBuilder();
    }

    public Boolean getAutoOffer() {
        return this.autoOffer;
    }

    @Nullable
    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @NonNull
    public String getConnectionId() {
        return this.connectionId;
    }

    @Nullable
    public String getCredentialDefinitionId() {
        return this.credentialDefinitionId;
    }

    @Nullable
    public CredentialPreview getCredentialProposal() {
        return this.credentialProposal;
    }

    @Nullable
    public String getIssuerDid() {
        return this.issuerDid;
    }

    @Nullable
    public String getSchemaId() {
        return this.schemaId;
    }

    @Nullable
    public String getSchemaIssuerDid() {
        return this.schemaIssuerDid;
    }

    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Nullable
    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    @Nullable
    public Boolean getTrace() {
        return this.trace;
    }

    public void setAutoOffer(Boolean autoOffer) {
        this.autoOffer = autoOffer;
    }

    public void setAutoRemove(@Nullable Boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    public void setConnectionId(@NonNull String connectionId) {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        this.connectionId = connectionId;
    }

    public void setCredentialDefinitionId(@Nullable String credentialDefinitionId) {
        this.credentialDefinitionId = credentialDefinitionId;
    }

    public void setCredentialProposal(@Nullable CredentialPreview credentialProposal) {
        this.credentialProposal = credentialProposal;
    }

    public void setIssuerDid(@Nullable String issuerDid) {
        this.issuerDid = issuerDid;
    }

    public void setSchemaId(@Nullable String schemaId) {
        this.schemaId = schemaId;
    }

    public void setSchemaIssuerDid(@Nullable String schemaIssuerDid) {
        this.schemaIssuerDid = schemaIssuerDid;
    }

    public void setSchemaName(@Nullable String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchemaVersion(@Nullable String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    public void setTrace(@Nullable Boolean trace) {
        this.trace = trace;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V1CredentialProposalRequest)) {
            return false;
        }
        V1CredentialProposalRequest other = (V1CredentialProposalRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$autoOffer = this.getAutoOffer();
        Boolean other$autoOffer = other.getAutoOffer();
        if (this$autoOffer == null ? other$autoOffer != null : !((Object)this$autoOffer).equals(other$autoOffer)) {
            return false;
        }
        Boolean this$autoRemove = this.getAutoRemove();
        Boolean other$autoRemove = other.getAutoRemove();
        if (this$autoRemove == null ? other$autoRemove != null : !((Object)this$autoRemove).equals(other$autoRemove)) {
            return false;
        }
        Boolean this$trace = this.getTrace();
        Boolean other$trace = other.getTrace();
        if (this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$credentialDefinitionId = this.getCredentialDefinitionId();
        String other$credentialDefinitionId = other.getCredentialDefinitionId();
        if (this$credentialDefinitionId == null ? other$credentialDefinitionId != null : !this$credentialDefinitionId.equals(other$credentialDefinitionId)) {
            return false;
        }
        CredentialPreview this$credentialProposal = this.getCredentialProposal();
        CredentialPreview other$credentialProposal = other.getCredentialProposal();
        if (this$credentialProposal == null ? other$credentialProposal != null : !((Object)this$credentialProposal).equals(other$credentialProposal)) {
            return false;
        }
        String this$issuerDid = this.getIssuerDid();
        String other$issuerDid = other.getIssuerDid();
        if (this$issuerDid == null ? other$issuerDid != null : !this$issuerDid.equals(other$issuerDid)) {
            return false;
        }
        String this$schemaId = this.getSchemaId();
        String other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
            return false;
        }
        String this$schemaIssuerDid = this.getSchemaIssuerDid();
        String other$schemaIssuerDid = other.getSchemaIssuerDid();
        if (this$schemaIssuerDid == null ? other$schemaIssuerDid != null : !this$schemaIssuerDid.equals(other$schemaIssuerDid)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$schemaVersion = this.getSchemaVersion();
        String other$schemaVersion = other.getSchemaVersion();
        return !(this$schemaVersion == null ? other$schemaVersion != null : !this$schemaVersion.equals(other$schemaVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof V1CredentialProposalRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoOffer = this.getAutoOffer();
        result = result * 59 + ($autoOffer == null ? 43 : ((Object)$autoOffer).hashCode());
        Boolean $autoRemove = this.getAutoRemove();
        result = result * 59 + ($autoRemove == null ? 43 : ((Object)$autoRemove).hashCode());
        Boolean $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $credentialDefinitionId = this.getCredentialDefinitionId();
        result = result * 59 + ($credentialDefinitionId == null ? 43 : $credentialDefinitionId.hashCode());
        CredentialPreview $credentialProposal = this.getCredentialProposal();
        result = result * 59 + ($credentialProposal == null ? 43 : ((Object)$credentialProposal).hashCode());
        String $issuerDid = this.getIssuerDid();
        result = result * 59 + ($issuerDid == null ? 43 : $issuerDid.hashCode());
        String $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
        String $schemaIssuerDid = this.getSchemaIssuerDid();
        result = result * 59 + ($schemaIssuerDid == null ? 43 : $schemaIssuerDid.hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $schemaVersion = this.getSchemaVersion();
        result = result * 59 + ($schemaVersion == null ? 43 : $schemaVersion.hashCode());
        return result;
    }

    public String toString() {
        return "V1CredentialProposalRequest(autoOffer=" + this.getAutoOffer() + ", autoRemove=" + this.getAutoRemove() + ", comment=" + this.getComment() + ", connectionId=" + this.getConnectionId() + ", credentialDefinitionId=" + this.getCredentialDefinitionId() + ", credentialProposal=" + this.getCredentialProposal() + ", issuerDid=" + this.getIssuerDid() + ", schemaId=" + this.getSchemaId() + ", schemaIssuerDid=" + this.getSchemaIssuerDid() + ", schemaName=" + this.getSchemaName() + ", schemaVersion=" + this.getSchemaVersion() + ", trace=" + this.getTrace() + ")";
    }

    public V1CredentialProposalRequest() {
    }

    public V1CredentialProposalRequest(Boolean autoOffer, @Nullable Boolean autoRemove, @Nullable String comment, @NonNull String connectionId, @Nullable String credentialDefinitionId, @Nullable CredentialPreview credentialProposal, @Nullable String issuerDid, @Nullable String schemaId, @Nullable String schemaIssuerDid, @Nullable String schemaName, @Nullable String schemaVersion, @Nullable Boolean trace) {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        this.autoOffer = autoOffer;
        this.autoRemove = autoRemove;
        this.comment = comment;
        this.connectionId = connectionId;
        this.credentialDefinitionId = credentialDefinitionId;
        this.credentialProposal = credentialProposal;
        this.issuerDid = issuerDid;
        this.schemaId = schemaId;
        this.schemaIssuerDid = schemaIssuerDid;
        this.schemaName = schemaName;
        this.schemaVersion = schemaVersion;
        this.trace = trace;
    }

    public static class V1CredentialProposalRequestBuilder {
        private Boolean autoOffer;
        private Boolean autoRemove;
        private String comment;
        private String connectionId;
        private String credentialDefinitionId;
        private CredentialPreview credentialProposal;
        private String issuerDid;
        private String schemaId;
        private String schemaIssuerDid;
        private String schemaName;
        private String schemaVersion;
        private Boolean trace;

        V1CredentialProposalRequestBuilder() {
        }

        public V1CredentialProposalRequestBuilder autoOffer(Boolean autoOffer) {
            this.autoOffer = autoOffer;
            return this;
        }

        public V1CredentialProposalRequestBuilder autoRemove(@Nullable Boolean autoRemove) {
            this.autoRemove = autoRemove;
            return this;
        }

        public V1CredentialProposalRequestBuilder comment(@Nullable String comment) {
            this.comment = comment;
            return this;
        }

        public V1CredentialProposalRequestBuilder connectionId(@NonNull String connectionId) {
            if (connectionId == null) {
                throw new NullPointerException("connectionId is marked non-null but is null");
            }
            this.connectionId = connectionId;
            return this;
        }

        public V1CredentialProposalRequestBuilder credentialDefinitionId(@Nullable String credentialDefinitionId) {
            this.credentialDefinitionId = credentialDefinitionId;
            return this;
        }

        public V1CredentialProposalRequestBuilder credentialProposal(@Nullable CredentialPreview credentialProposal) {
            this.credentialProposal = credentialProposal;
            return this;
        }

        public V1CredentialProposalRequestBuilder issuerDid(@Nullable String issuerDid) {
            this.issuerDid = issuerDid;
            return this;
        }

        public V1CredentialProposalRequestBuilder schemaId(@Nullable String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public V1CredentialProposalRequestBuilder schemaIssuerDid(@Nullable String schemaIssuerDid) {
            this.schemaIssuerDid = schemaIssuerDid;
            return this;
        }

        public V1CredentialProposalRequestBuilder schemaName(@Nullable String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public V1CredentialProposalRequestBuilder schemaVersion(@Nullable String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public V1CredentialProposalRequestBuilder trace(@Nullable Boolean trace) {
            this.trace = trace;
            return this;
        }

        public V1CredentialProposalRequest build() {
            return new V1CredentialProposalRequest(this.autoOffer, this.autoRemove, this.comment, this.connectionId, this.credentialDefinitionId, this.credentialProposal, this.issuerDid, this.schemaId, this.schemaIssuerDid, this.schemaName, this.schemaVersion, this.trace);
        }

        public String toString() {
            return "V1CredentialProposalRequest.V1CredentialProposalRequestBuilder(autoOffer=" + this.autoOffer + ", autoRemove=" + this.autoRemove + ", comment=" + this.comment + ", connectionId=" + this.connectionId + ", credentialDefinitionId=" + this.credentialDefinitionId + ", credentialProposal=" + this.credentialProposal + ", issuerDid=" + this.issuerDid + ", schemaId=" + this.schemaId + ", schemaIssuerDid=" + this.schemaIssuerDid + ", schemaName=" + this.schemaName + ", schemaVersion=" + this.schemaVersion + ", trace=" + this.trace + ")";
        }
    }
}

