/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v1;

import java.io.IOException;
import java.util.Map;
import lombok.NonNull;
import org.hyperledger.acy_py.generated.model.InvitationRecord;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.api.credentials.CredentialAttributes;
import org.hyperledger.aries.api.credentials.CredentialPreview;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialFreeOfferRequest;
import org.hyperledger.aries.api.out_of_band.AttachmentDef;
import org.hyperledger.aries.api.out_of_band.CreateInvitationFilter;
import org.hyperledger.aries.api.out_of_band.InvitationCreateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1CredentialFreeOfferHelper {
    private static final Logger log = LoggerFactory.getLogger(V1CredentialFreeOfferHelper.class);
    private final AriesClient acaPy;

    public V1CredentialFreeOfferHelper(AriesClient acaPy) {
        this.acaPy = acaPy;
    }

    public CredentialFreeOffer buildFreeOffer(@NonNull String credentialDefinitionId, Map<String, String> document) {
        if (credentialDefinitionId == null) {
            throw new NullPointerException("credentialDefinitionId is marked non-null but is null");
        }
        CredentialFreeOffer.CredentialFreeOfferBuilder r = CredentialFreeOffer.builder();
        try {
            V1CredentialFreeOfferRequest create = V1CredentialFreeOfferRequest.builder().autoIssue(Boolean.TRUE).autoRemove(Boolean.TRUE).credDefId(credentialDefinitionId).credentialPreview(new CredentialPreview(CredentialAttributes.fromMap(document))).build();
            V1CredentialExchange ex = this.acaPy.issueCredentialCreateOffer(create).orElseThrow();
            r.threadId(ex.getThreadId());
            r.credentialExchangeId(ex.getCredentialExchangeId());
            r.credentialProposalDict(ex.getCredentialProposalDict());
            InvitationRecord invitationRecord = this.acaPy.outOfBandCreateInvitation(InvitationCreateRequest.builder().usePublicDid(Boolean.TRUE).attachment(AttachmentDef.builder().id(ex.getCredentialExchangeId()).type(AttachmentDef.AttachmentType.CREDENTIAL_OFFER).build()).build(), CreateInvitationFilter.builder().autoAccept(Boolean.TRUE).build()).orElseThrow();
            r.invitationRecord(invitationRecord);
        }
        catch (IOException e) {
            log.error("aca-py is not available", (Throwable)e);
        }
        return r.build();
    }

    public static final class CredentialFreeOffer {
        private String credentialExchangeId;
        private String threadId;
        private V1CredentialExchange.CredentialProposalDict credentialProposalDict;
        private InvitationRecord invitationRecord;

        public static CredentialFreeOfferBuilder builder() {
            return new CredentialFreeOfferBuilder();
        }

        public String getCredentialExchangeId() {
            return this.credentialExchangeId;
        }

        public String getThreadId() {
            return this.threadId;
        }

        public V1CredentialExchange.CredentialProposalDict getCredentialProposalDict() {
            return this.credentialProposalDict;
        }

        public InvitationRecord getInvitationRecord() {
            return this.invitationRecord;
        }

        public void setCredentialExchangeId(String credentialExchangeId) {
            this.credentialExchangeId = credentialExchangeId;
        }

        public void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public void setCredentialProposalDict(V1CredentialExchange.CredentialProposalDict credentialProposalDict) {
            this.credentialProposalDict = credentialProposalDict;
        }

        public void setInvitationRecord(InvitationRecord invitationRecord) {
            this.invitationRecord = invitationRecord;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CredentialFreeOffer)) {
                return false;
            }
            CredentialFreeOffer other = (CredentialFreeOffer)o;
            String this$credentialExchangeId = this.getCredentialExchangeId();
            String other$credentialExchangeId = other.getCredentialExchangeId();
            if (this$credentialExchangeId == null ? other$credentialExchangeId != null : !this$credentialExchangeId.equals(other$credentialExchangeId)) {
                return false;
            }
            String this$threadId = this.getThreadId();
            String other$threadId = other.getThreadId();
            if (this$threadId == null ? other$threadId != null : !this$threadId.equals(other$threadId)) {
                return false;
            }
            V1CredentialExchange.CredentialProposalDict this$credentialProposalDict = this.getCredentialProposalDict();
            V1CredentialExchange.CredentialProposalDict other$credentialProposalDict = other.getCredentialProposalDict();
            if (this$credentialProposalDict == null ? other$credentialProposalDict != null : !((Object)this$credentialProposalDict).equals(other$credentialProposalDict)) {
                return false;
            }
            InvitationRecord this$invitationRecord = this.getInvitationRecord();
            InvitationRecord other$invitationRecord = other.getInvitationRecord();
            return !(this$invitationRecord == null ? other$invitationRecord != null : !((Object)this$invitationRecord).equals(other$invitationRecord));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $credentialExchangeId = this.getCredentialExchangeId();
            result = result * 59 + ($credentialExchangeId == null ? 43 : $credentialExchangeId.hashCode());
            String $threadId = this.getThreadId();
            result = result * 59 + ($threadId == null ? 43 : $threadId.hashCode());
            V1CredentialExchange.CredentialProposalDict $credentialProposalDict = this.getCredentialProposalDict();
            result = result * 59 + ($credentialProposalDict == null ? 43 : ((Object)$credentialProposalDict).hashCode());
            InvitationRecord $invitationRecord = this.getInvitationRecord();
            result = result * 59 + ($invitationRecord == null ? 43 : ((Object)$invitationRecord).hashCode());
            return result;
        }

        public String toString() {
            return "V1CredentialFreeOfferHelper.CredentialFreeOffer(credentialExchangeId=" + this.getCredentialExchangeId() + ", threadId=" + this.getThreadId() + ", credentialProposalDict=" + this.getCredentialProposalDict() + ", invitationRecord=" + this.getInvitationRecord() + ")";
        }

        public CredentialFreeOffer() {
        }

        public CredentialFreeOffer(String credentialExchangeId, String threadId, V1CredentialExchange.CredentialProposalDict credentialProposalDict, InvitationRecord invitationRecord) {
            this.credentialExchangeId = credentialExchangeId;
            this.threadId = threadId;
            this.credentialProposalDict = credentialProposalDict;
            this.invitationRecord = invitationRecord;
        }

        public static class CredentialFreeOfferBuilder {
            private String credentialExchangeId;
            private String threadId;
            private V1CredentialExchange.CredentialProposalDict credentialProposalDict;
            private InvitationRecord invitationRecord;

            CredentialFreeOfferBuilder() {
            }

            public CredentialFreeOfferBuilder credentialExchangeId(String credentialExchangeId) {
                this.credentialExchangeId = credentialExchangeId;
                return this;
            }

            public CredentialFreeOfferBuilder threadId(String threadId) {
                this.threadId = threadId;
                return this;
            }

            public CredentialFreeOfferBuilder credentialProposalDict(V1CredentialExchange.CredentialProposalDict credentialProposalDict) {
                this.credentialProposalDict = credentialProposalDict;
                return this;
            }

            public CredentialFreeOfferBuilder invitationRecord(InvitationRecord invitationRecord) {
                this.invitationRecord = invitationRecord;
                return this;
            }

            public CredentialFreeOffer build() {
                return new CredentialFreeOffer(this.credentialExchangeId, this.threadId, this.credentialProposalDict, this.invitationRecord);
            }

            public String toString() {
                return "V1CredentialFreeOfferHelper.CredentialFreeOffer.CredentialFreeOfferBuilder(credentialExchangeId=" + this.credentialExchangeId + ", threadId=" + this.threadId + ", credentialProposalDict=" + this.credentialProposalDict + ", invitationRecord=" + this.invitationRecord + ")";
            }
        }
    }
}

