/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v1;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hyperledger.acy_py.generated.model.AttachDecorator;
import org.hyperledger.acy_py.generated.model.IndyCredAbstract;
import org.hyperledger.acy_py.generated.model.IndyCredRequest;
import org.hyperledger.acy_py.generated.model.IndyCredential;
import org.hyperledger.aries.api.credentials.Credential;
import org.hyperledger.aries.api.credentials.CredentialAttributes;
import org.hyperledger.aries.api.issue_credential_v1.BaseCredExRecord;
import org.hyperledger.aries.api.issue_credential_v1.ThreadId;
import org.hyperledger.aries.api.serializer.JsonObjectDeserializer;
import org.hyperledger.aries.api.serializer.JsonObjectSerializer;

public class V1CredentialExchange
extends BaseCredExRecord {
    private Credential credential;
    private IndyCredAbstract credentialOffer;
    private CredentialOfferDict credentialOfferDict;
    private CredentialProposalDict credentialProposalDict;
    private IndyCredRequest credentialRequest;
    @JsonSerialize(using=JsonObjectSerializer.class)
    @JsonDeserialize(using=JsonObjectDeserializer.class)
    private JsonObject credentialRequestMetadata;
    private IndyCredential rawCredential;
    private String schemaId;
    @SerializedName(value="cred_def_id", alternate={"credential_definition_id"})
    private String credentialDefinitionId;
    private String credentialId;
    private String revocRegId;
    private String revocationId;

    public Optional<Map<String, String>> findAttributesInCredentialOfferDict() {
        List<CredentialAttributes> attributes;
        Optional<Map<String, String>> result = Optional.empty();
        if (this.credentialOfferDict != null && this.credentialOfferDict.credentialPreview != null && (attributes = this.credentialOfferDict.getCredentialPreview().getAttributes()) != null) {
            return Optional.of(attributes.stream().collect(Collectors.toMap(CredentialAttributes::getName, CredentialAttributes::getValue)));
        }
        return result;
    }

    protected V1CredentialExchange(V1CredentialExchangeBuilder<?, ?> b) {
        super(b);
        this.credential = b.credential;
        this.credentialOffer = b.credentialOffer;
        this.credentialOfferDict = b.credentialOfferDict;
        this.credentialProposalDict = b.credentialProposalDict;
        this.credentialRequest = b.credentialRequest;
        this.credentialRequestMetadata = b.credentialRequestMetadata;
        this.rawCredential = b.rawCredential;
        this.schemaId = b.schemaId;
        this.credentialDefinitionId = b.credentialDefinitionId;
        this.credentialId = b.credentialId;
        this.revocRegId = b.revocRegId;
        this.revocationId = b.revocationId;
    }

    public static V1CredentialExchangeBuilder<?, ?> builder() {
        return new V1CredentialExchangeBuilderImpl();
    }

    public Credential getCredential() {
        return this.credential;
    }

    public IndyCredAbstract getCredentialOffer() {
        return this.credentialOffer;
    }

    public CredentialOfferDict getCredentialOfferDict() {
        return this.credentialOfferDict;
    }

    public CredentialProposalDict getCredentialProposalDict() {
        return this.credentialProposalDict;
    }

    public IndyCredRequest getCredentialRequest() {
        return this.credentialRequest;
    }

    public JsonObject getCredentialRequestMetadata() {
        return this.credentialRequestMetadata;
    }

    public IndyCredential getRawCredential() {
        return this.rawCredential;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public String getCredentialDefinitionId() {
        return this.credentialDefinitionId;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getRevocRegId() {
        return this.revocRegId;
    }

    public String getRevocationId() {
        return this.revocationId;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public void setCredentialOffer(IndyCredAbstract credentialOffer) {
        this.credentialOffer = credentialOffer;
    }

    public void setCredentialOfferDict(CredentialOfferDict credentialOfferDict) {
        this.credentialOfferDict = credentialOfferDict;
    }

    public void setCredentialProposalDict(CredentialProposalDict credentialProposalDict) {
        this.credentialProposalDict = credentialProposalDict;
    }

    public void setCredentialRequest(IndyCredRequest credentialRequest) {
        this.credentialRequest = credentialRequest;
    }

    @JsonDeserialize(using=JsonObjectDeserializer.class)
    public void setCredentialRequestMetadata(JsonObject credentialRequestMetadata) {
        this.credentialRequestMetadata = credentialRequestMetadata;
    }

    public void setRawCredential(IndyCredential rawCredential) {
        this.rawCredential = rawCredential;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public void setCredentialDefinitionId(String credentialDefinitionId) {
        this.credentialDefinitionId = credentialDefinitionId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public void setRevocRegId(String revocRegId) {
        this.revocRegId = revocRegId;
    }

    public void setRevocationId(String revocationId) {
        this.revocationId = revocationId;
    }

    public V1CredentialExchange() {
    }

    public V1CredentialExchange(Credential credential, IndyCredAbstract credentialOffer, CredentialOfferDict credentialOfferDict, CredentialProposalDict credentialProposalDict, IndyCredRequest credentialRequest, JsonObject credentialRequestMetadata, IndyCredential rawCredential, String schemaId, String credentialDefinitionId, String credentialId, String revocRegId, String revocationId) {
        this.credential = credential;
        this.credentialOffer = credentialOffer;
        this.credentialOfferDict = credentialOfferDict;
        this.credentialProposalDict = credentialProposalDict;
        this.credentialRequest = credentialRequest;
        this.credentialRequestMetadata = credentialRequestMetadata;
        this.rawCredential = rawCredential;
        this.schemaId = schemaId;
        this.credentialDefinitionId = credentialDefinitionId;
        this.credentialId = credentialId;
        this.revocRegId = revocRegId;
        this.revocationId = revocationId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof V1CredentialExchange)) {
            return false;
        }
        V1CredentialExchange other = (V1CredentialExchange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Credential this$credential = this.getCredential();
        Credential other$credential = other.getCredential();
        if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
            return false;
        }
        IndyCredAbstract this$credentialOffer = this.getCredentialOffer();
        IndyCredAbstract other$credentialOffer = other.getCredentialOffer();
        if (this$credentialOffer == null ? other$credentialOffer != null : !((Object)this$credentialOffer).equals(other$credentialOffer)) {
            return false;
        }
        CredentialOfferDict this$credentialOfferDict = this.getCredentialOfferDict();
        CredentialOfferDict other$credentialOfferDict = other.getCredentialOfferDict();
        if (this$credentialOfferDict == null ? other$credentialOfferDict != null : !((Object)this$credentialOfferDict).equals(other$credentialOfferDict)) {
            return false;
        }
        CredentialProposalDict this$credentialProposalDict = this.getCredentialProposalDict();
        CredentialProposalDict other$credentialProposalDict = other.getCredentialProposalDict();
        if (this$credentialProposalDict == null ? other$credentialProposalDict != null : !((Object)this$credentialProposalDict).equals(other$credentialProposalDict)) {
            return false;
        }
        IndyCredRequest this$credentialRequest = this.getCredentialRequest();
        IndyCredRequest other$credentialRequest = other.getCredentialRequest();
        if (this$credentialRequest == null ? other$credentialRequest != null : !((Object)this$credentialRequest).equals(other$credentialRequest)) {
            return false;
        }
        JsonObject this$credentialRequestMetadata = this.getCredentialRequestMetadata();
        JsonObject other$credentialRequestMetadata = other.getCredentialRequestMetadata();
        if (this$credentialRequestMetadata == null ? other$credentialRequestMetadata != null : !this$credentialRequestMetadata.equals(other$credentialRequestMetadata)) {
            return false;
        }
        IndyCredential this$rawCredential = this.getRawCredential();
        IndyCredential other$rawCredential = other.getRawCredential();
        if (this$rawCredential == null ? other$rawCredential != null : !((Object)this$rawCredential).equals(other$rawCredential)) {
            return false;
        }
        String this$schemaId = this.getSchemaId();
        String other$schemaId = other.getSchemaId();
        if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
            return false;
        }
        String this$credentialDefinitionId = this.getCredentialDefinitionId();
        String other$credentialDefinitionId = other.getCredentialDefinitionId();
        if (this$credentialDefinitionId == null ? other$credentialDefinitionId != null : !this$credentialDefinitionId.equals(other$credentialDefinitionId)) {
            return false;
        }
        String this$credentialId = this.getCredentialId();
        String other$credentialId = other.getCredentialId();
        if (this$credentialId == null ? other$credentialId != null : !this$credentialId.equals(other$credentialId)) {
            return false;
        }
        String this$revocRegId = this.getRevocRegId();
        String other$revocRegId = other.getRevocRegId();
        if (this$revocRegId == null ? other$revocRegId != null : !this$revocRegId.equals(other$revocRegId)) {
            return false;
        }
        String this$revocationId = this.getRevocationId();
        String other$revocationId = other.getRevocationId();
        return !(this$revocationId == null ? other$revocationId != null : !this$revocationId.equals(other$revocationId));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof V1CredentialExchange;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Credential $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
        IndyCredAbstract $credentialOffer = this.getCredentialOffer();
        result = result * 59 + ($credentialOffer == null ? 43 : ((Object)$credentialOffer).hashCode());
        CredentialOfferDict $credentialOfferDict = this.getCredentialOfferDict();
        result = result * 59 + ($credentialOfferDict == null ? 43 : ((Object)$credentialOfferDict).hashCode());
        CredentialProposalDict $credentialProposalDict = this.getCredentialProposalDict();
        result = result * 59 + ($credentialProposalDict == null ? 43 : ((Object)$credentialProposalDict).hashCode());
        IndyCredRequest $credentialRequest = this.getCredentialRequest();
        result = result * 59 + ($credentialRequest == null ? 43 : ((Object)$credentialRequest).hashCode());
        JsonObject $credentialRequestMetadata = this.getCredentialRequestMetadata();
        result = result * 59 + ($credentialRequestMetadata == null ? 43 : $credentialRequestMetadata.hashCode());
        IndyCredential $rawCredential = this.getRawCredential();
        result = result * 59 + ($rawCredential == null ? 43 : ((Object)$rawCredential).hashCode());
        String $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
        String $credentialDefinitionId = this.getCredentialDefinitionId();
        result = result * 59 + ($credentialDefinitionId == null ? 43 : $credentialDefinitionId.hashCode());
        String $credentialId = this.getCredentialId();
        result = result * 59 + ($credentialId == null ? 43 : $credentialId.hashCode());
        String $revocRegId = this.getRevocRegId();
        result = result * 59 + ($revocRegId == null ? 43 : $revocRegId.hashCode());
        String $revocationId = this.getRevocationId();
        result = result * 59 + ($revocationId == null ? 43 : $revocationId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "V1CredentialExchange(super=" + super.toString() + ", credential=" + this.getCredential() + ", credentialOffer=" + this.getCredentialOffer() + ", credentialOfferDict=" + this.getCredentialOfferDict() + ", credentialProposalDict=" + this.getCredentialProposalDict() + ", credentialRequest=" + this.getCredentialRequest() + ", credentialRequestMetadata=" + this.getCredentialRequestMetadata() + ", rawCredential=" + this.getRawCredential() + ", schemaId=" + this.getSchemaId() + ", credentialDefinitionId=" + this.getCredentialDefinitionId() + ", credentialId=" + this.getCredentialId() + ", revocRegId=" + this.getRevocRegId() + ", revocationId=" + this.getRevocationId() + ")";
    }

    private static final class V1CredentialExchangeBuilderImpl
    extends V1CredentialExchangeBuilder<V1CredentialExchange, V1CredentialExchangeBuilderImpl> {
        private V1CredentialExchangeBuilderImpl() {
        }

        @Override
        protected V1CredentialExchangeBuilderImpl self() {
            return this;
        }

        @Override
        public V1CredentialExchange build() {
            return new V1CredentialExchange(this);
        }
    }

    public static abstract class V1CredentialExchangeBuilder<C extends V1CredentialExchange, B extends V1CredentialExchangeBuilder<C, B>>
    extends BaseCredExRecord.BaseCredExRecordBuilder<C, B> {
        private Credential credential;
        private IndyCredAbstract credentialOffer;
        private CredentialOfferDict credentialOfferDict;
        private CredentialProposalDict credentialProposalDict;
        private IndyCredRequest credentialRequest;
        private JsonObject credentialRequestMetadata;
        private IndyCredential rawCredential;
        private String schemaId;
        private String credentialDefinitionId;
        private String credentialId;
        private String revocRegId;
        private String revocationId;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B credential(Credential credential) {
            this.credential = credential;
            return (B)this.self();
        }

        public B credentialOffer(IndyCredAbstract credentialOffer) {
            this.credentialOffer = credentialOffer;
            return (B)this.self();
        }

        public B credentialOfferDict(CredentialOfferDict credentialOfferDict) {
            this.credentialOfferDict = credentialOfferDict;
            return (B)this.self();
        }

        public B credentialProposalDict(CredentialProposalDict credentialProposalDict) {
            this.credentialProposalDict = credentialProposalDict;
            return (B)this.self();
        }

        public B credentialRequest(IndyCredRequest credentialRequest) {
            this.credentialRequest = credentialRequest;
            return (B)this.self();
        }

        @JsonDeserialize(using=JsonObjectDeserializer.class)
        public B credentialRequestMetadata(JsonObject credentialRequestMetadata) {
            this.credentialRequestMetadata = credentialRequestMetadata;
            return (B)this.self();
        }

        public B rawCredential(IndyCredential rawCredential) {
            this.rawCredential = rawCredential;
            return (B)this.self();
        }

        public B schemaId(String schemaId) {
            this.schemaId = schemaId;
            return (B)this.self();
        }

        public B credentialDefinitionId(String credentialDefinitionId) {
            this.credentialDefinitionId = credentialDefinitionId;
            return (B)this.self();
        }

        public B credentialId(String credentialId) {
            this.credentialId = credentialId;
            return (B)this.self();
        }

        public B revocRegId(String revocRegId) {
            this.revocRegId = revocRegId;
            return (B)this.self();
        }

        public B revocationId(String revocationId) {
            this.revocationId = revocationId;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "V1CredentialExchange.V1CredentialExchangeBuilder(super=" + super.toString() + ", credential=" + this.credential + ", credentialOffer=" + this.credentialOffer + ", credentialOfferDict=" + this.credentialOfferDict + ", credentialProposalDict=" + this.credentialProposalDict + ", credentialRequest=" + this.credentialRequest + ", credentialRequestMetadata=" + this.credentialRequestMetadata + ", rawCredential=" + this.rawCredential + ", schemaId=" + this.schemaId + ", credentialDefinitionId=" + this.credentialDefinitionId + ", credentialId=" + this.credentialId + ", revocRegId=" + this.revocRegId + ", revocationId=" + this.revocationId + ")";
        }
    }

    public static final class CredentialOfferDict {
        @SerializedName(value="@type")
        private String type;
        @SerializedName(value="@id")
        private String id;
        @SerializedName(value="~thread")
        private ThreadId threadId;
        private CredentialProposalDict.CredentialProposal credentialPreview;
        @SerializedName(value="offers~attach")
        private List<AttachDecorator> offersAttach = new ArrayList<AttachDecorator>();

        public static CredentialOfferDictBuilder builder() {
            return new CredentialOfferDictBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public ThreadId getThreadId() {
            return this.threadId;
        }

        public CredentialProposalDict.CredentialProposal getCredentialPreview() {
            return this.credentialPreview;
        }

        public List<AttachDecorator> getOffersAttach() {
            return this.offersAttach;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setThreadId(ThreadId threadId) {
            this.threadId = threadId;
        }

        public void setCredentialPreview(CredentialProposalDict.CredentialProposal credentialPreview) {
            this.credentialPreview = credentialPreview;
        }

        public void setOffersAttach(List<AttachDecorator> offersAttach) {
            this.offersAttach = offersAttach;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CredentialOfferDict)) {
                return false;
            }
            CredentialOfferDict other = (CredentialOfferDict)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ThreadId this$threadId = this.getThreadId();
            ThreadId other$threadId = other.getThreadId();
            if (this$threadId == null ? other$threadId != null : !((Object)this$threadId).equals(other$threadId)) {
                return false;
            }
            CredentialProposalDict.CredentialProposal this$credentialPreview = this.getCredentialPreview();
            CredentialProposalDict.CredentialProposal other$credentialPreview = other.getCredentialPreview();
            if (this$credentialPreview == null ? other$credentialPreview != null : !((Object)this$credentialPreview).equals(other$credentialPreview)) {
                return false;
            }
            List<AttachDecorator> this$offersAttach = this.getOffersAttach();
            List<AttachDecorator> other$offersAttach = other.getOffersAttach();
            return !(this$offersAttach == null ? other$offersAttach != null : !((Object)this$offersAttach).equals(other$offersAttach));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ThreadId $threadId = this.getThreadId();
            result = result * 59 + ($threadId == null ? 43 : ((Object)$threadId).hashCode());
            CredentialProposalDict.CredentialProposal $credentialPreview = this.getCredentialPreview();
            result = result * 59 + ($credentialPreview == null ? 43 : ((Object)$credentialPreview).hashCode());
            List<AttachDecorator> $offersAttach = this.getOffersAttach();
            result = result * 59 + ($offersAttach == null ? 43 : ((Object)$offersAttach).hashCode());
            return result;
        }

        public String toString() {
            return "V1CredentialExchange.CredentialOfferDict(type=" + this.getType() + ", id=" + this.getId() + ", threadId=" + this.getThreadId() + ", credentialPreview=" + this.getCredentialPreview() + ", offersAttach=" + this.getOffersAttach() + ")";
        }

        public CredentialOfferDict() {
        }

        public CredentialOfferDict(String type, String id, ThreadId threadId, CredentialProposalDict.CredentialProposal credentialPreview, List<AttachDecorator> offersAttach) {
            this.type = type;
            this.id = id;
            this.threadId = threadId;
            this.credentialPreview = credentialPreview;
            this.offersAttach = offersAttach;
        }

        public static class CredentialOfferDictBuilder {
            private String type;
            private String id;
            private ThreadId threadId;
            private CredentialProposalDict.CredentialProposal credentialPreview;
            private List<AttachDecorator> offersAttach;

            CredentialOfferDictBuilder() {
            }

            public CredentialOfferDictBuilder type(String type) {
                this.type = type;
                return this;
            }

            public CredentialOfferDictBuilder id(String id) {
                this.id = id;
                return this;
            }

            public CredentialOfferDictBuilder threadId(ThreadId threadId) {
                this.threadId = threadId;
                return this;
            }

            public CredentialOfferDictBuilder credentialPreview(CredentialProposalDict.CredentialProposal credentialPreview) {
                this.credentialPreview = credentialPreview;
                return this;
            }

            public CredentialOfferDictBuilder offersAttach(List<AttachDecorator> offersAttach) {
                this.offersAttach = offersAttach;
                return this;
            }

            public CredentialOfferDict build() {
                return new CredentialOfferDict(this.type, this.id, this.threadId, this.credentialPreview, this.offersAttach);
            }

            public String toString() {
                return "V1CredentialExchange.CredentialOfferDict.CredentialOfferDictBuilder(type=" + this.type + ", id=" + this.id + ", threadId=" + this.threadId + ", credentialPreview=" + this.credentialPreview + ", offersAttach=" + this.offersAttach + ")";
            }
        }
    }

    public static final class CredentialProposalDict {
        @SerializedName(value="@type")
        private String type;
        @SerializedName(value="@id")
        private String id;
        private String schemaId;
        private String credDefId;
        private CredentialProposal credentialProposal;

        public static CredentialProposalDictBuilder builder() {
            return new CredentialProposalDictBuilder();
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getSchemaId() {
            return this.schemaId;
        }

        public String getCredDefId() {
            return this.credDefId;
        }

        public CredentialProposal getCredentialProposal() {
            return this.credentialProposal;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setSchemaId(String schemaId) {
            this.schemaId = schemaId;
        }

        public void setCredDefId(String credDefId) {
            this.credDefId = credDefId;
        }

        public void setCredentialProposal(CredentialProposal credentialProposal) {
            this.credentialProposal = credentialProposal;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CredentialProposalDict)) {
                return false;
            }
            CredentialProposalDict other = (CredentialProposalDict)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$schemaId = this.getSchemaId();
            String other$schemaId = other.getSchemaId();
            if (this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId)) {
                return false;
            }
            String this$credDefId = this.getCredDefId();
            String other$credDefId = other.getCredDefId();
            if (this$credDefId == null ? other$credDefId != null : !this$credDefId.equals(other$credDefId)) {
                return false;
            }
            CredentialProposal this$credentialProposal = this.getCredentialProposal();
            CredentialProposal other$credentialProposal = other.getCredentialProposal();
            return !(this$credentialProposal == null ? other$credentialProposal != null : !((Object)this$credentialProposal).equals(other$credentialProposal));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $schemaId = this.getSchemaId();
            result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
            String $credDefId = this.getCredDefId();
            result = result * 59 + ($credDefId == null ? 43 : $credDefId.hashCode());
            CredentialProposal $credentialProposal = this.getCredentialProposal();
            result = result * 59 + ($credentialProposal == null ? 43 : ((Object)$credentialProposal).hashCode());
            return result;
        }

        public String toString() {
            return "V1CredentialExchange.CredentialProposalDict(type=" + this.getType() + ", id=" + this.getId() + ", schemaId=" + this.getSchemaId() + ", credDefId=" + this.getCredDefId() + ", credentialProposal=" + this.getCredentialProposal() + ")";
        }

        public CredentialProposalDict() {
        }

        public CredentialProposalDict(String type, String id, String schemaId, String credDefId, CredentialProposal credentialProposal) {
            this.type = type;
            this.id = id;
            this.schemaId = schemaId;
            this.credDefId = credDefId;
            this.credentialProposal = credentialProposal;
        }

        public static class CredentialProposalDictBuilder {
            private String type;
            private String id;
            private String schemaId;
            private String credDefId;
            private CredentialProposal credentialProposal;

            CredentialProposalDictBuilder() {
            }

            public CredentialProposalDictBuilder type(String type) {
                this.type = type;
                return this;
            }

            public CredentialProposalDictBuilder id(String id) {
                this.id = id;
                return this;
            }

            public CredentialProposalDictBuilder schemaId(String schemaId) {
                this.schemaId = schemaId;
                return this;
            }

            public CredentialProposalDictBuilder credDefId(String credDefId) {
                this.credDefId = credDefId;
                return this;
            }

            public CredentialProposalDictBuilder credentialProposal(CredentialProposal credentialProposal) {
                this.credentialProposal = credentialProposal;
                return this;
            }

            public CredentialProposalDict build() {
                return new CredentialProposalDict(this.type, this.id, this.schemaId, this.credDefId, this.credentialProposal);
            }

            public String toString() {
                return "V1CredentialExchange.CredentialProposalDict.CredentialProposalDictBuilder(type=" + this.type + ", id=" + this.id + ", schemaId=" + this.schemaId + ", credDefId=" + this.credDefId + ", credentialProposal=" + this.credentialProposal + ")";
            }
        }

        public static final class CredentialProposal {
            private static final Comparator<CredentialAttributes> attributesComparator = Comparator.comparing(CredentialAttributes::getName);
            @SerializedName(value="@type")
            private String type;
            private List<CredentialAttributes> attributes;

            public List<CredentialAttributes> getAttributes() {
                this.attributes.sort(attributesComparator);
                return this.attributes;
            }

            public static CredentialProposalBuilder builder() {
                return new CredentialProposalBuilder();
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setAttributes(List<CredentialAttributes> attributes) {
                this.attributes = attributes;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CredentialProposal)) {
                    return false;
                }
                CredentialProposal other = (CredentialProposal)o;
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                List<CredentialAttributes> this$attributes = this.getAttributes();
                List<CredentialAttributes> other$attributes = other.getAttributes();
                return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                List<CredentialAttributes> $attributes = this.getAttributes();
                result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
                return result;
            }

            public String toString() {
                return "V1CredentialExchange.CredentialProposalDict.CredentialProposal(type=" + this.getType() + ", attributes=" + this.getAttributes() + ")";
            }

            public CredentialProposal() {
            }

            public CredentialProposal(String type, List<CredentialAttributes> attributes) {
                this.type = type;
                this.attributes = attributes;
            }

            public static class CredentialProposalBuilder {
                private String type;
                private List<CredentialAttributes> attributes;

                CredentialProposalBuilder() {
                }

                public CredentialProposalBuilder type(String type) {
                    this.type = type;
                    return this;
                }

                public CredentialProposalBuilder attributes(List<CredentialAttributes> attributes) {
                    this.attributes = attributes;
                    return this;
                }

                public CredentialProposal build() {
                    return new CredentialProposal(this.type, this.attributes);
                }

                public String toString() {
                    return "V1CredentialExchange.CredentialProposalDict.CredentialProposal.CredentialProposalBuilder(type=" + this.type + ", attributes=" + this.attributes + ")";
                }
            }
        }
    }
}

