/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v1;

import lombok.NonNull;
import org.hyperledger.acy_py.generated.model.V20CredExRecord;

public enum CredentialExchangeState {
    PROPOSAL_SENT,
    PROPOSAL_RECEIVED,
    OFFER_SENT,
    OFFER_RECEIVED,
    REQUEST_SENT,
    REQUEST_RECEIVED,
    CREDENTIAL_ISSUED,
    CREDENTIAL_RECEIVED,
    CREDENTIAL_ACKED,
    DONE,
    CREDENTIAL_REVOKED,
    ABANDONED,
    DECLINED,
    PROBLEM;


    public static CredentialExchangeState fromV2(@NonNull V20CredExRecord.StateEnum v2) {
        if (v2 == null) {
            throw new NullPointerException("v2 is marked non-null but is null");
        }
        switch (v2) {
            case PROPOSAL_SENT: {
                return PROPOSAL_SENT;
            }
            case PROPOSAL_RECEIVED: {
                return PROPOSAL_RECEIVED;
            }
            case OFFER_SENT: {
                return OFFER_SENT;
            }
            case OFFER_RECEIVED: {
                return OFFER_RECEIVED;
            }
            case REQUEST_SENT: {
                return REQUEST_SENT;
            }
            case REQUEST_RECEIVED: {
                return REQUEST_RECEIVED;
            }
            case CREDENTIAL_ISSUED: {
                return CREDENTIAL_ISSUED;
            }
            case CREDENTIAL_RECEIVED: {
                return CREDENTIAL_RECEIVED;
            }
            case DONE: {
                return DONE;
            }
            case CREDENTIAL_REVOKED: {
                return CREDENTIAL_REVOKED;
            }
        }
        throw new IllegalStateException("V2 state could not be converted to its V1 counterpart");
    }
}

