/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v1;

import org.hyperledger.aries.api.issue_credential_v1.CredentialExchangeRole;
import org.hyperledger.aries.api.issue_credential_v1.CredentialExchangeState;

public interface CredExStateTranslator {
    public CredentialExchangeState getState();

    public CredentialExchangeRole getRole();

    default public boolean stateIsProposalSent() {
        return CredentialExchangeState.PROPOSAL_SENT.equals((Object)this.getState());
    }

    default public boolean stateIsProposalReceived() {
        return CredentialExchangeState.PROPOSAL_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsOfferSent() {
        return CredentialExchangeState.OFFER_SENT.equals((Object)this.getState());
    }

    default public boolean stateIsOfferReceived() {
        return CredentialExchangeState.OFFER_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsRequestSent() {
        return CredentialExchangeState.REQUEST_SENT.equals((Object)this.getState());
    }

    default public boolean stateIsRequestReceived() {
        return CredentialExchangeState.REQUEST_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsCredentialIssued() {
        return CredentialExchangeState.CREDENTIAL_ISSUED.equals((Object)this.getState());
    }

    default public boolean stateIsCredentialReceived() {
        return CredentialExchangeState.CREDENTIAL_RECEIVED.equals((Object)this.getState());
    }

    default public boolean stateIsCredentialAcked() {
        return CredentialExchangeState.CREDENTIAL_ACKED.equals((Object)this.getState());
    }

    default public boolean stateIsDone() {
        return CredentialExchangeState.DONE.equals((Object)this.getState());
    }

    default public boolean stateIsDeclined() {
        return CredentialExchangeState.DECLINED.equals((Object)this.getState());
    }

    default public boolean stateIsNotDeclined() {
        return !CredentialExchangeState.DECLINED.equals((Object)this.getState());
    }

    default public boolean stateIsProblem() {
        return CredentialExchangeState.PROBLEM.equals((Object)this.getState());
    }

    default public boolean stateIsRevoked() {
        return CredentialExchangeState.CREDENTIAL_REVOKED.equals((Object)this.getState());
    }

    default public boolean stateIsAbandoned() {
        return CredentialExchangeState.ABANDONED.equals((Object)this.getState());
    }

    default public boolean roleIsIssuer() {
        return CredentialExchangeRole.ISSUER.equals((Object)this.getRole());
    }

    default public boolean roleIsHolder() {
        return CredentialExchangeRole.HOLDER.equals((Object)this.getRole());
    }
}

