/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.issue_credential_v1;

import com.google.gson.annotations.SerializedName;
import org.hyperledger.aries.api.issue_credential_v1.CredExStateTranslator;
import org.hyperledger.aries.api.issue_credential_v1.CredentialExchangeInitiator;
import org.hyperledger.aries.api.issue_credential_v1.CredentialExchangeRole;
import org.hyperledger.aries.api.issue_credential_v1.CredentialExchangeState;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;

public abstract class BaseCredExRecord
implements CredExStateTranslator {
    private Boolean autoIssue;
    private Boolean autoOffer;
    private Boolean autoRemove;
    private Boolean trace;
    private String connectionId;
    @SerializedName(value="credential_exchange_id", alternate={"cred_ex_id", "credExId", "credentialExchangeId"})
    private String credentialExchangeId;
    private String threadId;
    private String parentThreadId;
    private String createdAt;
    private String updatedAt;
    private CredentialExchangeInitiator initiator;
    private CredentialExchangeRole role;
    private CredentialExchangeState state;
    private String errorMsg;

    public boolean initiatorIsSelf() {
        return CredentialExchangeInitiator.SELF.equals((Object)this.getInitiator());
    }

    public boolean initiatorIsExternal() {
        return CredentialExchangeInitiator.EXTERNAL.equals((Object)this.getInitiator());
    }

    public boolean autoIssueEnabled() {
        return this.getAutoIssue() != null && this.getAutoIssue() != false;
    }

    public boolean autoIssueOff() {
        return !this.autoIssueEnabled();
    }

    public boolean autoOfferEnabled() {
        return this.getAutoOffer() != null && this.getAutoOffer() != false;
    }

    public boolean autoRemoveEnabled() {
        return this.getAutoRemove() != null && this.getAutoRemove() != false;
    }

    public V1CredentialExchange.V1CredentialExchangeBuilder toV1Builder() {
        return (V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)((V1CredentialExchange.V1CredentialExchangeBuilder)V1CredentialExchange.builder().autoIssue(this.autoIssue)).autoOffer(this.autoOffer)).autoRemove(this.autoRemove)).trace(this.trace)).connectionId(this.connectionId)).credentialExchangeId(this.credentialExchangeId)).threadId(this.threadId)).parentThreadId(this.parentThreadId)).createdAt(this.createdAt)).updatedAt(this.updatedAt)).initiator(this.initiator)).role(this.role)).state(this.state);
    }

    protected BaseCredExRecord(BaseCredExRecordBuilder<?, ?> b) {
        this.autoIssue = b.autoIssue;
        this.autoOffer = b.autoOffer;
        this.autoRemove = b.autoRemove;
        this.trace = b.trace;
        this.connectionId = b.connectionId;
        this.credentialExchangeId = b.credentialExchangeId;
        this.threadId = b.threadId;
        this.parentThreadId = b.parentThreadId;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.initiator = b.initiator;
        this.role = b.role;
        this.state = b.state;
        this.errorMsg = b.errorMsg;
    }

    public Boolean getAutoIssue() {
        return this.autoIssue;
    }

    public Boolean getAutoOffer() {
        return this.autoOffer;
    }

    public Boolean getAutoRemove() {
        return this.autoRemove;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getCredentialExchangeId() {
        return this.credentialExchangeId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public String getParentThreadId() {
        return this.parentThreadId;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public CredentialExchangeInitiator getInitiator() {
        return this.initiator;
    }

    @Override
    public CredentialExchangeRole getRole() {
        return this.role;
    }

    @Override
    public CredentialExchangeState getState() {
        return this.state;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setAutoIssue(Boolean autoIssue) {
        this.autoIssue = autoIssue;
    }

    public void setAutoOffer(Boolean autoOffer) {
        this.autoOffer = autoOffer;
    }

    public void setAutoRemove(Boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void setCredentialExchangeId(String credentialExchangeId) {
        this.credentialExchangeId = credentialExchangeId;
    }

    public void setThreadId(String threadId) {
        this.threadId = threadId;
    }

    public void setParentThreadId(String parentThreadId) {
        this.parentThreadId = parentThreadId;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setInitiator(CredentialExchangeInitiator initiator) {
        this.initiator = initiator;
    }

    public void setRole(CredentialExchangeRole role) {
        this.role = role;
    }

    public void setState(CredentialExchangeState state) {
        this.state = state;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCredExRecord)) {
            return false;
        }
        BaseCredExRecord other = (BaseCredExRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$autoIssue = this.getAutoIssue();
        Boolean other$autoIssue = other.getAutoIssue();
        if (this$autoIssue == null ? other$autoIssue != null : !((Object)this$autoIssue).equals(other$autoIssue)) {
            return false;
        }
        Boolean this$autoOffer = this.getAutoOffer();
        Boolean other$autoOffer = other.getAutoOffer();
        if (this$autoOffer == null ? other$autoOffer != null : !((Object)this$autoOffer).equals(other$autoOffer)) {
            return false;
        }
        Boolean this$autoRemove = this.getAutoRemove();
        Boolean other$autoRemove = other.getAutoRemove();
        if (this$autoRemove == null ? other$autoRemove != null : !((Object)this$autoRemove).equals(other$autoRemove)) {
            return false;
        }
        Boolean this$trace = this.getTrace();
        Boolean other$trace = other.getTrace();
        if (this$trace == null ? other$trace != null : !((Object)this$trace).equals(other$trace)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        String this$credentialExchangeId = this.getCredentialExchangeId();
        String other$credentialExchangeId = other.getCredentialExchangeId();
        if (this$credentialExchangeId == null ? other$credentialExchangeId != null : !this$credentialExchangeId.equals(other$credentialExchangeId)) {
            return false;
        }
        String this$threadId = this.getThreadId();
        String other$threadId = other.getThreadId();
        if (this$threadId == null ? other$threadId != null : !this$threadId.equals(other$threadId)) {
            return false;
        }
        String this$parentThreadId = this.getParentThreadId();
        String other$parentThreadId = other.getParentThreadId();
        if (this$parentThreadId == null ? other$parentThreadId != null : !this$parentThreadId.equals(other$parentThreadId)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) {
            return false;
        }
        CredentialExchangeInitiator this$initiator = this.getInitiator();
        CredentialExchangeInitiator other$initiator = other.getInitiator();
        if (this$initiator == null ? other$initiator != null : !((Object)((Object)this$initiator)).equals((Object)other$initiator)) {
            return false;
        }
        CredentialExchangeRole this$role = this.getRole();
        CredentialExchangeRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        CredentialExchangeState this$state = this.getState();
        CredentialExchangeState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCredExRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $autoIssue = this.getAutoIssue();
        result = result * 59 + ($autoIssue == null ? 43 : ((Object)$autoIssue).hashCode());
        Boolean $autoOffer = this.getAutoOffer();
        result = result * 59 + ($autoOffer == null ? 43 : ((Object)$autoOffer).hashCode());
        Boolean $autoRemove = this.getAutoRemove();
        result = result * 59 + ($autoRemove == null ? 43 : ((Object)$autoRemove).hashCode());
        Boolean $trace = this.getTrace();
        result = result * 59 + ($trace == null ? 43 : ((Object)$trace).hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        String $credentialExchangeId = this.getCredentialExchangeId();
        result = result * 59 + ($credentialExchangeId == null ? 43 : $credentialExchangeId.hashCode());
        String $threadId = this.getThreadId();
        result = result * 59 + ($threadId == null ? 43 : $threadId.hashCode());
        String $parentThreadId = this.getParentThreadId();
        result = result * 59 + ($parentThreadId == null ? 43 : $parentThreadId.hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        CredentialExchangeInitiator $initiator = this.getInitiator();
        result = result * 59 + ($initiator == null ? 43 : ((Object)((Object)$initiator)).hashCode());
        CredentialExchangeRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        CredentialExchangeState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        return result;
    }

    public String toString() {
        return "BaseCredExRecord(autoIssue=" + this.getAutoIssue() + ", autoOffer=" + this.getAutoOffer() + ", autoRemove=" + this.getAutoRemove() + ", trace=" + this.getTrace() + ", connectionId=" + this.getConnectionId() + ", credentialExchangeId=" + this.getCredentialExchangeId() + ", threadId=" + this.getThreadId() + ", parentThreadId=" + this.getParentThreadId() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", initiator=" + this.getInitiator() + ", role=" + this.getRole() + ", state=" + this.getState() + ", errorMsg=" + this.getErrorMsg() + ")";
    }

    public BaseCredExRecord() {
    }

    public BaseCredExRecord(Boolean autoIssue, Boolean autoOffer, Boolean autoRemove, Boolean trace, String connectionId, String credentialExchangeId, String threadId, String parentThreadId, String createdAt, String updatedAt, CredentialExchangeInitiator initiator, CredentialExchangeRole role, CredentialExchangeState state, String errorMsg) {
        this.autoIssue = autoIssue;
        this.autoOffer = autoOffer;
        this.autoRemove = autoRemove;
        this.trace = trace;
        this.connectionId = connectionId;
        this.credentialExchangeId = credentialExchangeId;
        this.threadId = threadId;
        this.parentThreadId = parentThreadId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.initiator = initiator;
        this.role = role;
        this.state = state;
        this.errorMsg = errorMsg;
    }

    public static abstract class BaseCredExRecordBuilder<C extends BaseCredExRecord, B extends BaseCredExRecordBuilder<C, B>> {
        private Boolean autoIssue;
        private Boolean autoOffer;
        private Boolean autoRemove;
        private Boolean trace;
        private String connectionId;
        private String credentialExchangeId;
        private String threadId;
        private String parentThreadId;
        private String createdAt;
        private String updatedAt;
        private CredentialExchangeInitiator initiator;
        private CredentialExchangeRole role;
        private CredentialExchangeState state;
        private String errorMsg;

        protected abstract B self();

        public abstract C build();

        public B autoIssue(Boolean autoIssue) {
            this.autoIssue = autoIssue;
            return this.self();
        }

        public B autoOffer(Boolean autoOffer) {
            this.autoOffer = autoOffer;
            return this.self();
        }

        public B autoRemove(Boolean autoRemove) {
            this.autoRemove = autoRemove;
            return this.self();
        }

        public B trace(Boolean trace) {
            this.trace = trace;
            return this.self();
        }

        public B connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this.self();
        }

        public B credentialExchangeId(String credentialExchangeId) {
            this.credentialExchangeId = credentialExchangeId;
            return this.self();
        }

        public B threadId(String threadId) {
            this.threadId = threadId;
            return this.self();
        }

        public B parentThreadId(String parentThreadId) {
            this.parentThreadId = parentThreadId;
            return this.self();
        }

        public B createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        public B updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        public B initiator(CredentialExchangeInitiator initiator) {
            this.initiator = initiator;
            return this.self();
        }

        public B role(CredentialExchangeRole role) {
            this.role = role;
            return this.self();
        }

        public B state(CredentialExchangeState state) {
            this.state = state;
            return this.self();
        }

        public B errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this.self();
        }

        public String toString() {
            return "BaseCredExRecord.BaseCredExRecordBuilder(autoIssue=" + this.autoIssue + ", autoOffer=" + this.autoOffer + ", autoRemove=" + this.autoRemove + ", trace=" + this.trace + ", connectionId=" + this.connectionId + ", credentialExchangeId=" + this.credentialExchangeId + ", threadId=" + this.threadId + ", parentThreadId=" + this.parentThreadId + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", initiator=" + this.initiator + ", role=" + this.role + ", state=" + this.state + ", errorMsg=" + this.errorMsg + ")";
        }
    }
}

