/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.credentials;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.acy_py.generated.model.CredAttrSpec;
import org.hyperledger.aries.pojo.AttributeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialAttributes {
    private static final Logger log = LoggerFactory.getLogger(CredentialAttributes.class);
    @SerializedName(value="mime-type")
    private String mimeType;
    private String name;
    private String value;

    public CredentialAttributes(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public static <T> List<CredentialAttributes> from(@NonNull T instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        ArrayList<CredentialAttributes> result = new ArrayList<CredentialAttributes>();
        Field[] fields = instance.getClass().getDeclaredFields();
        AccessController.doPrivileged(() -> {
            for (Field field : fields) {
                if (Modifier.isStatic(field.getModifiers()) || !Modifier.isPrivate(field.getModifiers())) continue;
                String fieldName = field.getName();
                AttributeName a = field.getAnnotation(AttributeName.class);
                if (a != null && StringUtils.isNotEmpty((CharSequence)a.value())) {
                    fieldName = a.value();
                }
                if (a != null && a.excluded()) continue;
                String fieldValue = "";
                try {
                    field.setAccessible(true);
                    Object fv = field.get(instance);
                    if (fv != null) {
                        fieldValue = fv.toString();
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    log.error("Could not get value of field: {}", (Object)fieldName, (Object)e);
                }
                result.add(new CredentialAttributes(fieldName, fieldValue));
            }
            return null;
        });
        return result;
    }

    public static List<CredentialAttributes> from(@NonNull Map<String, Object> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        ArrayList<CredentialAttributes> result = new ArrayList<CredentialAttributes>();
        values.forEach((k, v) -> result.add(new CredentialAttributes((String)k, v.toString())));
        return result;
    }

    public static List<CredentialAttributes> fromMap(@NonNull Map<String, String> values) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        ArrayList<CredentialAttributes> result = new ArrayList<CredentialAttributes>();
        values.forEach((k, v) -> result.add(new CredentialAttributes((String)k, (String)v)));
        return result;
    }

    public static Map<String, String> toMap(@NonNull List<CredentialAttributes> attributes) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        return attributes.stream().collect(Collectors.toMap(CredentialAttributes::getName, CredentialAttributes::getValue));
    }

    public CredAttrSpec toCredAttrSpec() {
        return CredAttrSpec.builder().name(this.name).value(this.value).mimeType(this.mimeType).build();
    }

    public static CredentialAttributesBuilder builder() {
        return new CredentialAttributesBuilder();
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CredentialAttributes)) {
            return false;
        }
        CredentialAttributes other = (CredentialAttributes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CredentialAttributes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "CredentialAttributes(mimeType=" + this.getMimeType() + ", name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    public CredentialAttributes() {
    }

    public CredentialAttributes(String mimeType, String name, String value) {
        this.mimeType = mimeType;
        this.name = name;
        this.value = value;
    }

    public static class CredentialAttributesBuilder {
        private String mimeType;
        private String name;
        private String value;

        CredentialAttributesBuilder() {
        }

        public CredentialAttributesBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public CredentialAttributesBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CredentialAttributesBuilder value(String value) {
            this.value = value;
            return this;
        }

        public CredentialAttributes build() {
            return new CredentialAttributes(this.mimeType, this.name, this.value);
        }

        public String toString() {
            return "CredentialAttributes.CredentialAttributesBuilder(mimeType=" + this.mimeType + ", name=" + this.name + ", value=" + this.value + ")";
        }
    }
}

