/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.credentials;

import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.hyperledger.aries.pojo.PojoProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Credential {
    private static final Logger log = LoggerFactory.getLogger(Credential.class);
    private Map<String, String> attrs;
    @SerializedName(value="credential_definition_id", alternate={"cred_def_id", "credentialDefinitionId"})
    private String credentialDefinitionId;
    private String credRevId;
    private String referent;
    private String revRegId;
    private String schemaId;

    public <T> T to(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        Object result = PojoProcessor.getInstance(type);
        Set<Field> fields = PojoProcessor.fields(type);
        AccessController.doPrivileged(() -> {
            for (Field field : fields) {
                String fieldName = PojoProcessor.fieldName(field);
                String fieldValue = this.attrs.get(fieldName);
                try {
                    field.setAccessible(true);
                    field.set(result, fieldValue);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    log.error("Could not set value of field: {} to: {}", new Object[]{fieldName, fieldValue, e});
                }
            }
            return null;
        });
        return result;
    }

    public static CredentialBuilder builder() {
        return new CredentialBuilder();
    }

    public Map<String, String> getAttrs() {
        return this.attrs;
    }

    public String getCredentialDefinitionId() {
        return this.credentialDefinitionId;
    }

    public String getCredRevId() {
        return this.credRevId;
    }

    public String getReferent() {
        return this.referent;
    }

    public String getRevRegId() {
        return this.revRegId;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public void setAttrs(Map<String, String> attrs) {
        this.attrs = attrs;
    }

    public void setCredentialDefinitionId(String credentialDefinitionId) {
        this.credentialDefinitionId = credentialDefinitionId;
    }

    public void setCredRevId(String credRevId) {
        this.credRevId = credRevId;
    }

    public void setReferent(String referent) {
        this.referent = referent;
    }

    public void setRevRegId(String revRegId) {
        this.revRegId = revRegId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credential)) {
            return false;
        }
        Credential other = (Credential)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$attrs = this.getAttrs();
        Map<String, String> other$attrs = other.getAttrs();
        if (this$attrs == null ? other$attrs != null : !((Object)this$attrs).equals(other$attrs)) {
            return false;
        }
        String this$credentialDefinitionId = this.getCredentialDefinitionId();
        String other$credentialDefinitionId = other.getCredentialDefinitionId();
        if (this$credentialDefinitionId == null ? other$credentialDefinitionId != null : !this$credentialDefinitionId.equals(other$credentialDefinitionId)) {
            return false;
        }
        String this$credRevId = this.getCredRevId();
        String other$credRevId = other.getCredRevId();
        if (this$credRevId == null ? other$credRevId != null : !this$credRevId.equals(other$credRevId)) {
            return false;
        }
        String this$referent = this.getReferent();
        String other$referent = other.getReferent();
        if (this$referent == null ? other$referent != null : !this$referent.equals(other$referent)) {
            return false;
        }
        String this$revRegId = this.getRevRegId();
        String other$revRegId = other.getRevRegId();
        if (this$revRegId == null ? other$revRegId != null : !this$revRegId.equals(other$revRegId)) {
            return false;
        }
        String this$schemaId = this.getSchemaId();
        String other$schemaId = other.getSchemaId();
        return !(this$schemaId == null ? other$schemaId != null : !this$schemaId.equals(other$schemaId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Credential;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $attrs = this.getAttrs();
        result = result * 59 + ($attrs == null ? 43 : ((Object)$attrs).hashCode());
        String $credentialDefinitionId = this.getCredentialDefinitionId();
        result = result * 59 + ($credentialDefinitionId == null ? 43 : $credentialDefinitionId.hashCode());
        String $credRevId = this.getCredRevId();
        result = result * 59 + ($credRevId == null ? 43 : $credRevId.hashCode());
        String $referent = this.getReferent();
        result = result * 59 + ($referent == null ? 43 : $referent.hashCode());
        String $revRegId = this.getRevRegId();
        result = result * 59 + ($revRegId == null ? 43 : $revRegId.hashCode());
        String $schemaId = this.getSchemaId();
        result = result * 59 + ($schemaId == null ? 43 : $schemaId.hashCode());
        return result;
    }

    public String toString() {
        return "Credential(attrs=" + this.getAttrs() + ", credentialDefinitionId=" + this.getCredentialDefinitionId() + ", credRevId=" + this.getCredRevId() + ", referent=" + this.getReferent() + ", revRegId=" + this.getRevRegId() + ", schemaId=" + this.getSchemaId() + ")";
    }

    public Credential() {
    }

    public Credential(Map<String, String> attrs, String credentialDefinitionId, String credRevId, String referent, String revRegId, String schemaId) {
        this.attrs = attrs;
        this.credentialDefinitionId = credentialDefinitionId;
        this.credRevId = credRevId;
        this.referent = referent;
        this.revRegId = revRegId;
        this.schemaId = schemaId;
    }

    public static class CredentialBuilder {
        private Map<String, String> attrs;
        private String credentialDefinitionId;
        private String credRevId;
        private String referent;
        private String revRegId;
        private String schemaId;

        CredentialBuilder() {
        }

        public CredentialBuilder attrs(Map<String, String> attrs) {
            this.attrs = attrs;
            return this;
        }

        public CredentialBuilder credentialDefinitionId(String credentialDefinitionId) {
            this.credentialDefinitionId = credentialDefinitionId;
            return this;
        }

        public CredentialBuilder credRevId(String credRevId) {
            this.credRevId = credRevId;
            return this;
        }

        public CredentialBuilder referent(String referent) {
            this.referent = referent;
            return this;
        }

        public CredentialBuilder revRegId(String revRegId) {
            this.revRegId = revRegId;
            return this;
        }

        public CredentialBuilder schemaId(String schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public Credential build() {
            return new Credential(this.attrs, this.credentialDefinitionId, this.credRevId, this.referent, this.revRegId, this.schemaId);
        }

        public String toString() {
            return "Credential.CredentialBuilder(attrs=" + this.attrs + ", credentialDefinitionId=" + this.credentialDefinitionId + ", credRevId=" + this.credRevId + ", referent=" + this.referent + ", revRegId=" + this.revRegId + ", schemaId=" + this.schemaId + ")";
        }
    }

    public static final class CredentialRevokedResult {
        private Boolean revoked;

        public Boolean getRevoked() {
            return this.revoked;
        }

        public void setRevoked(Boolean revoked) {
            this.revoked = revoked;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CredentialRevokedResult)) {
                return false;
            }
            CredentialRevokedResult other = (CredentialRevokedResult)o;
            Boolean this$revoked = this.getRevoked();
            Boolean other$revoked = other.getRevoked();
            return !(this$revoked == null ? other$revoked != null : !((Object)this$revoked).equals(other$revoked));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $revoked = this.getRevoked();
            result = result * 59 + ($revoked == null ? 43 : ((Object)$revoked).hashCode());
            return result;
        }

        public String toString() {
            return "Credential.CredentialRevokedResult(revoked=" + this.getRevoked() + ")";
        }

        public CredentialRevokedResult() {
        }

        public CredentialRevokedResult(Boolean revoked) {
            this.revoked = revoked;
        }
    }
}

