/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api.connection;

import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.api.connection.ConnectionAcceptance;
import org.hyperledger.aries.api.connection.ConnectionState;
import org.hyperledger.aries.api.connection.ConnectionTheirRole;

public class ConnectionRecord {
    private ConnectionAcceptance accept;
    private String alias;
    private String connectionId;
    private ConnectionProtocol connectionProtocol;
    private String createdAt;
    private String errorMsg;
    private String inboundConnectionId;
    private String invitationKey;
    private InvitationMode invitationMode;
    private String invitationMsgId;
    private String myDid;
    private String requestId;
    private String rfc23Sate;
    private RoutingState routingState;
    private ConnectionState state;
    private String theirDid;
    private String theirLabel;
    private String theirPublicDid;
    private ConnectionTheirRole theirRole;
    private String updatedAt;

    public boolean isIncomingConnection() {
        return StringUtils.isNotEmpty((CharSequence)this.invitationKey);
    }

    public boolean isOutgoingConnection() {
        return StringUtils.isEmpty((CharSequence)this.invitationKey);
    }

    public boolean isInvitationResponse() {
        return StringUtils.isNotEmpty((CharSequence)this.invitationMsgId) && (ConnectionTheirRole.INVITER.equals((Object)this.theirRole) || ConnectionTheirRole.RESPONDER.equals((Object)this.theirRole));
    }

    public boolean isInvitationRequest() {
        return StringUtils.isNotEmpty((CharSequence)this.invitationMsgId) && (ConnectionTheirRole.INVITEE.equals((Object)this.theirRole) || ConnectionTheirRole.REQUESTER.equals((Object)this.theirRole));
    }

    public boolean isRequestToConnect() {
        return ConnectionAcceptance.MANUAL.equals((Object)this.accept) && ConnectionState.REQUEST.equals((Object)this.state);
    }

    public boolean stateIsInvitation() {
        return ConnectionState.INVITATION.equals((Object)this.state);
    }

    public boolean stateIsRequest() {
        return ConnectionState.REQUEST.equals((Object)this.state);
    }

    public boolean stateIsResponse() {
        return ConnectionState.RESPONSE.equals((Object)this.state);
    }

    public boolean stateIsActive() {
        return ConnectionState.ACTIVE.equals((Object)this.state);
    }

    public boolean stateIsCompleted() {
        return ConnectionState.COMPLETED.equals((Object)this.state);
    }

    public boolean protocolIsConnectionV1() {
        return ConnectionProtocol.CONNECTION_V1.equals((Object)this.connectionProtocol);
    }

    public boolean protocolIsIdDidExchangeV1() {
        return ConnectionProtocol.DID_EXCHANGE_V1.equals((Object)this.connectionProtocol);
    }

    public ConnectionAcceptance getAccept() {
        return this.accept;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public ConnectionProtocol getConnectionProtocol() {
        return this.connectionProtocol;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public String getInboundConnectionId() {
        return this.inboundConnectionId;
    }

    public String getInvitationKey() {
        return this.invitationKey;
    }

    public InvitationMode getInvitationMode() {
        return this.invitationMode;
    }

    public String getInvitationMsgId() {
        return this.invitationMsgId;
    }

    public String getMyDid() {
        return this.myDid;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRfc23Sate() {
        return this.rfc23Sate;
    }

    public RoutingState getRoutingState() {
        return this.routingState;
    }

    public ConnectionState getState() {
        return this.state;
    }

    public String getTheirDid() {
        return this.theirDid;
    }

    public String getTheirLabel() {
        return this.theirLabel;
    }

    public String getTheirPublicDid() {
        return this.theirPublicDid;
    }

    public ConnectionTheirRole getTheirRole() {
        return this.theirRole;
    }

    public String getUpdatedAt() {
        return this.updatedAt;
    }

    public ConnectionRecord setAccept(ConnectionAcceptance accept) {
        this.accept = accept;
        return this;
    }

    public ConnectionRecord setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public ConnectionRecord setConnectionId(String connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    public ConnectionRecord setConnectionProtocol(ConnectionProtocol connectionProtocol) {
        this.connectionProtocol = connectionProtocol;
        return this;
    }

    public ConnectionRecord setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public ConnectionRecord setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
        return this;
    }

    public ConnectionRecord setInboundConnectionId(String inboundConnectionId) {
        this.inboundConnectionId = inboundConnectionId;
        return this;
    }

    public ConnectionRecord setInvitationKey(String invitationKey) {
        this.invitationKey = invitationKey;
        return this;
    }

    public ConnectionRecord setInvitationMode(InvitationMode invitationMode) {
        this.invitationMode = invitationMode;
        return this;
    }

    public ConnectionRecord setInvitationMsgId(String invitationMsgId) {
        this.invitationMsgId = invitationMsgId;
        return this;
    }

    public ConnectionRecord setMyDid(String myDid) {
        this.myDid = myDid;
        return this;
    }

    public ConnectionRecord setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ConnectionRecord setRfc23Sate(String rfc23Sate) {
        this.rfc23Sate = rfc23Sate;
        return this;
    }

    public ConnectionRecord setRoutingState(RoutingState routingState) {
        this.routingState = routingState;
        return this;
    }

    public ConnectionRecord setState(ConnectionState state) {
        this.state = state;
        return this;
    }

    public ConnectionRecord setTheirDid(String theirDid) {
        this.theirDid = theirDid;
        return this;
    }

    public ConnectionRecord setTheirLabel(String theirLabel) {
        this.theirLabel = theirLabel;
        return this;
    }

    public ConnectionRecord setTheirPublicDid(String theirPublicDid) {
        this.theirPublicDid = theirPublicDid;
        return this;
    }

    public ConnectionRecord setTheirRole(ConnectionTheirRole theirRole) {
        this.theirRole = theirRole;
        return this;
    }

    public ConnectionRecord setUpdatedAt(String updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectionRecord)) {
            return false;
        }
        ConnectionRecord other = (ConnectionRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConnectionAcceptance this$accept = this.getAccept();
        ConnectionAcceptance other$accept = other.getAccept();
        if (this$accept == null ? other$accept != null : !((Object)((Object)this$accept)).equals((Object)other$accept)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$connectionId = this.getConnectionId();
        String other$connectionId = other.getConnectionId();
        if (this$connectionId == null ? other$connectionId != null : !this$connectionId.equals(other$connectionId)) {
            return false;
        }
        ConnectionProtocol this$connectionProtocol = this.getConnectionProtocol();
        ConnectionProtocol other$connectionProtocol = other.getConnectionProtocol();
        if (this$connectionProtocol == null ? other$connectionProtocol != null : !((Object)((Object)this$connectionProtocol)).equals((Object)other$connectionProtocol)) {
            return false;
        }
        String this$createdAt = this.getCreatedAt();
        String other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) {
            return false;
        }
        String this$errorMsg = this.getErrorMsg();
        String other$errorMsg = other.getErrorMsg();
        if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
            return false;
        }
        String this$inboundConnectionId = this.getInboundConnectionId();
        String other$inboundConnectionId = other.getInboundConnectionId();
        if (this$inboundConnectionId == null ? other$inboundConnectionId != null : !this$inboundConnectionId.equals(other$inboundConnectionId)) {
            return false;
        }
        String this$invitationKey = this.getInvitationKey();
        String other$invitationKey = other.getInvitationKey();
        if (this$invitationKey == null ? other$invitationKey != null : !this$invitationKey.equals(other$invitationKey)) {
            return false;
        }
        InvitationMode this$invitationMode = this.getInvitationMode();
        InvitationMode other$invitationMode = other.getInvitationMode();
        if (this$invitationMode == null ? other$invitationMode != null : !((Object)((Object)this$invitationMode)).equals((Object)other$invitationMode)) {
            return false;
        }
        String this$invitationMsgId = this.getInvitationMsgId();
        String other$invitationMsgId = other.getInvitationMsgId();
        if (this$invitationMsgId == null ? other$invitationMsgId != null : !this$invitationMsgId.equals(other$invitationMsgId)) {
            return false;
        }
        String this$myDid = this.getMyDid();
        String other$myDid = other.getMyDid();
        if (this$myDid == null ? other$myDid != null : !this$myDid.equals(other$myDid)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$rfc23Sate = this.getRfc23Sate();
        String other$rfc23Sate = other.getRfc23Sate();
        if (this$rfc23Sate == null ? other$rfc23Sate != null : !this$rfc23Sate.equals(other$rfc23Sate)) {
            return false;
        }
        RoutingState this$routingState = this.getRoutingState();
        RoutingState other$routingState = other.getRoutingState();
        if (this$routingState == null ? other$routingState != null : !((Object)((Object)this$routingState)).equals((Object)other$routingState)) {
            return false;
        }
        ConnectionState this$state = this.getState();
        ConnectionState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$theirDid = this.getTheirDid();
        String other$theirDid = other.getTheirDid();
        if (this$theirDid == null ? other$theirDid != null : !this$theirDid.equals(other$theirDid)) {
            return false;
        }
        String this$theirLabel = this.getTheirLabel();
        String other$theirLabel = other.getTheirLabel();
        if (this$theirLabel == null ? other$theirLabel != null : !this$theirLabel.equals(other$theirLabel)) {
            return false;
        }
        String this$theirPublicDid = this.getTheirPublicDid();
        String other$theirPublicDid = other.getTheirPublicDid();
        if (this$theirPublicDid == null ? other$theirPublicDid != null : !this$theirPublicDid.equals(other$theirPublicDid)) {
            return false;
        }
        ConnectionTheirRole this$theirRole = this.getTheirRole();
        ConnectionTheirRole other$theirRole = other.getTheirRole();
        if (this$theirRole == null ? other$theirRole != null : !((Object)((Object)this$theirRole)).equals((Object)other$theirRole)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectionRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionAcceptance $accept = this.getAccept();
        result = result * 59 + ($accept == null ? 43 : ((Object)((Object)$accept)).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $connectionId = this.getConnectionId();
        result = result * 59 + ($connectionId == null ? 43 : $connectionId.hashCode());
        ConnectionProtocol $connectionProtocol = this.getConnectionProtocol();
        result = result * 59 + ($connectionProtocol == null ? 43 : ((Object)((Object)$connectionProtocol)).hashCode());
        String $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : $createdAt.hashCode());
        String $errorMsg = this.getErrorMsg();
        result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
        String $inboundConnectionId = this.getInboundConnectionId();
        result = result * 59 + ($inboundConnectionId == null ? 43 : $inboundConnectionId.hashCode());
        String $invitationKey = this.getInvitationKey();
        result = result * 59 + ($invitationKey == null ? 43 : $invitationKey.hashCode());
        InvitationMode $invitationMode = this.getInvitationMode();
        result = result * 59 + ($invitationMode == null ? 43 : ((Object)((Object)$invitationMode)).hashCode());
        String $invitationMsgId = this.getInvitationMsgId();
        result = result * 59 + ($invitationMsgId == null ? 43 : $invitationMsgId.hashCode());
        String $myDid = this.getMyDid();
        result = result * 59 + ($myDid == null ? 43 : $myDid.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $rfc23Sate = this.getRfc23Sate();
        result = result * 59 + ($rfc23Sate == null ? 43 : $rfc23Sate.hashCode());
        RoutingState $routingState = this.getRoutingState();
        result = result * 59 + ($routingState == null ? 43 : ((Object)((Object)$routingState)).hashCode());
        ConnectionState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $theirDid = this.getTheirDid();
        result = result * 59 + ($theirDid == null ? 43 : $theirDid.hashCode());
        String $theirLabel = this.getTheirLabel();
        result = result * 59 + ($theirLabel == null ? 43 : $theirLabel.hashCode());
        String $theirPublicDid = this.getTheirPublicDid();
        result = result * 59 + ($theirPublicDid == null ? 43 : $theirPublicDid.hashCode());
        ConnectionTheirRole $theirRole = this.getTheirRole();
        result = result * 59 + ($theirRole == null ? 43 : ((Object)((Object)$theirRole)).hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        return result;
    }

    public String toString() {
        return "ConnectionRecord(accept=" + this.getAccept() + ", alias=" + this.getAlias() + ", connectionId=" + this.getConnectionId() + ", connectionProtocol=" + this.getConnectionProtocol() + ", createdAt=" + this.getCreatedAt() + ", errorMsg=" + this.getErrorMsg() + ", inboundConnectionId=" + this.getInboundConnectionId() + ", invitationKey=" + this.getInvitationKey() + ", invitationMode=" + this.getInvitationMode() + ", invitationMsgId=" + this.getInvitationMsgId() + ", myDid=" + this.getMyDid() + ", requestId=" + this.getRequestId() + ", rfc23Sate=" + this.getRfc23Sate() + ", routingState=" + this.getRoutingState() + ", state=" + this.getState() + ", theirDid=" + this.getTheirDid() + ", theirLabel=" + this.getTheirLabel() + ", theirPublicDid=" + this.getTheirPublicDid() + ", theirRole=" + this.getTheirRole() + ", updatedAt=" + this.getUpdatedAt() + ")";
    }

    public static enum ConnectionProtocol {
        CONNECTION_V1("connections/1.0"),
        DID_EXCHANGE_V1("didexchange/1.0");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private ConnectionProtocol(String value) {
            this.value = value;
        }
    }

    public static enum RoutingState {
        NONE,
        REQUEST,
        ACTIVE,
        ERROR;

    }

    public static enum InvitationMode {
        ONCE,
        MULTI,
        STATIC;

    }
}

