/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries.api;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Set;
import lombok.NonNull;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.hyperledger.aries.pojo.PojoProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AcaPyRequestFilter {
    public static final Logger log = LoggerFactory.getLogger(AcaPyRequestFilter.class);

    default public HttpUrl.Builder buildParams(@NonNull HttpUrl.Builder b) {
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        Set<Field> fields = PojoProcessor.fields(this.getClass());
        fields.forEach(f -> {
            try {
                f.setAccessible(true);
                Object o = f.get(this);
                if (o != null) {
                    String value = null;
                    if (f.getType().isAssignableFrom(String.class)) {
                        value = (String)o;
                    } else if (f.getType().isEnum()) {
                        SerializedName sn;
                        Field field = FieldUtils.getDeclaredField(o.getClass(), (String)o.toString());
                        if (field != null && (sn = field.getAnnotation(SerializedName.class)) != null) {
                            value = sn.value();
                        }
                        if (value == null) {
                            value = o.toString().toLowerCase(Locale.US);
                        }
                    } else if (f.getType().isAssignableFrom(Boolean.class)) {
                        value = ((Boolean)o).toString().toLowerCase(Locale.US);
                    }
                    if (value != null) {
                        b.addQueryParameter(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES.translateName(f), value);
                    }
                }
            }
            catch (IllegalAccessException e) {
                log.error("Cold not extract value for field: {}", (Object)f.getName(), (Object)e);
            }
        });
        return b;
    }
}

