/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries;

import lombok.NonNull;
import org.hyperledger.aries.AriesClient;
import org.hyperledger.aries.AriesWebSocketClient;
import org.hyperledger.aries.api.multitenancy.WalletRecord;

public class ClientToTenant
extends WalletRecord
implements AutoCloseable {
    private final AriesClient restClient;
    private final AriesWebSocketClient webSocketClient;

    public ClientToTenant(@NonNull AriesClient restClient, @NonNull AriesWebSocketClient webSocketClient, @NonNull WalletRecord walletRecord) {
        if (restClient == null) {
            throw new NullPointerException("restClient is marked non-null but is null");
        }
        if (webSocketClient == null) {
            throw new NullPointerException("webSocketClient is marked non-null but is null");
        }
        if (walletRecord == null) {
            throw new NullPointerException("walletRecord is marked non-null but is null");
        }
        this.restClient = restClient;
        this.webSocketClient = webSocketClient;
        this.setCreatedAt(walletRecord.getCreatedAt());
        this.setKeyManagementMode(walletRecord.getKeyManagementMode());
        this.setSettings(walletRecord.getSettings());
        this.setState(walletRecord.getState());
        this.setToken(walletRecord.getToken());
        this.setUpdatedAt(walletRecord.getUpdatedAt());
        this.setWalletId(walletRecord.getWalletId());
    }

    public AriesClient send() {
        return this.restClient;
    }

    public AriesWebSocketClient receive() {
        return this.webSocketClient;
    }

    @Override
    public void close() {
        this.webSocketClient.close();
    }

    @Override
    public String toString() {
        return "ClientToTenant(super=" + super.toString() + ", restClient=" + this.restClient + ", webSocketClient=" + this.webSocketClient + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientToTenant)) {
            return false;
        }
        ClientToTenant other = (ClientToTenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AriesClient this$restClient = this.restClient;
        AriesClient other$restClient = other.restClient;
        if (this$restClient == null ? other$restClient != null : !this$restClient.equals(other$restClient)) {
            return false;
        }
        AriesWebSocketClient this$webSocketClient = this.webSocketClient;
        AriesWebSocketClient other$webSocketClient = other.webSocketClient;
        return !(this$webSocketClient == null ? other$webSocketClient != null : !this$webSocketClient.equals(other$webSocketClient));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClientToTenant;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        AriesClient $restClient = this.restClient;
        result = result * 59 + ($restClient == null ? 43 : $restClient.hashCode());
        AriesWebSocketClient $webSocketClient = this.webSocketClient;
        result = result * 59 + ($webSocketClient == null ? 43 : $webSocketClient.hashCode());
        return result;
    }
}

