/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.acy_py.generated.model.MediationRecord;
import org.hyperledger.acy_py.generated.model.RouteRecord;
import org.hyperledger.acy_py.generated.model.V20CredExRecordDetail;
import org.hyperledger.acy_py.generated.model.V20PresExRecord;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.credentials.Credential;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.exception.AriesException;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.jsonld.ErrorResponse;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof.PresentationRequestCredentials;
import org.hyperledger.aries.config.GsonConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseClient {
    private static final Logger log = LoggerFactory.getLogger(BaseClient.class);
    static final MediaType JSON_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    static final Type CONNECTION_TYPE = new TypeToken<Collection<ConnectionRecord>>(){}.getType();
    static final Type CREDENTIAL_TYPE = new TypeToken<Collection<Credential>>(){}.getType();
    static final Type ISSUE_CREDENTIAL_TYPE = new TypeToken<Collection<V1CredentialExchange>>(){}.getType();
    static final Type ISSUE_CREDENTIAL_V2_TYPE = new TypeToken<Collection<V20CredExRecordDetail>>(){}.getType();
    static final Type KEY_LISTS_TYPE = new TypeToken<Collection<RouteRecord>>(){}.getType();
    static final Type MEDIATION_LIST_TYPE = new TypeToken<Collection<MediationRecord>>(){}.getType();
    static final Type PRESENTATION_REQUEST_CREDENTIALS_INDY = new TypeToken<Collection<PresentationRequestCredentials>>(){}.getType();
    static final Type PRESENTATION_REQUEST_CREDENTIALS_DIF = new TypeToken<Collection<VerifiableCredential.VerifiableCredentialMatch>>(){}.getType();
    static final Type PROOF_TYPE = new TypeToken<Collection<PresentationExchangeRecord>>(){}.getType();
    static final Type PROOF_TYPE_V2 = new TypeToken<Collection<V20PresExRecord>>(){}.getType();
    static final Type TRX_RECORD_TYPE = new TypeToken<Collection<EndorseTransactionRecord>>(){}.getType();
    static final Type WALLET_DID_TYPE = new TypeToken<Collection<DID>>(){}.getType();
    static final Type WALLET_RECORD_TYPE = new TypeToken<Collection<WalletRecord>>(){}.getType();
    static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    static final String X_API_KEY = "X-API-Key";
    static final String AUTHORIZATION = "Authorization";
    static final String BEARER = "Bearer ";
    public static final String EMPTY_JSON = "{}";
    final Gson gson = GsonConfig.defaultConfig();
    final OkHttpClient client;

    BaseClient(@Nullable OkHttpClient client) {
        this.client = Objects.requireNonNullElseGet(client, () -> new OkHttpClient.Builder().writeTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).connectTimeout(60L, TimeUnit.SECONDS).callTimeout(60L, TimeUnit.SECONDS).addInterceptor((Interceptor)this.defaultLoggingInterceptor()).build());
    }

    private HttpLoggingInterceptor defaultLoggingInterceptor() {
        Gson pretty = GsonConfig.prettyPrinter();
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor(msg -> {
            if (log.isTraceEnabled() && StringUtils.isNotEmpty((CharSequence)msg)) {
                if (msg.startsWith("{")) {
                    try {
                        Object json = this.gson.fromJson(msg, Object.class);
                        log.trace("\n{}", (Object)pretty.toJson(json));
                    }
                    catch (JsonSyntaxException e) {
                        log.trace(EMPTY_JSON, (Object)msg);
                    }
                } else {
                    log.trace(EMPTY_JSON, (Object)msg);
                }
            }
        });
        logging.level(HttpLoggingInterceptor.Level.BODY);
        logging.redactHeader(X_API_KEY);
        logging.redactHeader(AUTHORIZATION);
        return logging;
    }

    static RequestBody jsonBody(String json) {
        return RequestBody.create((String)json, (MediaType)JSON_TYPE);
    }

    <T> Optional<T> call(Request req, Class<T> t) throws IOException {
        return this.call(req, (Type)t);
    }

    <T> Optional<T> call(Request req, Type t) throws IOException {
        Optional<Object> result = Optional.empty();
        try (Response resp = this.client.newCall(req).execute();){
            if (resp.isSuccessful() && resp.body() != null) {
                result = Optional.of(this.gson.fromJson(resp.body().string(), t));
            } else if (!resp.isSuccessful()) {
                BaseClient.handleError(resp);
            }
        }
        return result;
    }

    Optional<String> raw(Request req) throws IOException {
        Optional<String> result = Optional.empty();
        try (Response resp = this.client.newCall(req).execute();){
            if (resp.isSuccessful() && resp.body() != null) {
                result = Optional.of(resp.body().string());
            } else if (!resp.isSuccessful()) {
                BaseClient.handleError(resp);
            }
        }
        return result;
    }

    void call(Request req) throws IOException {
        try (Response resp = this.client.newCall(req).execute();){
            if (!resp.isSuccessful()) {
                BaseClient.handleError(resp);
            }
        }
    }

    public <T> Optional<T> getWrapped(Optional<String> json, String field, Type t) {
        if (json.isPresent()) {
            JsonElement je = JsonParser.parseString((String)json.get()).getAsJsonObject().get(field);
            return Optional.ofNullable(this.gson.fromJson(je, t));
        }
        return Optional.empty();
    }

    public void checkForError(Optional<String> json) {
        ErrorResponse error;
        if (json.isPresent() && (error = (ErrorResponse)this.gson.fromJson(json.get(), ErrorResponse.class)) != null && error.getError() != null) {
            throw new AriesException(0, error.getError());
        }
    }

    private static void handleError(Response resp) throws IOException {
        String msg = StringUtils.isNotEmpty((CharSequence)resp.message()) ? resp.message() : "";
        String body = resp.body() != null ? resp.body().string() : "";
        log.error("code={} message={}\nbody={}", new Object[]{resp.code(), msg, body});
        throw new AriesException(resp.code(), msg + "\n" + body);
    }
}

