/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.aries.webhook.AriesWebSocketListener;
import org.hyperledger.aries.webhook.EventHandler;
import org.hyperledger.aries.webhook.IEventHandler;
import org.hyperledger.aries.webhook.ReactiveEventHandler;
import org.jetbrains.annotations.NotNull;

public class AriesWebSocketClient
extends ReactiveEventHandler
implements AutoCloseable {
    private final OkHttpClient client;
    private final String url;
    private final String apiKey;
    private final String bearerToken;
    private final List<IEventHandler> handler;
    private final List<String> walletIdFilter;
    private WebSocket webSocket;

    public AriesWebSocketClient(@Nullable String url, @Nullable String apiKey, @Nullable String bearerToken, @Nullable OkHttpClient client, List<IEventHandler> handler, @Nullable List<String> walletIdFilter) {
        this.client = Objects.requireNonNullElseGet(client, OkHttpClient::new);
        this.url = StringUtils.isEmpty((CharSequence)url) ? "ws://localhost:8031/ws" : StringUtils.trim((String)url);
        this.apiKey = StringUtils.trimToEmpty((String)apiKey);
        this.bearerToken = StringUtils.trimToEmpty((String)bearerToken);
        this.walletIdFilter = walletIdFilter != null ? Collections.unmodifiableList(walletIdFilter) : null;
        this.handler = this.mergeHandler(handler);
        this.openWebSocket();
    }

    private void openWebSocket() {
        Request.Builder b = new Request.Builder();
        b.url(this.url);
        if (this.apiKey != null) {
            b.header("X-API-Key", this.apiKey);
        }
        if (this.bearerToken != null) {
            b.header("Authorization", "Bearer " + this.bearerToken);
        }
        this.webSocket = this.client.newWebSocket(b.build(), (WebSocketListener)AriesWebSocketListener.builder().handler(this.handler).walletIdFilter(this.walletIdFilter).build());
    }

    @Override
    public void close() {
        if (this.webSocket != null) {
            this.webSocket.close(1001, null);
        }
    }

    @NotNull
    private List<IEventHandler> mergeHandler(List<IEventHandler> handler) {
        ArrayList<IEventHandler> tempHandler = new ArrayList<IEventHandler>();
        tempHandler.add(this);
        tempHandler.addAll(handler.isEmpty() ? List.of(new EventHandler.DefaultEventHandler()) : handler);
        return Collections.unmodifiableList(tempHandler);
    }

    public static AriesWebSocketClientBuilder builder() {
        return new AriesWebSocketClientBuilder();
    }

    public static class AriesWebSocketClientBuilder {
        private String url;
        private String apiKey;
        private String bearerToken;
        private OkHttpClient client;
        private ArrayList<IEventHandler> handler;
        private ArrayList<String> walletIdFilter;

        AriesWebSocketClientBuilder() {
        }

        public AriesWebSocketClientBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public AriesWebSocketClientBuilder apiKey(@Nullable String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AriesWebSocketClientBuilder bearerToken(@Nullable String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public AriesWebSocketClientBuilder client(@Nullable OkHttpClient client) {
            this.client = client;
            return this;
        }

        public AriesWebSocketClientBuilder handler(IEventHandler handler) {
            if (this.handler == null) {
                this.handler = new ArrayList();
            }
            this.handler.add(handler);
            return this;
        }

        public AriesWebSocketClientBuilder handler(Collection<? extends IEventHandler> handler) {
            if (handler == null) {
                throw new NullPointerException("handler cannot be null");
            }
            if (this.handler == null) {
                this.handler = new ArrayList();
            }
            this.handler.addAll(handler);
            return this;
        }

        public AriesWebSocketClientBuilder clearHandler() {
            if (this.handler != null) {
                this.handler.clear();
            }
            return this;
        }

        public AriesWebSocketClientBuilder walletId(String walletId) {
            if (this.walletIdFilter == null) {
                this.walletIdFilter = new ArrayList();
            }
            this.walletIdFilter.add(walletId);
            return this;
        }

        public AriesWebSocketClientBuilder walletIdFilter(Collection<? extends String> walletIdFilter) {
            if (walletIdFilter == null) {
                throw new NullPointerException("walletIdFilter cannot be null");
            }
            if (this.walletIdFilter == null) {
                this.walletIdFilter = new ArrayList();
            }
            this.walletIdFilter.addAll(walletIdFilter);
            return this;
        }

        public AriesWebSocketClientBuilder clearWalletIdFilter() {
            if (this.walletIdFilter != null) {
                this.walletIdFilter.clear();
            }
            return this;
        }

        public AriesWebSocketClient build() {
            List<String> walletIdFilter;
            List<IEventHandler> handler;
            switch (this.handler == null ? 0 : this.handler.size()) {
                case 0: {
                    handler = Collections.emptyList();
                    break;
                }
                case 1: {
                    handler = Collections.singletonList(this.handler.get(0));
                    break;
                }
                default: {
                    handler = Collections.unmodifiableList(new ArrayList<IEventHandler>(this.handler));
                }
            }
            switch (this.walletIdFilter == null ? 0 : this.walletIdFilter.size()) {
                case 0: {
                    walletIdFilter = Collections.emptyList();
                    break;
                }
                case 1: {
                    walletIdFilter = Collections.singletonList(this.walletIdFilter.get(0));
                    break;
                }
                default: {
                    walletIdFilter = Collections.unmodifiableList(new ArrayList<String>(this.walletIdFilter));
                }
            }
            return new AriesWebSocketClient(this.url, this.apiKey, this.bearerToken, this.client, handler, walletIdFilter);
        }

        public String toString() {
            return "AriesWebSocketClient.AriesWebSocketClientBuilder(url=" + this.url + ", apiKey=" + this.apiKey + ", bearerToken=" + this.bearerToken + ", client=" + this.client + ", handler=" + this.handler + ", walletIdFilter=" + this.walletIdFilter + ")";
        }
    }
}

