/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.aries;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.hyperledger.acy_py.generated.model.AdminMediationDeny;
import org.hyperledger.acy_py.generated.model.ClearPendingRevocationsRequest;
import org.hyperledger.acy_py.generated.model.CredRevIndyRecordsResult;
import org.hyperledger.acy_py.generated.model.CredRevRecordDetailsResult;
import org.hyperledger.acy_py.generated.model.CredentialDefinitionGetResult;
import org.hyperledger.acy_py.generated.model.DID;
import org.hyperledger.acy_py.generated.model.DIDEndpoint;
import org.hyperledger.acy_py.generated.model.DIDEndpointWithType;
import org.hyperledger.acy_py.generated.model.EndorserInfo;
import org.hyperledger.acy_py.generated.model.GetNymRoleResponse;
import org.hyperledger.acy_py.generated.model.InvitationRecord;
import org.hyperledger.acy_py.generated.model.IssuerRevRegRecord;
import org.hyperledger.acy_py.generated.model.KeylistQuery;
import org.hyperledger.acy_py.generated.model.KeylistQueryFilterRequest;
import org.hyperledger.acy_py.generated.model.KeylistUpdate;
import org.hyperledger.acy_py.generated.model.KeylistUpdateRequest;
import org.hyperledger.acy_py.generated.model.MediationCreateRequest;
import org.hyperledger.acy_py.generated.model.MediationDeny;
import org.hyperledger.acy_py.generated.model.MediationGrant;
import org.hyperledger.acy_py.generated.model.MediationRecord;
import org.hyperledger.acy_py.generated.model.PublishRevocations;
import org.hyperledger.acy_py.generated.model.RevRegIssuedResult;
import org.hyperledger.acy_py.generated.model.RevRegWalletUpdatedResult;
import org.hyperledger.acy_py.generated.model.RouteRecord;
import org.hyperledger.acy_py.generated.model.SendMessage;
import org.hyperledger.acy_py.generated.model.TransactionJobs;
import org.hyperledger.acy_py.generated.model.TxnOrCredentialDefinitionSendResult;
import org.hyperledger.acy_py.generated.model.TxnOrPublishRevocationsResult;
import org.hyperledger.acy_py.generated.model.TxnOrRegisterLedgerNymResponse;
import org.hyperledger.acy_py.generated.model.TxnOrRevRegResult;
import org.hyperledger.acy_py.generated.model.TxnOrSchemaSendResult;
import org.hyperledger.acy_py.generated.model.V10CredentialBoundOfferRequest;
import org.hyperledger.acy_py.generated.model.V10CredentialProblemReportRequest;
import org.hyperledger.acy_py.generated.model.V10DiscoveryExchangeListResult;
import org.hyperledger.acy_py.generated.model.V10DiscoveryRecord;
import org.hyperledger.acy_py.generated.model.V10PresentationProblemReportRequest;
import org.hyperledger.acy_py.generated.model.V10PresentationSendRequestToProposal;
import org.hyperledger.acy_py.generated.model.V20CredExRecordDetail;
import org.hyperledger.acy_py.generated.model.V20CredIssueProblemReportRequest;
import org.hyperledger.acy_py.generated.model.V20CredIssueRequest;
import org.hyperledger.acy_py.generated.model.V20CredOfferConnFreeRequest;
import org.hyperledger.acy_py.generated.model.V20CredOfferRequest;
import org.hyperledger.acy_py.generated.model.V20CredRequestFree;
import org.hyperledger.acy_py.generated.model.V20CredRequestRequest;
import org.hyperledger.acy_py.generated.model.V20CredStoreRequest;
import org.hyperledger.acy_py.generated.model.V20DiscoveryExchangeListResult;
import org.hyperledger.acy_py.generated.model.V20DiscoveryRecord;
import org.hyperledger.acy_py.generated.model.V20IssueCredSchemaCore;
import org.hyperledger.acy_py.generated.model.V20PresProblemReportRequest;
import org.hyperledger.acy_py.generated.model.V20PresentationSendRequestToProposal;
import org.hyperledger.acy_py.generated.model.VCRecord;
import org.hyperledger.acy_py.generated.model.VCRecordList;
import org.hyperledger.acy_py.generated.model.W3CCredentialsListRequest;
import org.hyperledger.acy_py.generated.model.WriteLedgerRequest;
import org.hyperledger.aries.AriesWebSocketClient;
import org.hyperledger.aries.BaseClient;
import org.hyperledger.aries.ClientToTenant;
import org.hyperledger.aries.api.action_menu.PerformRequest;
import org.hyperledger.aries.api.action_menu.SendMenu;
import org.hyperledger.aries.api.connection.ConnectionAcceptInvitationFilter;
import org.hyperledger.aries.api.connection.ConnectionAcceptRequestFilter;
import org.hyperledger.aries.api.connection.ConnectionFilter;
import org.hyperledger.aries.api.connection.ConnectionReceiveInvitationFilter;
import org.hyperledger.aries.api.connection.ConnectionRecord;
import org.hyperledger.aries.api.connection.ConnectionSetMetaDataRequest;
import org.hyperledger.aries.api.connection.ConnectionStaticRequest;
import org.hyperledger.aries.api.connection.ConnectionStaticResult;
import org.hyperledger.aries.api.connection.CreateInvitationParams;
import org.hyperledger.aries.api.connection.CreateInvitationRequest;
import org.hyperledger.aries.api.connection.CreateInvitationResponse;
import org.hyperledger.aries.api.connection.EndpointResult;
import org.hyperledger.aries.api.connection.ReceiveInvitationRequest;
import org.hyperledger.aries.api.credential_definition.CredentialDefinition;
import org.hyperledger.aries.api.credential_definition.CredentialDefinitionFilter;
import org.hyperledger.aries.api.credentials.Credential;
import org.hyperledger.aries.api.credentials.CredentialRevokedFilter;
import org.hyperledger.aries.api.credentials.ListCredentialsFilter;
import org.hyperledger.aries.api.did_exchange.DIDXRequest;
import org.hyperledger.aries.api.did_exchange.DidExchangeAcceptInvitationFilter;
import org.hyperledger.aries.api.did_exchange.DidExchangeAcceptRequestFilter;
import org.hyperledger.aries.api.did_exchange.DidExchangeCreateRequestFilter;
import org.hyperledger.aries.api.did_exchange.DidExchangeReceiveRequestFilter;
import org.hyperledger.aries.api.discover_features.DiscoverFeaturesQueryFilter;
import org.hyperledger.aries.api.discover_features.DiscoverFeaturesRecordsFilter;
import org.hyperledger.aries.api.discover_features_v2.DiscoverFeaturesV2QueriesFilter;
import org.hyperledger.aries.api.endorser.EndorseCreateRequest;
import org.hyperledger.aries.api.endorser.EndorseCreateRequestFilter;
import org.hyperledger.aries.api.endorser.EndorseTransactionRecord;
import org.hyperledger.aries.api.endorser.EndorserInfoFilter;
import org.hyperledger.aries.api.endorser.SetEndorserInfoFilter;
import org.hyperledger.aries.api.endorser.SetEndorserRoleFilter;
import org.hyperledger.aries.api.exception.AriesException;
import org.hyperledger.aries.api.introduction.ConnectionStartIntroductionFilter;
import org.hyperledger.aries.api.issue_credential_v1.IssueCredentialRecordsFilter;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialCreate;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialExchange;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialFreeOfferRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialIssueRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialOfferRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialProposalRequest;
import org.hyperledger.aries.api.issue_credential_v1.V1CredentialStoreRequest;
import org.hyperledger.aries.api.issue_credential_v2.V1ToV2IssueCredentialConverter;
import org.hyperledger.aries.api.issue_credential_v2.V20CredBoundOfferRequest;
import org.hyperledger.aries.api.issue_credential_v2.V20CredExRecord;
import org.hyperledger.aries.api.issue_credential_v2.V2CredentialExchangeFree;
import org.hyperledger.aries.api.issue_credential_v2.V2IssueCredentialRecordsFilter;
import org.hyperledger.aries.api.jsonld.SignRequest;
import org.hyperledger.aries.api.jsonld.VerifiableCredential;
import org.hyperledger.aries.api.jsonld.VerifiablePresentation;
import org.hyperledger.aries.api.jsonld.VerifyRequest;
import org.hyperledger.aries.api.jsonld.VerifyResponse;
import org.hyperledger.aries.api.ledger.DidVerkeyResponse;
import org.hyperledger.aries.api.ledger.EndpointResponse;
import org.hyperledger.aries.api.ledger.LedgerConfig;
import org.hyperledger.aries.api.ledger.RegisterNymFilter;
import org.hyperledger.aries.api.ledger.TAAAccept;
import org.hyperledger.aries.api.ledger.TAAInfo;
import org.hyperledger.aries.api.mediation.MediationKeyListQueryFilter;
import org.hyperledger.aries.api.mediation.MediationKeyListsFilter;
import org.hyperledger.aries.api.mediation.MediationRequestsFilter;
import org.hyperledger.aries.api.multitenancy.CreateWalletRequest;
import org.hyperledger.aries.api.multitenancy.CreateWalletTokenRequest;
import org.hyperledger.aries.api.multitenancy.CreateWalletTokenResponse;
import org.hyperledger.aries.api.multitenancy.RemoveWalletRequest;
import org.hyperledger.aries.api.multitenancy.UpdateWalletRequest;
import org.hyperledger.aries.api.multitenancy.WalletRecord;
import org.hyperledger.aries.api.out_of_band.CreateInvitationFilter;
import org.hyperledger.aries.api.out_of_band.InvitationCreateRequest;
import org.hyperledger.aries.api.out_of_band.InvitationMessage;
import org.hyperledger.aries.api.out_of_band.ReceiveInvitationFilter;
import org.hyperledger.aries.api.present_proof.PresentProofProposal;
import org.hyperledger.aries.api.present_proof.PresentProofRecordsFilter;
import org.hyperledger.aries.api.present_proof.PresentProofRequest;
import org.hyperledger.aries.api.present_proof.PresentationExchangeRecord;
import org.hyperledger.aries.api.present_proof.PresentationRequest;
import org.hyperledger.aries.api.present_proof.PresentationRequestCredentials;
import org.hyperledger.aries.api.present_proof.PresentationRequestCredentialsFilter;
import org.hyperledger.aries.api.present_proof_v2.V20PresCreateRequestRequest;
import org.hyperledger.aries.api.present_proof_v2.V20PresExRecord;
import org.hyperledger.aries.api.present_proof_v2.V20PresProposalRequest;
import org.hyperledger.aries.api.present_proof_v2.V20PresSendRequestRequest;
import org.hyperledger.aries.api.present_proof_v2.V20PresSpecByFormatRequest;
import org.hyperledger.aries.api.present_proof_v2.V2PresentProofRecordsFilter;
import org.hyperledger.aries.api.resolver.DIDDocument;
import org.hyperledger.aries.api.revocation.FixRevocationEntryStateFilter;
import org.hyperledger.aries.api.revocation.RevRegCreateRequest;
import org.hyperledger.aries.api.revocation.RevRegCreateResponse;
import org.hyperledger.aries.api.revocation.RevRegUpdateTailsFileUri;
import org.hyperledger.aries.api.revocation.RevRegsCreated;
import org.hyperledger.aries.api.revocation.RevocationCredentialRecordFilter;
import org.hyperledger.aries.api.revocation.RevocationRegistryState;
import org.hyperledger.aries.api.revocation.RevokeRequest;
import org.hyperledger.aries.api.schema.SchemaSendRequest;
import org.hyperledger.aries.api.schema.SchemaSendResponse;
import org.hyperledger.aries.api.schema.SchemasCreatedFilter;
import org.hyperledger.aries.api.server.AdminConfig;
import org.hyperledger.aries.api.server.AdminStatusLiveliness;
import org.hyperledger.aries.api.server.AdminStatusReadiness;
import org.hyperledger.aries.api.trustping.PingRequest;
import org.hyperledger.aries.api.trustping.PingResponse;
import org.hyperledger.aries.api.wallet.ListWalletDidFilter;
import org.hyperledger.aries.api.wallet.WalletDIDCreate;
import org.hyperledger.aries.config.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AriesClient
extends BaseClient {
    private static final Logger log = LoggerFactory.getLogger(AriesClient.class);
    private final String url;
    private final String apiKey;
    private final String bearerToken;

    public AriesClient(@Nullable String url, @Nullable String apiKey, @Nullable String bearerToken, @Nullable OkHttpClient client) {
        super(client);
        this.url = StringUtils.isEmpty((CharSequence)url) ? "http://localhost:8031" : StringUtils.trim((String)url);
        this.apiKey = StringUtils.trimToEmpty((String)apiKey);
        this.bearerToken = StringUtils.trimToEmpty((String)bearerToken);
    }

    public void actionMenuClose(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/action-menu/" + connectionId + "/close", "{}");
        this.call(req);
    }

    public void actionMenuFetch(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/action-menu/" + connectionId + "/fetch", "{}");
        this.call(req);
    }

    public void actionMenuPerform(@NonNull String connectionId, @NonNull PerformRequest request) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/action-menu/" + connectionId + "/perform", request);
        this.call(req);
    }

    public void actionMenuRequest(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/action-menu/" + connectionId + "/request", "{}");
        this.call(req);
    }

    public void actionMenuSendMenu(@NonNull String connectionId, @NonNull SendMenu request) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/action-menu/" + connectionId + "/send-menu", request);
        this.call(req);
    }

    public void connectionsSendMessage(@NonNull String connectionId, @NonNull SendMessage msg) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/connections/" + connectionId + "/send-message", msg);
        this.call(req);
    }

    public Optional<List<ConnectionRecord>> connections() throws IOException {
        return this.connections(null);
    }

    public Optional<List<ConnectionRecord>> connections(@Nullable ConnectionFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", CONNECTION_TYPE);
    }

    public List<String> connectionIds() throws IOException {
        return this.connectionIds(null);
    }

    public List<String> connectionIds(@Nullable ConnectionFilter filter) throws IOException {
        List<String> result = new ArrayList<String>();
        Optional<List<ConnectionRecord>> c = this.connections(filter);
        if (c.isPresent()) {
            result = c.get().stream().map(ConnectionRecord::getConnectionId).collect(Collectors.toList());
        }
        return result;
    }

    public Optional<CreateInvitationResponse> connectionsCreateInvitation(@NonNull CreateInvitationRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.connectionsCreateInvitation(request, null);
    }

    public Optional<CreateInvitationResponse> connectionsCreateInvitation(@NonNull CreateInvitationRequest request, @Nullable CreateInvitationParams params) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections/create-invitation"))).newBuilder();
        if (params != null) {
            params.buildParams(b);
        }
        Request req = this.buildPost(b.build().toString(), request);
        return this.call(req, CreateInvitationResponse.class);
    }

    public Optional<ConnectionStaticResult> connectionsCreateStatic(@NonNull ConnectionStaticRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/connections/create-static", request);
        return this.call(req, ConnectionStaticResult.class);
    }

    public Optional<ConnectionRecord> connectionsReceiveInvitation(@NonNull ReceiveInvitationRequest invite, @Nullable ConnectionReceiveInvitationFilter filter) throws IOException {
        if (invite == null) {
            throw new NullPointerException("invite is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections/receive-invitation"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.build().toString(), invite);
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<ConnectionRecord> connectionsGetById(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/connections/" + connectionId);
        return this.call(req, ConnectionRecord.class);
    }

    public void connectionsRemove(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/connections/" + connectionId);
        this.call(req);
    }

    public Optional<ConnectionRecord> connectionsAcceptInvitation(@NonNull String connectionId, @Nullable ConnectionAcceptInvitationFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections/" + connectionId + "/accept-invitation"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<ConnectionRecord> connectionsAcceptRequest(@NonNull String connectionId, @Nullable ConnectionAcceptRequestFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections/" + connectionId + "/accept-request"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<EndpointResult> connectionsGetEndpoints(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/connections/" + connectionId + "/endpoints");
        return this.call(req, EndpointResult.class);
    }

    public void connectionsEstablishInbound(@NonNull String connectionId, @NonNull String inboundConnectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (inboundConnectionId == null) {
            throw new NullPointerException("inboundConnectionId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/connections/" + connectionId + "/establish-inbound/" + inboundConnectionId, "{}");
        this.call(req);
    }

    public Optional<Map<String, String>> connectionsGetMetadata(@NonNull String connectionId) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/connections/" + connectionId + "/metadata");
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", MAP_TYPE);
    }

    public Optional<String> connectionsGetMetadata(@NonNull String connectionId, @NonNull String key) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections/" + connectionId + "/metadata"))).newBuilder();
        b.addQueryParameter("key", key);
        Request req = this.buildGet(b.toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", (Type)((Object)String.class));
    }

    public Optional<Map<String, String>> connectionsSetMetadata(@NonNull String connectionId, @NonNull ConnectionSetMetaDataRequest request) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/connections/" + connectionId + "/metadata", request);
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", MAP_TYPE);
    }

    public Optional<CredentialDefinition.CredentialDefinitionResponse> credentialDefinitionsCreate(@NonNull CredentialDefinition.CredentialDefinitionRequest defReq) throws IOException {
        if (defReq == null) {
            throw new NullPointerException("defReq is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/credential-definitions", defReq);
        return this.call(req, CredentialDefinition.CredentialDefinitionResponse.class);
    }

    public Optional<TxnOrCredentialDefinitionSendResult> credentialDefinitionsCreate(@NonNull CredentialDefinition.CredentialDefinitionRequest defReq, @NonNull EndorserInfoFilter endorserInfoFilter) throws IOException {
        if (defReq == null) {
            throw new NullPointerException("defReq is marked non-null but is null");
        }
        if (endorserInfoFilter == null) {
            throw new NullPointerException("endorserInfoFilter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/credential-definitions"))).newBuilder();
        endorserInfoFilter.buildParams(b);
        Request req = this.buildPost(b.toString(), defReq);
        return this.call(req, TxnOrCredentialDefinitionSendResult.class);
    }

    public Optional<CredentialDefinition.CredentialDefinitionsCreated> credentialDefinitionsCreated(@Nullable CredentialDefinitionFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/credential-definitions/created"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, CredentialDefinition.CredentialDefinitionsCreated.class);
    }

    public Optional<CredentialDefinitionGetResult> credentialDefinitionsGetById(@NonNull String id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/credential-definitions/" + id);
        return this.call(req, CredentialDefinitionGetResult.class);
    }

    public Optional<CredentialDefinitionGetResult> credentialDefinitionsWriteRecord(@NonNull String id) throws IOException {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/credential-definitions/" + id + "/write_record", "{}");
        return this.call(req, CredentialDefinitionGetResult.class);
    }

    public Optional<Object> credentialMimeTypes(@NonNull String credentialId) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/credential/mime-types/" + credentialId);
        return this.call(req, Object.class);
    }

    public Optional<Credential.CredentialRevokedResult> credentialRevoked(@NonNull String credentialId) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        return this.credentialRevoked(credentialId, null);
    }

    public Optional<Credential.CredentialRevokedResult> credentialRevoked(@NonNull String credentialId, CredentialRevokedFilter filter) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/credential/revoked/" + credentialId))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, Credential.CredentialRevokedResult.class);
    }

    public Optional<VCRecord> credentialW3C(@NonNull String credentialId) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/credential/w3c/" + credentialId);
        return this.call(req, VCRecord.class);
    }

    public void credentialW3CRemove(@NonNull String credentialId) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/credential/w3c/" + credentialId);
        this.call(req);
    }

    public Optional<Credential> credential(@NonNull String credentialId) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/credential/" + credentialId);
        return this.call(req, Credential.class);
    }

    public void credentialRemove(@NonNull String credentialId) throws IOException {
        if (credentialId == null) {
            throw new NullPointerException("credentialId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/credential/" + credentialId);
        this.call(req);
    }

    public Optional<List<Credential>> credentials() throws IOException {
        return this.credentials(ListCredentialsFilter.builder().build());
    }

    public Optional<List<Credential>> credentials(@Nullable ListCredentialsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/credentials"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.toString());
        return this.getWrapped(this.raw(req), "results", CREDENTIAL_TYPE);
    }

    public Optional<List<Credential>> credentials(@Nullable Predicate<Credential> filter) throws IOException {
        Optional<List<Credential>> result = Optional.empty();
        Request req = this.buildGet(this.url + "/credentials");
        Optional<String> resp = this.raw(req);
        if (resp.isPresent() && (result = this.getWrapped(resp, "results", CREDENTIAL_TYPE)).isPresent() && filter != null) {
            result = Optional.of(result.get().stream().filter(filter).collect(Collectors.toList()));
        }
        return result;
    }

    public Optional<VCRecordList> credentialsW3C(@NonNull W3CCredentialsListRequest w3cReq) throws IOException {
        if (w3cReq == null) {
            throw new NullPointerException("w3cReq is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/credentials/w3c", w3cReq);
        return this.call(req, VCRecordList.class);
    }

    public List<String> credentialIds() throws IOException {
        return this.credentialIds(null);
    }

    public List<String> credentialIds(@Nullable Predicate<Credential> filter) throws IOException {
        List<String> result = new ArrayList<String>();
        Optional<List<Credential>> c = this.credentials(filter);
        if (c.isPresent()) {
            result = c.get().stream().map(Credential::getReferent).collect(Collectors.toList());
        }
        return result;
    }

    public Optional<ConnectionRecord> didExchangeCreateRequest(@NonNull DidExchangeCreateRequestFilter filter) throws IOException {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/didexchange/create-request"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<ConnectionRecord> didExchangeReceiveRequest(@NonNull DIDXRequest request, @Nullable DidExchangeReceiveRequestFilter filter) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/didexchange/receive-request"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), request);
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<ConnectionRecord> didExchangeAcceptInvitation(@NonNull String connectionId, @Nullable DidExchangeAcceptInvitationFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/didexchange/" + connectionId + "/accept-invitation"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<ConnectionRecord> didExchangeAcceptRequest(@NonNull String connectionId, @Nullable DidExchangeAcceptRequestFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/didexchange/" + connectionId + "/accept-request"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<V10DiscoveryRecord> discoverFeaturesQuery(@Nullable DiscoverFeaturesQueryFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/discover-features/query"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, V10DiscoveryRecord.class);
    }

    public Optional<V10DiscoveryExchangeListResult> discoverFeaturesRecords(@Nullable DiscoverFeaturesRecordsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/discover-features/records"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, V10DiscoveryExchangeListResult.class);
    }

    public Optional<V20DiscoveryRecord> discoverFeaturesV2Queries(@Nullable DiscoverFeaturesV2QueriesFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/discover-features-2.0/queries"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, V20DiscoveryRecord.class);
    }

    public Optional<V20DiscoveryExchangeListResult> discoverFeaturesV2Records(@Nullable DiscoverFeaturesRecordsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/discover-features-2.0/records"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, V20DiscoveryExchangeListResult.class);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionResend(@NonNull String trxId) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/transaction/" + trxId + "/resend", "{}");
        return this.call(req, EndorseTransactionRecord.class);
    }

    public Optional<List<EndorseTransactionRecord>> endorseGetTransactions() throws IOException {
        Request req = this.buildGet(this.url + "/transactions");
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", TRX_RECORD_TYPE);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionCreateRequest(@NonNull Instant expiresTime, @NonNull EndorseCreateRequestFilter filter) throws IOException {
        if (expiresTime == null) {
            throw new NullPointerException("expiresTime is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/transactions/create-request"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPost(b.toString(), EndorseCreateRequest.builder().expiresTime(TimeUtil.currentTimeFormatted(expiresTime)).build());
        return this.call(req, EndorseTransactionRecord.class);
    }

    public Optional<EndorserInfo> endorseTransactionSetEndorserInfo(@NonNull String connectionId, @NonNull SetEndorserInfoFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/transactions/" + connectionId + "/set-endorser-info"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, EndorserInfo.class);
    }

    public Optional<TransactionJobs> endorseTransactionSetEndorserRole(@NonNull String connectionId, @NonNull SetEndorserRoleFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/transactions/" + connectionId + "/set-endorser-role"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, TransactionJobs.class);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionGetById(@NonNull String trxId) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/transactions/" + trxId);
        return this.call(req, EndorseTransactionRecord.class);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionCancel(@NonNull String trxId) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/transactions/" + trxId + "/cancel", "{}");
        return this.call(req, EndorseTransactionRecord.class);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionEndorse(@NonNull String trxId) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        return this.endorseTransactionEndorse(trxId, null);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionEndorse(@NonNull String trxId, String endorserDid) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/transactions/" + trxId + "/endorse"))).newBuilder();
        if (StringUtils.isNotEmpty((CharSequence)endorserDid)) {
            b.addQueryParameter("endorser_did", endorserDid);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, EndorseTransactionRecord.class);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionRefuse(@NonNull String trxId) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/transactions/" + trxId + "/refuse", "{}");
        return this.call(req, EndorseTransactionRecord.class);
    }

    public Optional<EndorseTransactionRecord> endorseTransactionWrite(@NonNull String trxId) throws IOException {
        if (trxId == null) {
            throw new NullPointerException("trxId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/transactions/" + trxId + "/write", "{}");
        return this.call(req, EndorseTransactionRecord.class);
    }

    public void connectionsStartIntroduction(@NonNull String connectionId, @NonNull ConnectionStartIntroductionFilter filter) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/connections/" + connectionId + "/start-introduction"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPost(b.toString(), "{}");
        this.call(req);
    }

    public Optional<V1CredentialExchange> issueCredentialCreate(@NonNull V1CredentialCreate request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/create", request);
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V1CredentialExchange> issueCredentialCreateOffer(@NonNull V1CredentialFreeOfferRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/create-offer", request);
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<List<V1CredentialExchange>> issueCredentialRecords(IssueCredentialRecordsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/issue-credential/records"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", ISSUE_CREDENTIAL_TYPE);
    }

    public Optional<V1CredentialExchange> issueCredentialRecordsGetById(@NonNull String credentialExchangeId) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/issue-credential/records/" + credentialExchangeId);
        return this.call(req, V1CredentialExchange.class);
    }

    public void issueCredentialRecordsRemove(@NonNull String credentialExchangeId) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/issue-credential/records/" + credentialExchangeId);
        this.call(req);
    }

    public Optional<V1CredentialExchange> issueCredentialRecordsIssue(@NonNull String credentialExchangeId, @Nullable V1CredentialIssueRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/records/" + credentialExchangeId + "/issue", request != null ? request : V1CredentialIssueRequest.builder().build());
        return this.call(req, V1CredentialExchange.class);
    }

    public void issueCredentialRecordsProblemReport(@NonNull String credentialExchangeId, @NonNull V10CredentialProblemReportRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/records/" + credentialExchangeId + "/problem-report", request);
        this.call(req);
    }

    public Optional<V1CredentialExchange> issueCredentialRecordsSendOffer(@NonNull String credentialExchangeId, @NonNull V10CredentialBoundOfferRequest offerRequest) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        if (offerRequest == null) {
            throw new NullPointerException("offerRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/records/" + credentialExchangeId + "/send-offer", offerRequest);
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V1CredentialExchange> issueCredentialRecordsSendRequest(@NonNull String credentialExchangeId) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/records/" + credentialExchangeId + "/send-request", "{}");
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V1CredentialExchange> issueCredentialRecordsStore(@NonNull String credentialExchangeId, @Nullable V1CredentialStoreRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/records/" + credentialExchangeId + "/store", request != null ? request : "");
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V1CredentialExchange> issueCredentialSend(@NonNull V1CredentialProposalRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/send", request);
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V1CredentialExchange> issueCredentialSendOffer(@NonNull V1CredentialOfferRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/send-offer", request);
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V1CredentialExchange> issueCredentialSendProposal(@NonNull V1CredentialProposalRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential/send-proposal", request);
        return this.call(req, V1CredentialExchange.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2Create(@NonNull V20IssueCredSchemaCore request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/create", request);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2CreateOffer(@NonNull V20CredOfferConnFreeRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/create-offer", request);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<List<V20CredExRecordDetail>> issueCredentialV2Records(V2IssueCredentialRecordsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/issue-credential-2.0/records"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", ISSUE_CREDENTIAL_V2_TYPE);
    }

    public Optional<V20CredExRecordDetail> issueCredentialV2RecordsGetById(@NonNull String credentialExchangeId) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/issue-credential-2.0/records/" + credentialExchangeId);
        return this.call(req, V20CredExRecordDetail.class);
    }

    public void issueCredentialV2RecordsRemove(@NonNull String credentialExchangeId) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/issue-credential-2.0/records/" + credentialExchangeId);
        this.call(req);
    }

    public Optional<V20CredExRecordDetail> issueCredentialV2RecordsIssue(@NonNull String credentialExchangeId, @Nullable V20CredIssueRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/records/" + credentialExchangeId + "/issue", request != null ? request : V20CredIssueRequest.builder().build());
        return this.call(req, V20CredExRecordDetail.class);
    }

    public void issueCredentialV2RecordsProblemReport(@NonNull String credentialExchangeId, @NonNull V20CredIssueProblemReportRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/records/" + credentialExchangeId + "/problem-report", request);
        this.call(req);
    }

    public Optional<V20CredExRecord> issueCredentialV2RecordsSendOffer(@NonNull String credentialExchangeId, @NonNull V10CredentialBoundOfferRequest offerRequest) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        if (offerRequest == null) {
            throw new NullPointerException("offerRequest is marked non-null but is null");
        }
        return this.issueCredentialV2RecordsSendOffer(credentialExchangeId, V1ToV2IssueCredentialConverter.toV20CredBoundOfferRequest(offerRequest));
    }

    public Optional<V20CredExRecord> issueCredentialV2RecordsSendOffer(@NonNull String credentialExchangeId, @NonNull V20CredBoundOfferRequest offerRequest) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        if (offerRequest == null) {
            throw new NullPointerException("offerRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/records/" + credentialExchangeId + "/send-offer", offerRequest);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2RecordsSendRequest(@NonNull String credentialExchangeId, @NonNull V20CredRequestRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/records/" + credentialExchangeId + "/send-request", request);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<V20CredExRecordDetail> issueCredentialV2RecordsStore(@NonNull String credentialExchangeId, @Nullable V20CredStoreRequest request) throws IOException {
        if (credentialExchangeId == null) {
            throw new NullPointerException("credentialExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/records/" + credentialExchangeId + "/store", request != null ? request : "{}");
        return this.call(req, V20CredExRecordDetail.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2Send(@NonNull V1CredentialProposalRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.issueCredentialV2Send(V1ToV2IssueCredentialConverter.toV2CredentialSendRequest(request));
    }

    public Optional<V20CredExRecord> issueCredentialV2Send(@NonNull V2CredentialExchangeFree request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/send", request);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2SendOffer(@NonNull V20CredOfferRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/send-offer", request);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2SendProposal(@NonNull V1CredentialProposalRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return this.issueCredentialV2SendProposal(V1ToV2IssueCredentialConverter.toV20CredExFree(request));
    }

    public Optional<V20CredExRecord> issueCredentialV2SendProposal(@NonNull V2CredentialExchangeFree request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/send-proposal", request);
        return this.call(req, V20CredExRecord.class);
    }

    public Optional<V20CredExRecord> issueCredentialV2SendRequest(@NonNull V20CredRequestFree request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/issue-credential-2.0/send-request", request);
        return this.call(req, V20CredExRecord.class);
    }

    public <T> Optional<T> jsonldSign(@NonNull SignRequest signRequest, @NonNull Type t) throws IOException {
        if (signRequest == null) {
            throw new NullPointerException("signRequest is marked non-null but is null");
        }
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/jsonld/sign", signRequest);
        Optional<String> raw = this.raw(req);
        this.checkForError(raw);
        return this.getWrapped(raw, "signed_doc", t);
    }

    public Optional<VerifyResponse> jsonldVerify(@NonNull String verkey, @NonNull Object t) throws IOException {
        if (verkey == null) {
            throw new NullPointerException("verkey is marked non-null but is null");
        }
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        if (t instanceof VerifiableCredential || t instanceof VerifiablePresentation) {
            JsonElement jsonTree = this.gson.toJsonTree(t, t.getClass());
            Request req = this.buildPost(this.url + "/jsonld/verify", new VerifyRequest(verkey, jsonTree.getAsJsonObject()));
            Optional<VerifyResponse> response = this.call(req, VerifyResponse.class);
            if (response.isPresent() && StringUtils.isNotEmpty((CharSequence)response.get().getError())) {
                throw new AriesException(0, response.get().getError());
            }
            return response;
        }
        throw new IllegalStateException("Expecting either VerifiableCredential or VerifiablePresentation");
    }

    public Optional<EndpointResponse> ledgerDidEndpoint(@NonNull String did, @Nullable DIDEndpointWithType.EndpointTypeEnum type) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/ledger/did-endpoint"))).newBuilder();
        b.addQueryParameter("did", did);
        if (type != null) {
            b.addQueryParameter("endpoint_type", type.getValue());
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, EndpointResponse.class);
    }

    public Optional<DidVerkeyResponse> ledgerDidVerkey(@NonNull String did) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/ledger/did-verkey"))).newBuilder();
        b.addQueryParameter("did", did);
        Request req = this.buildGet(b.build().toString());
        return this.call(req, DidVerkeyResponse.class);
    }

    public Optional<GetNymRoleResponse> ledgerGetNymRole(@NonNull String did) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/ledger/get-nym-role"))).newBuilder();
        b.addQueryParameter("did", did);
        return this.call(this.buildGet(b.build().toString()), GetNymRoleResponse.class);
    }

    public Optional<LedgerConfig> ledgerMultipleConfig() throws IOException {
        Request req = this.buildGet(this.url + "/ledger/multiple/config");
        return this.call(req, LedgerConfig.class);
    }

    public Optional<WriteLedgerRequest> ledgerMultipleGetWriteLedger() throws IOException {
        Request req = this.buildGet(this.url + "/ledger/multiple/get-write-ledger");
        return this.call(req, WriteLedgerRequest.class);
    }

    public Optional<TxnOrRegisterLedgerNymResponse> ledgerRegisterNym(@NonNull RegisterNymFilter filter) throws IOException {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/ledger/register-nym"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPost(b.build().toString(), "{}");
        return this.call(req, TxnOrRegisterLedgerNymResponse.class);
    }

    public void ledgerRotatePublicDidKeypair() throws IOException {
        Request req = this.buildPatch(this.url + "/ledger/rotate-public-did-keypair", "{}");
        this.call(req);
    }

    public Optional<TAAInfo> ledgerTaa() throws IOException {
        Request req = this.buildGet(this.url + "/ledger/taa");
        return this.getWrapped(this.raw(req), "result", (Type)((Object)TAAInfo.class));
    }

    public void ledgerTaaAccept(@NonNull TAAAccept taaAccept) throws IOException {
        if (taaAccept == null) {
            throw new NullPointerException("taaAccept is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/ledger/taa/accept", taaAccept);
        this.call(req);
    }

    public Optional<MediationRecord> mediationDefaultMediator() throws IOException {
        Request req = this.buildGet(this.url + "/mediation/default-mediator");
        return this.call(req, MediationRecord.class);
    }

    public void mediationClearDefaultMediator() throws IOException {
        Request req = this.buildDelete(this.url + "/mediation/default-mediator");
        this.call(req);
    }

    public Optional<List<RouteRecord>> mediationKeyLists(MediationKeyListsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/mediation/keylists"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", KEY_LISTS_TYPE);
    }

    public Optional<KeylistQuery> mediationSendKeyListQuery(@NonNull UUID mediationId, @NonNull KeylistQueryFilterRequest request, MediationKeyListQueryFilter filter) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/mediation/keylists/" + mediationId + "/send-keylist-query"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.build().toString(), request);
        return this.call(req, KeylistQuery.class);
    }

    public Optional<KeylistUpdate> mediationSendKeyListUpdate(@NonNull UUID mediationId, @NonNull KeylistUpdateRequest request) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/mediation/keylists/" + mediationId + "/send-keylist-update", request);
        return this.call(req, KeylistUpdate.class);
    }

    public Optional<MediationRecord> mediationRequest(@NonNull UUID connectionId, @NonNull MediationCreateRequest request) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/mediation/request/" + connectionId, request);
        return this.call(req, MediationRecord.class);
    }

    public Optional<List<MediationRecord>> mediationRequests(MediationRequestsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/mediation/requests"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", MEDIATION_LIST_TYPE);
    }

    public Optional<MediationRecord> mediationRequestsGetById(@NonNull UUID mediationId) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/mediation/requests/" + mediationId);
        return this.call(req, MediationRecord.class);
    }

    public void mediationRequestsDeleteById(@NonNull UUID mediationId) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/mediation/requests/" + mediationId);
        this.call(req);
    }

    public Optional<MediationDeny> mediationRequestsDeny(@NonNull UUID mediationId, @NonNull AdminMediationDeny request) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/mediation/requests/" + mediationId + "/deny", request);
        return this.call(req, MediationDeny.class);
    }

    public Optional<MediationGrant> mediationRequestsGrant(@NonNull UUID mediationId) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/mediation/requests/" + mediationId + "/grant", "{}");
        return this.call(req, MediationGrant.class);
    }

    public Optional<MediationRecord> mediationDefaultMediator(@NonNull UUID mediationId) throws IOException {
        if (mediationId == null) {
            throw new NullPointerException("mediationId is marked non-null but is null");
        }
        Request req = this.buildPut(this.url + "/mediation/" + mediationId + "/default-mediator", "{}");
        return this.call(req, MediationRecord.class);
    }

    public Optional<WalletRecord> multitenancyWalletCreate(@NonNull CreateWalletRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/multitenancy/wallet", request);
        return this.call(req, WalletRecord.class);
    }

    public ClientToTenant multitenancyWalletCreateWithClient(@NonNull CreateWalletRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.bearerToken)) {
            throw new IllegalStateException("You can not create a sub wallet from a sub wallet.");
        }
        URI uri = URI.create(this.url);
        String scheme = uri.getScheme().equals("https") ? "wss" : "ws";
        String host = uri.getHost();
        int port = uri.getPort();
        WalletRecord wr = this.multitenancyWalletCreate(request).orElseThrow();
        return new ClientToTenant(AriesClient.builder().apiKey(this.apiKey).bearerToken(wr.getToken()).url(this.url).build(), AriesWebSocketClient.builder().apiKey(this.apiKey).bearerToken(wr.getToken()).walletId(wr.getWalletId()).url(scheme + "://" + host + ":" + port + "/ws").build(), wr);
    }

    public Optional<WalletRecord> multitenancyWalletGet(@NonNull String walletId) throws IOException {
        if (walletId == null) {
            throw new NullPointerException("walletId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/multitenancy/wallet/" + walletId);
        return this.call(req, WalletRecord.class);
    }

    public Optional<WalletRecord> multitenancyWalletUpdate(@NonNull String walletId, @NonNull UpdateWalletRequest request) throws IOException {
        if (walletId == null) {
            throw new NullPointerException("walletId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPut(this.url + "/multitenancy/wallet/" + walletId, request);
        return this.call(req, WalletRecord.class);
    }

    public void multitenancyWalletRemove(@NonNull String walletId, @NonNull RemoveWalletRequest request) throws IOException {
        if (walletId == null) {
            throw new NullPointerException("walletId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/multitenancy/wallet/" + walletId + "/remove", request);
        this.call(req);
    }

    public Optional<CreateWalletTokenResponse> multitenancyWalletToken(@NonNull String walletId, @NonNull CreateWalletTokenRequest request) throws IOException {
        if (walletId == null) {
            throw new NullPointerException("walletId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/multitenancy/wallet/" + walletId + "/token", request);
        return this.call(req, CreateWalletTokenResponse.class);
    }

    public Optional<List<WalletRecord>> multitenancyWallets(String walletName) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/multitenancy/wallets"))).newBuilder();
        if (StringUtils.isNotEmpty((CharSequence)walletName)) {
            b.addQueryParameter("wallet_name", walletName);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", WALLET_RECORD_TYPE);
    }

    public Optional<InvitationRecord> outOfBandCreateInvitation(@NonNull InvitationCreateRequest request, CreateInvitationFilter filter) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/out-of-band/create-invitation"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.build().toString(), request);
        return this.call(req, InvitationRecord.class);
    }

    public <T> Optional<ConnectionRecord> outOfBandReceiveInvitation(@NonNull InvitationMessage<T> request, ReceiveInvitationFilter filter) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/out-of-band/receive-invitation"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.build().toString(), request);
        return this.call(req, ConnectionRecord.class);
    }

    public Optional<PresentationExchangeRecord> presentProofCreateRequest(@NonNull PresentProofRequest proofRequest) throws IOException {
        if (proofRequest == null) {
            throw new NullPointerException("proofRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/create-request", proofRequest);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<List<PresentationExchangeRecord>> presentProofRecords() throws IOException {
        return this.presentProofRecords(null);
    }

    public Optional<List<PresentationExchangeRecord>> presentProofRecords(@Nullable PresentProofRecordsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/present-proof/records"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", PROOF_TYPE);
    }

    public Optional<PresentationExchangeRecord> presentProofRecordsGetById(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/present-proof/records/" + presentationExchangeId);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public void presentProofRecordsRemove(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/present-proof/records/" + presentationExchangeId);
        this.call(req);
    }

    public Optional<List<PresentationRequestCredentials>> presentProofRecordsCredentials(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        return this.presentProofRecordsCredentials(presentationExchangeId, null);
    }

    public Optional<List<PresentationRequestCredentials>> presentProofRecordsCredentials(@NonNull String presentationExchangeId, @Nullable PresentationRequestCredentialsFilter filter) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/present-proof/records/" + presentationExchangeId + "/credentials"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, PRESENTATION_REQUEST_CREDENTIALS_INDY);
    }

    public void presentProofRecordsProblemReport(@NonNull String presentationExchangeId, @NonNull V10PresentationProblemReportRequest request) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/records/" + presentationExchangeId + "/problem-report", request);
        this.call(req);
    }

    public Optional<PresentationExchangeRecord> presentProofRecordsSendPresentation(@NonNull String presentationExchangeId, @NonNull PresentationRequest presentationRequest) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (presentationRequest == null) {
            throw new NullPointerException("presentationRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/records/" + presentationExchangeId + "/send-presentation", presentationRequest);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<PresentationExchangeRecord> presentProofRecordsSendRequest(@NonNull String presentationExchangeId, @NonNull V10PresentationSendRequestToProposal request) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/records/" + presentationExchangeId + "/send-request", request);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<PresentationExchangeRecord> presentProofRecordsVerifyPresentation(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/records/" + presentationExchangeId + "/verify-presentation", "{}");
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<PresentationExchangeRecord> presentProofSendProposal(@NonNull PresentProofProposal proofProposal) throws IOException {
        if (proofProposal == null) {
            throw new NullPointerException("proofProposal is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/send-proposal", proofProposal);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<PresentationExchangeRecord> presentProofSendRequest(@NonNull PresentProofRequest proofRequest) throws IOException {
        if (proofRequest == null) {
            throw new NullPointerException("proofRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof/send-request", proofRequest);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<PresentationExchangeRecord> presentProofSendRequest(@NonNull String proofRequestJson) throws IOException {
        if (proofRequestJson == null) {
            throw new NullPointerException("proofRequestJson is marked non-null but is null");
        }
        JsonObject proofRequest = (JsonObject)this.gson.fromJson(proofRequestJson, JsonObject.class);
        Request req = this.buildPost(this.url + "/present-proof/send-request", proofRequest);
        return this.call(req, PresentationExchangeRecord.class);
    }

    public Optional<V20PresExRecord> presentProofV2CreateRequest(@NonNull V20PresCreateRequestRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/create-request", request);
        return this.call(req, V20PresExRecord.class);
    }

    public Optional<List<V20PresExRecord>> presentProofV2Records(@Nullable V2PresentProofRecordsFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/present-proof-2.0/records"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        Optional<String> resp = this.raw(req);
        return this.getWrapped(resp, "results", PROOF_TYPE_V2);
    }

    public Optional<V20PresExRecord> presentProofV2RecordsGetById(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/present-proof-2.0/records/" + presentationExchangeId);
        return this.call(req, V20PresExRecord.class);
    }

    public void presentProofV2RecordsRemove(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        Request req = this.buildDelete(this.url + "/present-proof-2.0/records/" + presentationExchangeId);
        this.call(req);
    }

    public Optional<List<PresentationRequestCredentials>> presentProofV2RecordsCredentials(@NonNull String presentationExchangeId, @Nullable PresentationRequestCredentialsFilter filter) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        return this.presentProofV2RecordsCredentialsInternal(presentationExchangeId, filter, PRESENTATION_REQUEST_CREDENTIALS_INDY);
    }

    public Optional<List<VerifiableCredential.VerifiableCredentialMatch>> presentProofV2RecordsCredentialsDif(@NonNull String presentationExchangeId, @Nullable PresentationRequestCredentialsFilter filter) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        return this.presentProofV2RecordsCredentialsInternal(presentationExchangeId, filter, PRESENTATION_REQUEST_CREDENTIALS_DIF);
    }

    private <T> Optional<T> presentProofV2RecordsCredentialsInternal(@NonNull String presentationExchangeId, @Nullable PresentationRequestCredentialsFilter filter, @NonNull Type t) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (t == null) {
            throw new NullPointerException("t is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/present-proof-2.0/records/" + presentationExchangeId + "/credentials"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, t);
    }

    public void presentProofV2RecordsProblemReport(@NonNull String presentationExchangeId, @NonNull V20PresProblemReportRequest request) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/records/" + presentationExchangeId + "/problem-report", request);
        this.call(req);
    }

    public Optional<V20PresExRecord> presentProofV2RecordsSendPresentation(@NonNull String presentationExchangeId, @NonNull V20PresSpecByFormatRequest presentationRequest) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (presentationRequest == null) {
            throw new NullPointerException("presentationRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/records/" + presentationExchangeId + "/send-presentation", presentationRequest);
        return this.call(req, V20PresExRecord.class);
    }

    public Optional<V20PresExRecord> presentProofV2RecordsSendRequest(@NonNull String presentationExchangeId, @NonNull V20PresentationSendRequestToProposal request) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/records/" + presentationExchangeId + "/send-request", request);
        return this.call(req, V20PresExRecord.class);
    }

    public Optional<V20PresExRecord> presentProofV2RecordsVerifyPresentation(@NonNull String presentationExchangeId) throws IOException {
        if (presentationExchangeId == null) {
            throw new NullPointerException("presentationExchangeId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/records/" + presentationExchangeId + "/verify-presentation", "{}");
        return this.call(req, V20PresExRecord.class);
    }

    public Optional<V20PresExRecord> presentProofV2SendProposal(@NonNull V20PresProposalRequest proofProposal) throws IOException {
        if (proofProposal == null) {
            throw new NullPointerException("proofProposal is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/send-proposal", proofProposal);
        return this.call(req, V20PresExRecord.class);
    }

    public Optional<V20PresExRecord> presentProofV2SendRequest(@NonNull V20PresSendRequestRequest proofRequest) throws IOException {
        if (proofRequest == null) {
            throw new NullPointerException("proofRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/present-proof-2.0/send-request", proofRequest);
        return this.call(req, V20PresExRecord.class);
    }

    public Optional<DIDDocument> resolverResolveDid(@NonNull String did) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/resolver/resolve/" + did);
        return this.getWrapped(this.raw(req), "did_document", (Type)((Object)DIDDocument.class));
    }

    public Optional<IssuerRevRegRecord> revocationActiveRegistry(@NonNull String credentialDefinitionId) throws IOException {
        if (credentialDefinitionId == null) {
            throw new NullPointerException("credentialDefinitionId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/revocation/active-registry/" + credentialDefinitionId);
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public Optional<PublishRevocations> revocationClearPendingRevocations(@NonNull ClearPendingRevocationsRequest request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/revocation/clear-pending-revocations", request);
        return this.call(req, PublishRevocations.class);
    }

    public Optional<IssuerRevRegRecord> revocationCreateRegistry(@NonNull RevRegCreateRequest revRegRequest) throws IOException {
        if (revRegRequest == null) {
            throw new NullPointerException("revRegRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/revocation/create-registry", revRegRequest);
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public Optional<IssuerRevRegRecord> revocationCredentialRecord(RevocationCredentialRecordFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/revocation/credential-record"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.toString());
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public Optional<TxnOrPublishRevocationsResult> revocationPublishRevocations(@NonNull PublishRevocations request) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/revocation/publish-revocations", request);
        return this.call(req, TxnOrPublishRevocationsResult.class);
    }

    public Optional<RevRegsCreated> revocationRegistriesCreated(@Nullable String credentialDefinitionId, @Nullable RevocationRegistryState state) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/revocation/registries/created"))).newBuilder();
        if (StringUtils.isNotEmpty((CharSequence)credentialDefinitionId)) {
            b.addQueryParameter("cred_def_id", credentialDefinitionId);
        }
        if (state != null) {
            b.addQueryParameter("state", state.getValue());
        }
        Request req = this.buildGet(b.build().toString());
        return this.call(req, RevRegsCreated.class);
    }

    public Optional<IssuerRevRegRecord> revocationRegistryGetById(@NonNull String revRegId) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/revocation/registry/" + revRegId);
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public Optional<IssuerRevRegRecord> revocationRegistryUpdateUri(@NonNull String revRegId, @NonNull RevRegUpdateTailsFileUri tailsFileUri) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        if (tailsFileUri == null) {
            throw new NullPointerException("tailsFileUri is marked non-null but is null");
        }
        Request req = this.buildPatch(this.url + "/revocation/registry/" + revRegId, tailsFileUri);
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public Optional<TxnOrRevRegResult> revocationRegistrySendDefinition(@NonNull String revRegId, EndorserInfoFilter filter) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/revocation/registry/" + revRegId + "/definition"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.call(req, TxnOrRevRegResult.class);
    }

    public Optional<IssuerRevRegRecord> revocationRegistrySendEntry(@NonNull String revRegId, EndorserInfoFilter filter) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/revocation/registry/" + revRegId + "/entry"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildPost(b.toString(), "{}");
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public Optional<RevRegWalletUpdatedResult> revocationRegistryFixRevocationEntryState(@NonNull String revRegId, @NonNull FixRevocationEntryStateFilter filter) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/revocation/registry/" + revRegId + "/fix-revocation-entry-state"))).newBuilder();
        filter.buildParams(b);
        Request req = this.buildPut(b.toString(), "{}");
        return this.call(req, RevRegWalletUpdatedResult.class);
    }

    public Optional<RevRegIssuedResult> revocationRegistryIssuedCredentials(@NonNull String revRegId) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/revocation/registry/" + revRegId + "/issued");
        return this.call(req, RevRegIssuedResult.class);
    }

    public Optional<CredRevRecordDetailsResult> revocationRegistryIssuedCredentialsDetails(@NonNull String revRegId) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/revocation/registry/" + revRegId + "/issued/details");
        return this.call(req, CredRevRecordDetailsResult.class);
    }

    public Optional<CredRevIndyRecordsResult> revocationRegistryRevokedCredentialsDetails(@NonNull String revRegId) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/revocation/registry/" + revRegId + "/issued/indy_recs");
        return this.call(req, CredRevIndyRecordsResult.class);
    }

    public Optional<IssuerRevRegRecord> revocationRegistrySetState(@NonNull String revRegId, @NonNull RevocationRegistryState state) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/revocation/registry/" + revRegId + "/set-state"))).newBuilder();
        b.addQueryParameter("state", state.getValue());
        Request req = this.buildPatch(b.toString(), "{}");
        return this.getWrapped(this.raw(req), "result", (Type)((Object)IssuerRevRegRecord.class));
    }

    public void revocationRegistryTailsFile(@NonNull String revRegId) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        Request req = this.buildPut(this.url + "/revocation/registry/" + revRegId + "/tails-file", "{}");
        this.call(req);
    }

    public Optional<String> revocationRegistryDownloadTailsFile(@NonNull String revRegId) throws IOException {
        if (revRegId == null) {
            throw new NullPointerException("revRegId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/revocation/registry/" + revRegId + "/tails-file");
        return this.raw(req);
    }

    public Optional<RevRegCreateResponse.RevocationModuleResponse> revocationRevoke(@NonNull RevokeRequest revokeRequest) throws IOException {
        if (revokeRequest == null) {
            throw new NullPointerException("revokeRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/revocation/revoke", revokeRequest);
        return this.call(req, RevRegCreateResponse.RevocationModuleResponse.class);
    }

    public Optional<SchemaSendResponse> schemas(@NonNull SchemaSendRequest schema) throws IOException {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/schemas", schema);
        return this.call(req, SchemaSendResponse.class);
    }

    public Optional<TxnOrSchemaSendResult> schemas(@NonNull SchemaSendRequest schema, @NonNull EndorserInfoFilter endorserInfoFilter) throws IOException {
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        if (endorserInfoFilter == null) {
            throw new NullPointerException("endorserInfoFilter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/schemas"))).newBuilder();
        endorserInfoFilter.buildParams(b);
        Request req = this.buildPost(b.toString(), schema);
        return this.call(req, TxnOrSchemaSendResult.class);
    }

    public Optional<SchemaSendResponse.Schema> schemasGetById(@NonNull String schemaId) throws IOException {
        if (schemaId == null) {
            throw new NullPointerException("schemaId is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/schemas/" + schemaId);
        return this.getWrapped(this.raw(req), "schema", (Type)((Object)SchemaSendResponse.Schema.class));
    }

    public Optional<List<String>> schemasCreated(@Nullable SchemasCreatedFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/schemas/created"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.toString());
        return this.getWrapped(this.raw(req), "schema_ids", (Type)((Object)List.class));
    }

    public Optional<SchemaSendResponse.Schema> schemasWriteRecord(@NonNull String schemaId) throws IOException {
        if (schemaId == null) {
            throw new NullPointerException("schemaId is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/schemas/" + schemaId + "/write_record", "{}");
        return this.getWrapped(this.raw(req), "schema", (Type)((Object)SchemaSendResponse.Schema.class));
    }

    public Optional<AdminConfig> statusConfig() throws IOException {
        Request req = this.buildGet(this.url + "/status/config");
        return this.call(req, AdminConfig.class);
    }

    public Optional<AdminStatusLiveliness> statusLive() throws IOException {
        Request req = this.buildGet(this.url + "/status/live");
        return this.call(req, AdminStatusLiveliness.class);
    }

    public Optional<AdminStatusReadiness> statusReady() throws IOException {
        Request req = this.buildGet(this.url + "/status/ready");
        return this.call(req, AdminStatusReadiness.class);
    }

    public void statusWaitUntilReady(@NonNull Duration timeout) {
        if (timeout == null) {
            throw new NullPointerException("timeout is marked non-null but is null");
        }
        Instant to = Instant.now().plus(timeout);
        while (Instant.now().isBefore(to)) {
            try {
                Optional<AdminStatusReadiness> statusReady = this.statusReady();
                if (statusReady.isPresent() && statusReady.get().isReady()) {
                    log.info("aca-py is ready");
                    return;
                }
            }
            catch (IOException e) {
                log.trace("aca-py not ready yet, reason: {}", (Object)e.getMessage());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.error("Interrupted while waiting for aca-py", (Throwable)e);
            }
        }
        String msg = "Timeout exceeded, aca-py not ready after: " + timeout;
        log.error(msg);
        throw new AriesException(0, msg);
    }

    public Optional<PingResponse> connectionsSendPing(@NonNull String connectionId, @NonNull PingRequest comment) throws IOException {
        if (connectionId == null) {
            throw new NullPointerException("connectionId is marked non-null but is null");
        }
        if (comment == null) {
            throw new NullPointerException("comment is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/connections/" + connectionId + "/send-ping", comment);
        return this.call(req, PingResponse.class);
    }

    public Optional<List<DID>> walletDid() throws IOException {
        return this.walletDid(null);
    }

    public Optional<List<DID>> walletDid(ListWalletDidFilter filter) throws IOException {
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/wallet/did"))).newBuilder();
        if (filter != null) {
            filter.buildParams(b);
        }
        Request req = this.buildGet(b.toString());
        return this.getWrapped(this.raw(req), "results", WALLET_DID_TYPE);
    }

    public Optional<DID> walletDidCreate(@NonNull WalletDIDCreate didCreate) throws IOException {
        if (didCreate == null) {
            throw new NullPointerException("didCreate is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/wallet/did/create", didCreate);
        return this.getWrapped(this.raw(req), "result", (Type)((Object)DID.class));
    }

    public void walletDidLocalRotateKeypair(@NonNull String did) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/wallet/did/local/rotate-keypair"))).newBuilder();
        b.addQueryParameter("did", did);
        this.call(this.buildPatch(b.toString(), "{}"));
    }

    public Optional<DID> walletDidPublic() throws IOException {
        Request req = this.buildGet(this.url + "/wallet/did/public");
        return this.getWrapped(this.raw(req), "result", (Type)((Object)DID.class));
    }

    public Optional<DID> walletDidPublic(@NonNull String did) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/wallet/did/public"))).newBuilder();
        b.addQueryParameter("did", did);
        Request req = this.buildPost(b.toString(), "{}");
        return this.getWrapped(this.raw(req), "result", (Type)((Object)DID.class));
    }

    public Optional<DID> walletDidPublic(@NonNull String did, @NonNull EndorserInfoFilter endorserInfoFilter) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        if (endorserInfoFilter == null) {
            throw new NullPointerException("endorserInfoFilter is marked non-null but is null");
        }
        HttpUrl.Builder b = Objects.requireNonNull(HttpUrl.parse((String)(this.url + "/wallet/did/public"))).newBuilder();
        endorserInfoFilter.buildParams(b);
        b.addQueryParameter("did", did);
        Request req = this.buildPost(b.toString(), "{}");
        return this.getWrapped(this.raw(req), "result", (Type)((Object)DID.class));
    }

    public Optional<DIDEndpoint> walletGetDidEndpoint(@NonNull String did) throws IOException {
        if (did == null) {
            throw new NullPointerException("did is marked non-null but is null");
        }
        Request req = this.buildGet(this.url + "/wallet/get-did-endpoint?did=" + did);
        return this.call(req, DIDEndpoint.class);
    }

    public void walletSetDidEndpoint(@NonNull DIDEndpointWithType endpointRequest) throws IOException {
        if (endpointRequest == null) {
            throw new NullPointerException("endpointRequest is marked non-null but is null");
        }
        Request req = this.buildPost(this.url + "/wallet/set-did-endpoint", endpointRequest);
        this.call(req);
    }

    private Request buildPost(String u, Object body) {
        return this.request(u).post(AriesClient.jsonBody(this.gson.toJson(body))).build();
    }

    private Request buildPut(String u, Object body) {
        return this.request(u).put(AriesClient.jsonBody(this.gson.toJson(body))).build();
    }

    private Request buildPatch(String u, Object body) {
        return this.request(u).patch(AriesClient.jsonBody(this.gson.toJson(body))).build();
    }

    private Request buildGet(String u) {
        return this.request(u).get().build();
    }

    private Request buildDelete(String u) {
        return this.request(u).delete().build();
    }

    private Request.Builder request(String u) {
        Request.Builder b = new Request.Builder().url(u).header("X-API-Key", this.apiKey);
        if (StringUtils.isNotEmpty((CharSequence)this.bearerToken)) {
            b.header("Authorization", "Bearer " + this.bearerToken);
        }
        return b;
    }

    public static AriesClientBuilder builder() {
        return new AriesClientBuilder();
    }

    public static class AriesClientBuilder {
        private String url;
        private String apiKey;
        private String bearerToken;
        private OkHttpClient client;

        AriesClientBuilder() {
        }

        public AriesClientBuilder url(@Nullable String url) {
            this.url = url;
            return this;
        }

        public AriesClientBuilder apiKey(@Nullable String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public AriesClientBuilder bearerToken(@Nullable String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public AriesClientBuilder client(@Nullable OkHttpClient client) {
            this.client = client;
            return this;
        }

        public AriesClient build() {
            return new AriesClient(this.url, this.apiKey, this.bearerToken, this.client);
        }

        public String toString() {
            return "AriesClient.AriesClientBuilder(url=" + this.url + ", apiKey=" + this.apiKey + ", bearerToken=" + this.bearerToken + ", client=" + this.client + ")";
        }
    }
}

