/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.acy_py.generated.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class DID {
    public static final String SERIALIZED_NAME_DID = "did";
    @SerializedName(value="did")
    private String did;
    public static final String SERIALIZED_NAME_KEY_TYPE = "key_type";
    @SerializedName(value="key_type")
    private KeyTypeEnum keyType;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    private MethodEnum method;
    public static final String SERIALIZED_NAME_POSTURE = "posture";
    @SerializedName(value="posture")
    private PostureEnum posture;
    public static final String SERIALIZED_NAME_VERKEY = "verkey";
    @SerializedName(value="verkey")
    private String verkey;

    public static DIDBuilder builder() {
        return new DIDBuilder();
    }

    public String getDid() {
        return this.did;
    }

    public KeyTypeEnum getKeyType() {
        return this.keyType;
    }

    public MethodEnum getMethod() {
        return this.method;
    }

    public PostureEnum getPosture() {
        return this.posture;
    }

    public String getVerkey() {
        return this.verkey;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public void setKeyType(KeyTypeEnum keyType) {
        this.keyType = keyType;
    }

    public void setMethod(MethodEnum method) {
        this.method = method;
    }

    public void setPosture(PostureEnum posture) {
        this.posture = posture;
    }

    public void setVerkey(String verkey) {
        this.verkey = verkey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DID)) {
            return false;
        }
        DID other = (DID)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$did = this.getDid();
        String other$did = other.getDid();
        if (this$did == null ? other$did != null : !this$did.equals(other$did)) {
            return false;
        }
        KeyTypeEnum this$keyType = this.getKeyType();
        KeyTypeEnum other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !((Object)((Object)this$keyType)).equals((Object)other$keyType)) {
            return false;
        }
        MethodEnum this$method = this.getMethod();
        MethodEnum other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        PostureEnum this$posture = this.getPosture();
        PostureEnum other$posture = other.getPosture();
        if (this$posture == null ? other$posture != null : !((Object)((Object)this$posture)).equals((Object)other$posture)) {
            return false;
        }
        String this$verkey = this.getVerkey();
        String other$verkey = other.getVerkey();
        return !(this$verkey == null ? other$verkey != null : !this$verkey.equals(other$verkey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DID;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $did = this.getDid();
        result = result * 59 + ($did == null ? 43 : $did.hashCode());
        KeyTypeEnum $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : ((Object)((Object)$keyType)).hashCode());
        MethodEnum $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        PostureEnum $posture = this.getPosture();
        result = result * 59 + ($posture == null ? 43 : ((Object)((Object)$posture)).hashCode());
        String $verkey = this.getVerkey();
        result = result * 59 + ($verkey == null ? 43 : $verkey.hashCode());
        return result;
    }

    public String toString() {
        return "DID(did=" + this.getDid() + ", keyType=" + this.getKeyType() + ", method=" + this.getMethod() + ", posture=" + this.getPosture() + ", verkey=" + this.getVerkey() + ")";
    }

    public DID(String did, KeyTypeEnum keyType, MethodEnum method, PostureEnum posture, String verkey) {
        this.did = did;
        this.keyType = keyType;
        this.method = method;
        this.posture = posture;
        this.verkey = verkey;
    }

    public DID() {
    }

    public static class DIDBuilder {
        private String did;
        private KeyTypeEnum keyType;
        private MethodEnum method;
        private PostureEnum posture;
        private String verkey;

        DIDBuilder() {
        }

        public DIDBuilder did(String did) {
            this.did = did;
            return this;
        }

        public DIDBuilder keyType(KeyTypeEnum keyType) {
            this.keyType = keyType;
            return this;
        }

        public DIDBuilder method(MethodEnum method) {
            this.method = method;
            return this;
        }

        public DIDBuilder posture(PostureEnum posture) {
            this.posture = posture;
            return this;
        }

        public DIDBuilder verkey(String verkey) {
            this.verkey = verkey;
            return this;
        }

        public DID build() {
            return new DID(this.did, this.keyType, this.method, this.posture, this.verkey);
        }

        public String toString() {
            return "DID.DIDBuilder(did=" + this.did + ", keyType=" + this.keyType + ", method=" + this.method + ", posture=" + this.posture + ", verkey=" + this.verkey + ")";
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PostureEnum {
        PUBLIC("public"),
        POSTED("posted"),
        WALLET_ONLY("wallet_only");

        private String value;

        private PostureEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PostureEnum fromValue(String value) {
            for (PostureEnum b : PostureEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PostureEnum> {
            public void write(JsonWriter jsonWriter, PostureEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PostureEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PostureEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum MethodEnum {
        SOV("sov"),
        KEY("key");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static MethodEnum fromValue(String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<MethodEnum> {
            public void write(JsonWriter jsonWriter, MethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public MethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return MethodEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KeyTypeEnum {
        ED25519("ed25519"),
        BLS12381G2("bls12381g2");

        private String value;

        private KeyTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KeyTypeEnum fromValue(String value) {
            for (KeyTypeEnum b : KeyTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<KeyTypeEnum> {
            public void write(JsonWriter jsonWriter, KeyTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KeyTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KeyTypeEnum.fromValue(value);
            }
        }
    }
}

