/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReentrantLock {
    private static final Log log = LogFactory.getLog((Class)(class$net$wimpi$telnetd$util$ReentrantLock == null ? (class$net$wimpi$telnetd$util$ReentrantLock = ReentrantLock.class$("net.wimpi.telnetd.util.ReentrantLock")) : class$net$wimpi$telnetd$util$ReentrantLock));
    protected Thread m_Owner = null;
    protected long m_Holds = 0L;
    static /* synthetic */ Class class$net$wimpi$telnetd$util$ReentrantLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.m_Owner) {
                ++this.m_Holds;
            } else {
                try {
                    while (this.m_Owner != null) {
                        this.wait();
                    }
                    this.m_Owner = caller;
                    this.m_Holds = 1L;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (caller == this.m_Owner) {
                ++this.m_Holds;
                return true;
            }
            if (this.m_Owner == null) {
                this.m_Owner = caller;
                this.m_Holds = 1L;
                return true;
            }
            if (msecs <= 0L) {
                return false;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (caller == this.m_Owner) {
                        ++this.m_Holds;
                        return true;
                    }
                    if (this.m_Owner != null) continue;
                    this.m_Owner = caller;
                    this.m_Holds = 1L;
                    return true;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                return false;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.m_Owner) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.m_Holds == 0L) {
            this.m_Owner = null;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.m_Owner || n > this.m_Holds) {
            throw new Error("Illegal Lock usage");
        }
        this.m_Holds -= n;
        if (this.m_Holds == 0L) {
            this.m_Owner = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.m_Owner) {
            return 0L;
        }
        return this.m_Holds;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

