/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import java.util.Iterator;
import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Communications;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.PhoneNumber;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class TELItemHandler
implements ItemHandler {
    TELItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        boolean pref = false;
        PhoneNumber tel = Pim.getContactModelFactory().createPhoneNumber();
        tel.setNumber(item.getDecodedValue());
        String[] components = item.getParameter("TYPE");
        if (components == null) {
            components = item.getParameter("DEFAULT");
        }
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                String type = components[i].toUpperCase();
                if (type.equals("HOME")) {
                    tel.setHome(true);
                    continue;
                }
                if (type.equals("WORK")) {
                    tel.setWork(true);
                    continue;
                }
                if (type.equals("VOICE")) {
                    tel.setVoice(true);
                    continue;
                }
                if (type.equals("FAX")) {
                    tel.setFax(true);
                    continue;
                }
                if (type.equals("MSG")) {
                    tel.setMessaging(true);
                    continue;
                }
                if (type.equals("CELL")) {
                    tel.setCellular(true);
                    continue;
                }
                if (type.equals("PAGER")) {
                    tel.setPager(true);
                    continue;
                }
                if (type.equals("BBS")) {
                    tel.setBBS(true);
                    continue;
                }
                if (type.equals("MODEM")) {
                    tel.setMODEM(true);
                    continue;
                }
                if (type.equals("CAR")) {
                    tel.setCellular(true);
                    continue;
                }
                if (type.equals("ISDN")) {
                    tel.setISDN(true);
                    continue;
                }
                if (type.equals("PREF")) {
                    tel.setPreferred(true);
                    continue;
                }
                if (type.equals("VIDEO")) {
                    tel.setVideo(true);
                    continue;
                }
                if (type.equals("CAR")) {
                    tel.setCar(true);
                    continue;
                }
                if (type.equals("PCS")) {
                    tel.setPCS(true);
                    continue;
                }
                if (!type.equals("PREF")) continue;
                pref = true;
            }
        } else {
            tel.setVoice(true);
        }
        Communications comm = ct.getCommunications();
        if (comm == null) {
            comm = Pim.getContactModelFactory().createCommunications();
            ct.setCommunications(comm);
        }
        comm.addPhoneNumber(tel);
        if (pref) {
            comm.setPreferredPhoneNumber(tel);
        }
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasCommunications()) {
            return new versitItem[0];
        }
        Communications comm = ct.getCommunications();
        versitItem[] items = new versitItem[comm.getPhoneNumberCount()];
        int i = 0;
        Iterator iter = comm.getPhoneNumbers();
        while (iter.hasNext()) {
            PhoneNumber tel = (PhoneNumber)iter.next();
            if (tel == null) {
                return new versitItem[0];
            }
            String telnr = tel.getNumber();
            if (!StringUtil.isValidString(telnr)) {
                return new versitItem[0];
            }
            versitItem item = new versitItem("TEL");
            if (tel.isPreferred()) {
                item.addParameter("TYPE", "PREF");
            }
            if (tel.isWork()) {
                item.addParameter("TYPE", "WORK");
            }
            if (tel.isHome()) {
                item.addParameter("TYPE", "HOME");
            }
            if (tel.isVoice()) {
                item.addParameter("TYPE", "VOICE");
            }
            if (tel.isFax()) {
                item.addParameter("TYPE", "FAX");
            }
            if (tel.isMessaging()) {
                item.addParameter("TYPE", "MSG");
            }
            if (tel.isCellular()) {
                item.addParameter("TYPE", "CELL");
            }
            if (tel.isPager()) {
                item.addParameter("TYPE", "PAGER");
            }
            if (tel.isBBS()) {
                item.addParameter("TYPE", "BBS");
            }
            if (tel.isMODEM()) {
                item.addParameter("TYPE", "MODEM");
            }
            if (tel.isISDN()) {
                item.addParameter("TYPE", "ISDN");
            }
            if (tel.isVideo()) {
                item.addParameter("TYPE", "VIDEO");
            }
            if (tel.isPCS()) {
                item.addParameter("TYPE", "PCS");
            }
            if (tel.isCar()) {
                item.addParameter("TYPE", "CAR");
            }
            if (comm.isPreferredPhoneNumber(tel)) {
                item.addParameter("TYPE", "PREF");
            }
            item.setValue(telnr);
            items[i] = item;
            ++i;
        }
        return items;
    }
}

