/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.Sound;
import net.wimpi.pim.util.EncodingUtility;
import net.wimpi.pim.util.versitio.versitItem;

class SOUNDItemHandler
implements ItemHandler {
    SOUNDItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        Sound sound = Pim.getContactModelFactory().createSound();
        String[] paramvalues = null;
        paramvalues = item.getParameter("VALUE");
        if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("URL") || paramvalues[0].equalsIgnoreCase("URI"))) {
            sound.setURI(item.getDecodedValue());
        } else {
            paramvalues = item.getParameter("ENCODING");
            if (paramvalues != null && (paramvalues[0].equalsIgnoreCase("B") || paramvalues[0].equalsIgnoreCase("BASE64"))) {
                sound.setData(EncodingUtility.decodeBase64(EncodingUtility.removeWhiteSpace(item.getValue().getBytes())));
            }
            if ((paramvalues = item.getParameter("TYPE")) == null) {
                paramvalues = item.getParameter("DEFAULT");
            }
            if (paramvalues != null) {
                sound.setContentType("audio/" + paramvalues[0].toLowerCase());
            }
        }
        ct.setSound(sound);
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasSound()) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        Sound sound = ct.getSound();
        versitItem item = new versitItem("SOUND");
        if (sound.isURI()) {
            item.addParameter("VALUE", "URI");
            item.setValue(sound.getURI());
        } else {
            String ctype = sound.getContentType();
            ctype = ctype.substring(ctype.indexOf("/") + 1, ctype.length()).toUpperCase();
            item.addParameter("ENCODING", "B");
            item.addParameter("TYPE", ctype);
            item.setValue(new String(EncodingUtility.removeWhiteSpace(EncodingUtility.encodeBase64(sound.getData()))));
        }
        items[0] = item;
        return items;
    }
}

