/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.db.serializable;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.wimpi.pim.contact.db.AbstractContactFilter;
import net.wimpi.pim.contact.db.ContactCollection;
import net.wimpi.pim.contact.db.ContactFilter;
import net.wimpi.pim.contact.db.ContactGroup;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.util.AbstractIdentifiable;

public class ContactCollectionImpl
implements ContactCollection,
Serializable {
    static final long serialVersionUID = -7518133802753769769L;
    protected Map m_Contacts = new HashMap(50);
    protected Map m_NameIndex = new HashMap(50);
    protected transient int m_ModCount = 0;

    public boolean contains(String UID) {
        return this.m_Contacts.keySet().contains(UID);
    }

    public boolean contains(Contact contact) {
        return this.contains(contact.getUID());
    }

    public boolean containsByName(String name) {
        return this.m_NameIndex.keySet().contains(name);
    }

    public Contact get(String UID) {
        return (Contact)this.m_Contacts.get(UID);
    }

    public Contact getByName(String name) {
        return this.get((String)this.m_NameIndex.get(name));
    }

    public Contact[] toArray() {
        Contact[] contacts = new Contact[this.m_Contacts.size()];
        Iterator iter = this.iterator();
        for (int i = 0; i < this.m_Contacts.size(); ++i) {
            contacts[i] = (Contact)iter.next();
        }
        return contacts;
    }

    public Contact[] toArray(ContactFilter filter) {
        ContactIterator iter = new ContactIterator(filter);
        Contact[] contacts = new Contact[iter.size()];
        for (int i = 0; i < iter.size(); ++i) {
            contacts[i] = (Contact)iter.next();
        }
        return contacts;
    }

    public void add(Contact contact) {
        if (!this.m_Contacts.keySet().contains(contact.getUID())) {
            int size = this.size();
            this.m_Contacts.put(contact.getUID(), contact);
            this.addToNameIndex(contact);
            if (size != this.size()) {
                this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
            }
        }
    }

    public Contact remove(String UID) {
        Contact ct = (Contact)this.m_Contacts.remove(UID);
        if (ct != null) {
            this.removeFromNameIndex(ct);
            this.m_ModCount = this.m_ModCount == Integer.MAX_VALUE ? 0 : ++this.m_ModCount;
        }
        return ct;
    }

    public void remove(Contact contact) {
        this.remove(contact.getUID());
    }

    public Iterator iterator() {
        return new ContactIterator();
    }

    public Iterator iterator(ContactFilter filter) {
        return new ContactIterator(filter);
    }

    public int size() {
        return this.m_Contacts.size();
    }

    private void addToNameIndex(Contact contact) {
        String fn;
        if (contact == null) {
            return;
        }
        if (contact.hasPersonalIdentity() && (fn = contact.getPersonalIdentity().getFormattedName()) != null && fn.length() > 0) {
            this.m_NameIndex.put(fn, contact.getUID());
        }
    }

    private void removeFromNameIndex(Contact contact) {
        String fn;
        if (contact == null) {
            return;
        }
        if (contact.hasPersonalIdentity() && (fn = contact.getPersonalIdentity().getFormattedName()) != null && fn.length() > 0) {
            this.m_NameIndex.remove(fn);
        }
    }

    private boolean modified(int modcount) {
        return modcount != this.m_ModCount;
    }

    ContactGroup createContactGroup() {
        return new ContactGroupImpl();
    }

    protected class ContactGroupImpl
    extends AbstractIdentifiable
    implements ContactGroup,
    Serializable {
        static final long serialVersionUID = 1294968173858663287L;
        protected String m_Name;
        protected String m_Description;
        protected List m_ContactIDs = new ArrayList(10);

        public String getName() {
            return this.m_Name;
        }

        public void setName(String name) {
            this.m_Name = name;
        }

        public String getDescription() {
            return this.m_Description;
        }

        public void setDescription(String description) {
            this.m_Description = description;
        }

        public Contact[] listContacts() {
            ContactIterator iter = (ContactIterator)this.getContacts();
            Contact[] contacts = new Contact[iter.size()];
            for (int i = 0; i < iter.size(); ++i) {
                contacts[i] = (Contact)iter.next();
            }
            return contacts;
        }

        public Iterator getContacts() {
            return new ContactIterator(new AbstractContactFilter(){

                public boolean passes(Contact contact) {
                    return ContactGroupImpl.this.contains(contact.getUID());
                }
            });
        }

        public void addContact(Contact contact) {
            if (!ContactCollectionImpl.this.contains(contact)) {
                throw new IllegalArgumentException();
            }
            this.m_ContactIDs.add(contact.getUID());
        }

        public void removeContact(Contact contact) {
            this.m_ContactIDs.remove(contact.getUID());
        }

        public boolean contains(String UID) {
            return this.m_ContactIDs.contains(UID);
        }

        public boolean contains(Contact contact) {
            return this.contains(contact.getUID());
        }

        public int size() {
            return this.m_ContactIDs.size();
        }

        public void cleanup() {
            Iterator iter = this.m_ContactIDs.iterator();
            while (iter.hasNext()) {
                if (ContactCollectionImpl.this.contains((String)iter.next())) continue;
                iter.remove();
            }
            System.out.println("cleanup():" + this.m_ContactIDs.toString());
        }

        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            this.cleanup();
            s.defaultWriteObject();
        }
    }

    class ContactIterator
    implements Iterator {
        private ArrayList m_Entries;
        private int m_Next;
        private int m_Last = -1;
        private int m_ExpectedModCount;

        public ContactIterator() {
            this.m_ExpectedModCount = ContactCollectionImpl.this.m_ModCount;
            this.prepare(null);
        }

        public ContactIterator(ContactFilter filter) {
            this.m_ExpectedModCount = ContactCollectionImpl.this.m_ModCount;
            this.prepare(filter);
        }

        private void prepare(ContactFilter filter) {
            int size = ContactCollectionImpl.this.size();
            this.m_Entries = new ArrayList(size);
            Iterator iter = ContactCollectionImpl.this.m_Contacts.values().iterator();
            for (int i = 0; i < size; ++i) {
                Contact ct = (Contact)iter.next();
                if (filter != null) {
                    if (!filter.passes(ct)) continue;
                    this.m_Entries.add(ct);
                    continue;
                }
                this.m_Entries.add(ct);
            }
            this.m_Next = 0;
        }

        public boolean hasNext() {
            return this.m_Next < this.m_Entries.size();
        }

        public Object next() {
            if (this.m_Next >= this.m_Entries.size()) {
                throw new NoSuchElementException();
            }
            if (ContactCollectionImpl.this.modified(this.m_ExpectedModCount)) {
                throw new ConcurrentModificationException();
            }
            Object rv = this.m_Entries.get(this.m_Next);
            this.m_Last = this.m_Next++;
            return rv;
        }

        public void remove() {
            if (this.m_Last == -1) {
                throw new IllegalStateException();
            }
            ContactCollectionImpl.this.remove((Contact)this.m_Entries.get(this.m_Last));
            this.m_Entries.remove(this.m_Last);
            this.m_Last = -1;
            --this.m_Next;
            ++this.m_ExpectedModCount;
        }

        public int size() {
            return this.m_Entries.size();
        }

        public List getEntries() {
            return this.m_Entries;
        }
    }
}

