/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ResultSetOperation {
    private final Method method;
    private final Object[] args;
    private final Object result;
    private final Throwable thrown;
    private static final Set<String> NON_DATA_RETRIEVAL_METHODS = new HashSet<String>();

    public ResultSetOperation(Method method, Object[] args, Object result, Throwable thrown) {
        this.method = method;
        this.args = args;
        this.result = result;
        this.thrown = thrown;
    }

    public static boolean isDataRetrievalOperation(ResultSetOperation op) {
        String methodName = op.getMethod().getName();
        return methodName.startsWith("get") && !NON_DATA_RETRIEVAL_METHODS.contains(methodName);
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getResult() {
        return this.result;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    static {
        NON_DATA_RETRIEVAL_METHODS.addAll(Arrays.asList("getConcurrency", "getCursorName", "getMetaData", "getFetchDirection", "getFetchSize", "getHoldability", "getRow", "getStatement", "getType", "getWarnings"));
    }
}

