/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.InterceptorHolder;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public class ProxyDataSource
implements DataSource,
Closeable {
    private DataSource dataSource;
    private InterceptorHolder interceptorHolder = new InterceptorHolder();
    private String dataSourceName = "";
    private JdbcProxyFactory jdbcProxyFactory = JdbcProxyFactory.DEFAULT;

    public ProxyDataSource() {
    }

    public ProxyDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        return this.getConnectionProxy(conn);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection conn = this.dataSource.getConnection(username, password);
        return this.getConnectionProxy(conn);
    }

    private Connection getConnectionProxy(Connection conn) {
        return this.jdbcProxyFactory.createConnection(conn, this.interceptorHolder, this.dataSourceName);
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.dataSource.setLogWriter(printWriter);
    }

    @Override
    public void setLoginTimeout(int i) throws SQLException {
        this.dataSource.setLoginTimeout(i);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> tClass) throws SQLException {
        return this.dataSource.unwrap(tClass);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    public void setListener(QueryExecutionListener listener) {
        this.interceptorHolder = new InterceptorHolder(listener, QueryTransformer.DEFAULT);
    }

    public void addListener(QueryExecutionListener listener) {
        this.interceptorHolder.addListener(listener);
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    @IgnoreJRERequirement
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    public JdbcProxyFactory getJdbcProxyFactory() {
        return this.jdbcProxyFactory;
    }

    public void setJdbcProxyFactory(JdbcProxyFactory jdbcProxyFactory) {
        this.jdbcProxyFactory = jdbcProxyFactory;
    }

    public InterceptorHolder getInterceptorHolder() {
        return this.interceptorHolder;
    }

    public void setInterceptorHolder(InterceptorHolder interceptorHolder) {
        this.interceptorHolder = interceptorHolder;
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource instanceof Closeable) {
            ((Closeable)((Object)this.dataSource)).close();
        }
    }
}

