/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ConditionalEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.VariableListenerEventDefinition;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.BpmnJsonConverterUtil;

public class CatchEventJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        CatchEventJsonConverter.fillJsonTypes(convertersToBpmnMap);
        CatchEventJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CatchTimerEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchMessageEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchSignalEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchConditionalEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchEventRegistryEvent", CatchEventJsonConverter.class);
        convertersToBpmnMap.put("CatchVariableListenerEvent", CatchEventJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(IntermediateCatchEvent.class, CatchEventJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        String eventType;
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)baseElement;
        List eventDefinitions = catchEvent.getEventDefinitions();
        if (eventDefinitions.size() != 1) {
            return "CatchTimerEvent";
        }
        EventDefinition eventDefinition = (EventDefinition)eventDefinitions.get(0);
        if (eventDefinition instanceof MessageEventDefinition) {
            return "CatchMessageEvent";
        }
        if (eventDefinition instanceof SignalEventDefinition) {
            return "CatchSignalEvent";
        }
        if (eventDefinition instanceof ConditionalEventDefinition) {
            return "CatchConditionalEvent";
        }
        if (eventDefinition instanceof TimerEventDefinition) {
            return "CatchTimerEvent";
        }
        if (eventDefinition instanceof VariableListenerEventDefinition) {
            return "CatchVariableListenerEvent";
        }
        if (baseElement.getExtensionElements().get("eventType") != null && !((List)baseElement.getExtensionElements().get("eventType")).isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)((List)baseElement.getExtensionElements().get("eventType")).get(0)).getElementText()))) {
            return "CatchEventRegistryEvent";
        }
        return "CatchTimerEvent";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        IntermediateCatchEvent catchEvent = (IntermediateCatchEvent)baseElement;
        this.addEventProperties((Event)catchEvent, propertiesNode);
        this.addEventRegistryProperties((FlowElement)baseElement, propertiesNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        IntermediateCatchEvent catchEvent = new IntermediateCatchEvent();
        String stencilId = BpmnJsonConverterUtil.getStencilId(elementNode);
        if ("CatchTimerEvent".equals(stencilId)) {
            this.convertJsonToTimerDefinition(elementNode, (Event)catchEvent);
        } else if ("CatchMessageEvent".equals(stencilId)) {
            this.convertJsonToMessageDefinition(elementNode, (Event)catchEvent);
        } else if ("CatchSignalEvent".equals(stencilId)) {
            this.convertJsonToSignalDefinition(elementNode, (Event)catchEvent);
        } else if ("CatchConditionalEvent".equals(stencilId)) {
            this.convertJsonToConditionalDefinition(elementNode, (Event)catchEvent);
        } else if ("CatchEventRegistryEvent".equals(stencilId)) {
            this.addReceiveEventExtensionElements(elementNode, (FlowElement)catchEvent);
        } else if ("CatchVariableListenerEvent".equals(stencilId)) {
            this.convertJsonToVariableListenerDefinition(elementNode, (Event)catchEvent);
        }
        return catchEvent;
    }
}

