/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scimv11.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import net.tirasa.connid.bundles.scimv11.SCIMv11ConnectorConfiguration;
import net.tirasa.connid.bundles.scimv11.dto.PagedResults;
import net.tirasa.connid.bundles.scimv11.dto.SCIMAttribute;
import net.tirasa.connid.bundles.scimv11.dto.SCIMSchema;
import net.tirasa.connid.bundles.scimv11.dto.User;
import net.tirasa.connid.bundles.scimv11.service.NoSuchEntityException;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Utils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;

public class SCIMv11Service {
    private static final Log LOG = Log.getLog(SCIMv11Service.class);
    protected final SCIMv11ConnectorConfiguration config;
    public static final String RESPONSE_ERRORS = "Errors";
    public static final String RESPONSE_RESOURCES = "Resources";

    public SCIMv11Service(SCIMv11ConnectorConfiguration config) {
        this.config = config;
    }

    protected WebClient getWebclient(String path, Map<String, String> params) {
        WebClient webClient;
        if (StringUtil.isNotBlank((String)this.config.getCliendId()) && StringUtil.isNotBlank((String)this.config.getClientSecret()) && StringUtil.isNotBlank((String)this.config.getAccessTokenBaseAddress()) && StringUtil.isNotBlank((String)this.config.getAccessTokenNodeId())) {
            webClient = WebClient.create((String)this.config.getBaseAddress()).type(this.config.getAccept()).accept(new String[]{this.config.getContentType()}).path((Object)path);
            webClient.header("Authorization", new Object[]{"Bearer " + this.generateToken()});
        } else {
            webClient = WebClient.create((String)this.config.getBaseAddress(), (String)this.config.getUsername(), this.config.getPassword() == null ? null : SecurityUtil.decrypt((GuardedString)this.config.getPassword()), null).type(this.config.getAccept()).accept(new String[]{this.config.getContentType()}).path((Object)path);
        }
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                webClient.query(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        return webClient;
    }

    private String generateToken() {
        WebClient webClient = WebClient.create((String)this.config.getAccessTokenBaseAddress()).type(this.config.getAccessTokenContentType()).accept(new String[]{this.config.getAccept()});
        String contentUri = "&client_id=" + this.config.getCliendId() + "&client_secret=" + this.config.getClientSecret() + "&username=" + this.config.getUsername() + "&password=" + SecurityUtil.decrypt((GuardedString)this.config.getPassword());
        String token = null;
        try {
            Response response = webClient.post((Object)contentUri);
            String responseAsString = (String)response.readEntity(String.class);
            JsonNode result = SCIMv11Utils.MAPPER.readTree(responseAsString);
            if (result == null || !result.hasNonNull(this.config.getAccessTokenNodeId())) {
                SCIMv11Utils.handleGeneralError("No access token found - " + responseAsString);
            }
            token = result.get(this.config.getAccessTokenNodeId()).textValue();
        }
        catch (Exception ex) {
            SCIMv11Utils.handleGeneralError("While obtaining authentication token", ex);
        }
        return token;
    }

    protected JsonNode doGet(WebClient webClient) {
        LOG.ok("GET: {0}", new Object[]{webClient.getCurrentURI()});
        JsonNode result = null;
        try {
            Response response = webClient.get();
            String responseAsString = (String)response.readEntity(String.class);
            this.checkServiceErrors(response);
            result = SCIMv11Utils.MAPPER.readTree(responseAsString);
            if (result == null) {
                LOG.ok("Empty result from GET request", new Object[0]);
                result = SCIMv11Utils.MAPPER.createObjectNode();
            }
            if (result.isArray() && (!result.has(RESPONSE_RESOURCES) || result.get(RESPONSE_RESOURCES).isNull())) {
                SCIMv11Utils.handleGeneralError("Wrong response from GET request: " + responseAsString);
            }
            this.checkServiceResultErrors(result, response);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While retrieving data from SCIM API", new Object[0]);
        }
        return result;
    }

    protected void doCreate(User user, WebClient webClient) {
        LOG.ok("CREATE: {0}", new Object[]{webClient.getCurrentURI()});
        String payload = null;
        try {
            JsonNode customAttributesNode = this.buildCustomAttributesNode(this.config.getCustomAttributesJSON(), user);
            if (customAttributesNode != null) {
                JsonNode userNode = null;
                try {
                    userNode = this.mergeNodes(SCIMv11Utils.MAPPER.readTree(SCIMv11Utils.MAPPER.writeValueAsString((Object)user)), customAttributesNode);
                }
                catch (JsonProcessingException ex) {
                    SCIMv11Utils.handleGeneralError("While converting user to node", (Exception)((Object)ex));
                }
                payload = SCIMv11Utils.MAPPER.writeValueAsString(userNode);
            } else {
                payload = SCIMv11Utils.MAPPER.writeValueAsString((Object)user);
            }
            Response response = webClient.post((Object)payload);
            this.checkServiceErrors(response);
            String value = "id";
            String responseAsString = (String)response.readEntity(String.class);
            JsonNode responseObj = SCIMv11Utils.MAPPER.readTree(responseAsString);
            if (responseObj.hasNonNull(value)) {
                user.setId(responseObj.get(value).textValue());
            } else {
                LOG.error("CREATE payload {0}: ", new Object[]{payload});
                SCIMv11Utils.handleGeneralError("While getting " + value + " value for created User - Response : " + responseAsString);
            }
        }
        catch (IOException ex) {
            LOG.error("CREATE payload {0}: ", new Object[]{payload});
            SCIMv11Utils.handleGeneralError("While creating User", ex);
        }
    }

    protected JsonNode doUpdate(User user, WebClient webClient) {
        LOG.ok("UPDATE: {0}", new Object[]{webClient.getCurrentURI()});
        JsonNode result = null;
        String payload = null;
        if (this.config.getUpdateMethod().equalsIgnoreCase("PATCH")) {
            WebClient.getConfig((Object)webClient).getRequestContext().put("use.async.http.conduit", true);
        }
        try {
            JsonNode customAttributesNode = this.buildCustomAttributesNode(this.config.getCustomAttributesJSON(), user);
            if (customAttributesNode != null) {
                JsonNode userNode = null;
                try {
                    userNode = this.mergeNodes(SCIMv11Utils.MAPPER.readTree(SCIMv11Utils.MAPPER.writeValueAsString((Object)user)), customAttributesNode);
                }
                catch (JsonProcessingException ex) {
                    SCIMv11Utils.handleGeneralError("While converting user to node", (Exception)((Object)ex));
                }
                payload = SCIMv11Utils.MAPPER.writeValueAsString(userNode);
            } else {
                payload = SCIMv11Utils.MAPPER.writeValueAsString((Object)user);
            }
            Response response = this.config.getUpdateMethod().equalsIgnoreCase("PATCH") ? webClient.invoke("PATCH", (Object)payload) : webClient.put((Object)payload);
            this.checkServiceErrors(response);
            result = SCIMv11Utils.MAPPER.readTree((String)response.readEntity(String.class));
            this.checkServiceResultErrors(result, response);
        }
        catch (IOException ex) {
            LOG.error("UPDATE payload {0}: ", new Object[]{payload});
            SCIMv11Utils.handleGeneralError("While updating User", ex);
        }
        return result;
    }

    protected void doDelete(String userId, WebClient webClient) {
        LOG.ok("DELETE: {0}", new Object[]{webClient.getCurrentURI()});
        int status = webClient.delete().getStatus();
        if (status != Response.Status.NO_CONTENT.getStatusCode() && status != Response.Status.OK.getStatusCode()) {
            throw new NoSuchEntityException(userId);
        }
    }

    protected void doActivate(String userId, WebClient webClient) {
        LOG.ok("ACTIVATE: {0}", new Object[]{webClient.getCurrentURI()});
        try {
            ObjectNode userIdNode = SCIMv11Utils.MAPPER.createObjectNode();
            userIdNode.set("user_id", (JsonNode)userIdNode.textNode(userId));
            Response response = webClient.post((Object)SCIMv11Utils.MAPPER.writeValueAsString((Object)userIdNode));
            if (response == null) {
                SCIMv11Utils.handleGeneralError("While activating User - no response");
            } else {
                String responseAsString = (String)response.readEntity(String.class);
                LOG.ok("Response after activating user: {0}", new Object[]{responseAsString});
            }
        }
        catch (IOException ex) {
            SCIMv11Utils.handleGeneralError("While activating User", ex);
        }
    }

    private void checkServiceErrors(Response response) {
        if (response == null) {
            SCIMv11Utils.handleGeneralError("While executing request - no response");
        }
        String responseAsString = (String)response.readEntity(String.class);
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new NoSuchEntityException(responseAsString);
        }
        if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.ACCEPTED.getStatusCode() && response.getStatus() != Response.Status.CREATED.getStatusCode()) {
            SCIMv11Utils.handleGeneralError("While executing request: " + responseAsString);
        }
    }

    private void checkServiceResultErrors(JsonNode node, Response response) {
        if (node.has(RESPONSE_ERRORS)) {
            SCIMv11Utils.handleGeneralError((String)response.readEntity(String.class));
        }
    }

    private JsonNode buildCustomAttributesNode(String customAttributesJSON, User user) {
        ObjectNode rootNode = null;
        if (StringUtil.isNotBlank((String)customAttributesJSON) && !user.getSCIMCustomAttributes().isEmpty()) {
            rootNode = SCIMv11Utils.MAPPER.createObjectNode();
            for (SCIMAttribute scimAttribute : user.getSCIMCustomAttributes().keySet()) {
                if (scimAttribute.getType().equals("complex")) {
                    for (SCIMAttribute scimSubAttribute : scimAttribute.getSubAttributes()) {
                        this.buildCustomSimpleAttributeNode((JsonNode)rootNode, scimSubAttribute, user);
                    }
                    continue;
                }
                this.buildCustomSimpleAttributeNode((JsonNode)rootNode, scimAttribute, user);
            }
        }
        return rootNode;
    }

    private void buildCustomSimpleAttributeNode(JsonNode rootNode, SCIMAttribute scimAttribute, User user) {
        ObjectNode newNode = SCIMv11Utils.MAPPER.createObjectNode();
        List<Object> values = user.getSCIMCustomAttributes().get(scimAttribute);
        Object value = null;
        if (!scimAttribute.getMultiValued().booleanValue()) {
            value = values.get(0);
        }
        String mainNodeKey = scimAttribute.getSchema();
        String currentNodeKey = scimAttribute.getName();
        if (scimAttribute.getType().equals("complex")) {
            LOG.warn("Too many 'complex' type custom attributes, while parsing custom attribute {0} with schema {1}", new Object[]{currentNodeKey, mainNodeKey});
        } else if (mainNodeKey.contains("extension")) {
            if (rootNode.has(mainNodeKey)) {
                ((ObjectNode)rootNode.get(mainNodeKey)).putPOJO(currentNodeKey, values.size() > 1 ? values : values.get(0));
            } else {
                newNode.putPOJO(currentNodeKey, value == null ? values : value);
                ((ObjectNode)rootNode).set(mainNodeKey, (JsonNode)newNode);
            }
        } else {
            ((ObjectNode)rootNode).putPOJO(currentNodeKey, value == null ? values : value);
        }
    }

    private JsonNode mergeNodes(JsonNode mainNode, JsonNode updateNode) {
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String updatedFieldName = (String)fieldNames.next();
            JsonNode valueToBeUpdated = mainNode.get(updatedFieldName);
            JsonNode updatedValue = updateNode.get(updatedFieldName);
            if (valueToBeUpdated != null && valueToBeUpdated.isArray() && updatedValue.isArray()) {
                for (int i = 0; i < updatedValue.size(); ++i) {
                    JsonNode updatedChildNode = updatedValue.get(i);
                    if (valueToBeUpdated.size() <= i) {
                        ((ArrayNode)valueToBeUpdated).add(updatedChildNode);
                    }
                    JsonNode childNodeToBeUpdated = valueToBeUpdated.get(i);
                    this.mergeNodes(childNodeToBeUpdated, updatedChildNode);
                }
                continue;
            }
            if (valueToBeUpdated != null && valueToBeUpdated.isObject()) {
                this.mergeNodes(valueToBeUpdated, updatedValue);
                continue;
            }
            if (!(mainNode instanceof ObjectNode)) continue;
            ((ObjectNode)mainNode).replace(updatedFieldName, updatedValue);
        }
        return mainNode;
    }

    public static SCIMSchema extractSCIMSchemas(String json) {
        SCIMSchema customAttributesObj = null;
        try {
            customAttributesObj = (SCIMSchema)SCIMv11Utils.MAPPER.readValue(json, SCIMSchema.class);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While parsing custom attributes JSON object, taken from connector configuration", new Object[0]);
        }
        return customAttributesObj;
    }

    protected void readCustomAttributes(User user, JsonNode node) {
        SCIMSchema scimSchema;
        if (StringUtil.isNotBlank((String)this.config.getCustomAttributesJSON()) && (scimSchema = SCIMv11Service.extractSCIMSchemas(this.config.getCustomAttributesJSON())) != null && !scimSchema.getAttributes().isEmpty()) {
            for (SCIMAttribute attribute : scimSchema.getAttributes()) {
                List foundWithSchemaAsKey = node.findValues(attribute.getSchema());
                if (foundWithSchemaAsKey.isEmpty()) continue;
                ArrayList<String> values = new ArrayList<String>();
                values.add(((JsonNode)foundWithSchemaAsKey.get(0)).get(attribute.getName()).textValue());
                user.getReturnedCustomAttributes().put(attribute.getSchema().concat(".").concat(attribute.getName()), values);
            }
        }
    }

    protected void readCustomAttributes(PagedResults<User> resources, JsonNode node) {
        for (User resource : resources.getResources()) {
            this.readCustomAttributes(resource, node);
        }
    }
}

