/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v2.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.dto.AbstractSCIMUser;
import net.tirasa.connid.bundles.scim.common.dto.SCIMGenericComplex;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2EnterpriseUser;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Entitlement;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Meta;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;

public class SCIMv2User
extends AbstractSCIMUser<SCIMv2Attribute, SCIMGenericComplex<String>, SCIMv2Entitlement, SCIMv2Meta, SCIMv2EnterpriseUser> {
    private static final long serialVersionUID = 7039988195599856857L;
    public static final String RESOURCE_NAME = "User";
    public static final String SCHEMA_URI = "urn:ietf:params:scim:schemas:core:2.0:User";
    @JsonProperty(value="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")
    protected SCIMv2EnterpriseUser enterpriseUser;

    public SCIMv2User() {
        super(SCHEMA_URI, new SCIMv2Meta(RESOURCE_NAME));
    }

    @Override
    protected void handleRoles(Object value) {
        this.handleSCIMComplexObject("default", this.roles, s -> s.setValue((String)String.class.cast(value)));
    }

    @Override
    protected void handlex509Certificates(Object value) {
        this.handleSCIMComplexObject("default", this.x509Certificates, s -> s.setValue((String)String.class.cast(value)));
    }

    @Override
    protected void handleDefaultEntitlement(Object value) {
        this.handleSCIMv2Entitlement(this.entitlements, s -> {
            s.setValue((String)String.class.cast(value));
            s.setType("default");
        });
    }

    @Override
    @JsonIgnore
    public void fillSCIMCustomAttributes(Set<Attribute> attributes, String customAttributesJSON) {
        SCIMUtils.extractSCIMSchemas(customAttributesJSON, SCIMv2Attribute.class).ifPresent(customAttributesObj -> {
            block0: for (Attribute attribute : attributes) {
                if (CollectionUtil.isEmpty((Collection)attribute.getValue())) continue;
                for (SCIMv2Attribute customAttribute : customAttributesObj.getAttributes()) {
                    String externalAttributeName = ((SCIMv2Attribute)SCIMv2Attribute.class.cast(customAttribute)).getExtensionSchema().concat(".").concat(customAttribute.getName());
                    if (!externalAttributeName.equals(attribute.getName())) continue;
                    this.scimCustomAttributes.put(customAttribute, attribute.getValue());
                    continue block0;
                }
            }
        });
    }

    @Override
    public SCIMv2EnterpriseUser getEnterpriseUser() {
        return this.enterpriseUser;
    }

    @Override
    public void setEnterpriseUser(SCIMv2EnterpriseUser enterpriseUser) {
        this.enterpriseUser = enterpriseUser;
    }

    @Override
    public void fillEnterpriseUser(Set<Attribute> attributes) {
        this.enterpriseUser = new SCIMv2EnterpriseUser();
        attributes.stream().filter(a -> a.getName().startsWith("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")).forEach(a -> {
            SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager manager = this.enterpriseUser.getManager();
            switch (a.getName().replace("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.", "")) {
                case "employeeNumber": {
                    this.enterpriseUser.setEmployeeNumber(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "costCenter": {
                    this.enterpriseUser.setCostCenter(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "organization": {
                    this.enterpriseUser.setOrganization(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "division": {
                    this.enterpriseUser.setDivision(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "department": {
                    this.enterpriseUser.setDepartment(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "manager.value": {
                    if (manager == null) {
                        manager = new SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager();
                        this.enterpriseUser.setManager(manager);
                    }
                    manager.setValue(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "manager.displayName": {
                    if (manager == null) {
                        manager = new SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager();
                        this.enterpriseUser.setManager(manager);
                    }
                    manager.setDisplayName(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
                case "manager.ref": {
                    if (manager == null) {
                        manager = new SCIMv2EnterpriseUser.SCIMv2EnterpriseUserManager();
                        this.enterpriseUser.setManager(manager);
                    }
                    manager.setRef(AttributeUtil.getAsStringValue((Attribute)a));
                    break;
                }
            }
        });
    }

    @JsonIgnore
    protected <T extends Serializable> void handleSCIMv2Entitlement(List<SCIMv2Entitlement> list, Consumer<SCIMv2Entitlement> setter) {
        SCIMv2Entitlement selected = null;
        for (SCIMv2Entitlement complex : list) {
            if (complex.getType() == null || !complex.getType().equals("default")) continue;
            selected = complex;
            break;
        }
        if (selected == null) {
            selected = new SCIMv2Entitlement();
            list.add(selected);
        }
        setter.accept(selected);
    }

    @Override
    protected void entitlementsToAttribute(List<SCIMv2Entitlement> entitlementRefs, Set<Attribute> attrs) {
        entitlementRefs.stream().filter(e -> "default".equals(e.getType())).findFirst().ifPresent(e -> attrs.add(AttributeBuilder.build((String)"entitlements.default.value", (Object[])new Object[]{e.getValue()})));
        attrs.add(AttributeBuilder.build((String)"entitlements", (Collection)entitlementRefs.stream().map(g -> g.getValue()).collect(Collectors.toList())));
    }
}

