/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.SCIMProvider;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Entitlement;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2EntitlementResource;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Group;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Patch;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchImpl;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchOperation;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2User;
import net.tirasa.connid.bundles.scim.v2.service.SCIMv2Client;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(displayNameKey="SCIMv2Connector.connector.display", configurationClass=SCIMConnectorConfiguration.class, messageCatalogPaths={"net.tirasa.connid.bundles.scim.common.Messages"})
public class SCIMv2Connector
extends AbstractSCIMConnector<SCIMv2User, SCIMv2Group, SCIMv2EntitlementResource, SCIMv2Patch, SCIMv2Client> {
    private Schema schema;

    @Override
    protected SCIMv2Client buildSCIMClient(SCIMConnectorConfiguration configuration) {
        return new SCIMv2Client(configuration);
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMAttributeUtils.buildSchema(this.configuration.getCustomAttributesJSON(), this.configuration.getManageComplexEntitlements(), SCIMv2Attribute.class);
        }
        return this.schema;
    }

    @Override
    public SCIMv2Client getClient() {
        return (SCIMv2Client)this.client;
    }

    @Override
    protected <T extends SCIMBaseAttribute<T>> SCIMv2User buildNewUserEntity(Optional<SCIMSchema<T>> customSchema) {
        SCIMv2User newUser = new SCIMv2User();
        customSchema.ifPresent(cs -> newUser.getSchemas().add(cs.getId()));
        return newUser;
    }

    @Override
    protected SCIMv2Group buildNewGroupEntity() {
        return new SCIMv2Group();
    }

    @Override
    protected SCIMv2Patch buildMembersGroupPatch(List<SCIMv2User> users, String op) {
        SCIMv2PatchImpl.Builder builder = new SCIMv2PatchImpl.Builder();
        switch (this.provider) {
            case SALESFORCE: 
            case WSO2: {
                builder.operations(CollectionUtil.newSet((Object[])new SCIMv2PatchOperation[]{new SCIMv2PatchOperation.Builder().op(op).path(SCIMProvider.SALESFORCE == this.provider ? "members" : null).value(CollectionUtil.newMap((Object)"members", users.stream().map(user -> this.buildPatchValue((SCIMv2User)user)).collect(Collectors.toList()))).build()}));
                break;
            }
            default: {
                builder.operations(CollectionUtil.newSet((Object[])new SCIMv2PatchOperation[]{new SCIMv2PatchOperation.Builder().op(op).path("members").value(users.stream().map(user -> this.buildPatchValue((SCIMv2User)user)).collect(Collectors.toList())).build()}));
            }
        }
        return builder.build();
    }

    @Override
    protected void fillGroupPatches(SCIMv2User user, Map<String, SCIMv2Patch> groupPatches, List<String> groupsToAdd, List<String> groupsToRemove) {
        groupsToAdd.forEach(grp -> {
            SCIMv2Patch cfr_ignored_0 = (SCIMv2Patch)groupPatches.put((String)grp, (SCIMv2Patch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "add"));
        });
        groupsToRemove.forEach(grp -> {
            SCIMv2Patch cfr_ignored_0 = (SCIMv2Patch)groupPatches.put((String)grp, (SCIMv2Patch)this.buildMembersGroupPatch((List)Collections.singletonList(user), "remove"));
        });
    }

    @Override
    protected SCIMv2Patch buildPatchFromGroup(SCIMv2Group group) {
        if (SCIMProvider.AWS == this.provider) {
            group.setMeta(null);
            group.getSchemas().clear();
            group.getMembers().clear();
        }
        return new SCIMv2PatchImpl.Builder().operations(Collections.singleton(new SCIMv2PatchOperation.Builder().op("replace").value(group).build())).build();
    }

    @Override
    protected void manageEntitlements(SCIMv2User user, List<String> values) {
        List<SCIMv2EntitlementResource> scimEntitlementRefs = values == null ? Collections.emptyList() : values.stream().map(((SCIMv2Client)this.client)::getEntitlement).filter(g -> g != null).collect(Collectors.toList());
        scimEntitlementRefs.forEach(e -> user.getEntitlements().add(new SCIMv2Entitlement.Builder().value(e.getId()).ref(this.configuration.getBaseAddress() + "Entitlements/" + e.getId()).display(e.getDisplayName()).primary(true).type(e.getType()).build()));
    }

    private BaseResourceReference buildPatchValue(SCIMv2User user) {
        BaseResourceReference.Builder builder = new BaseResourceReference.Builder();
        switch (this.provider) {
            case WSO2: {
                builder.value(user.getId()).display(user.getUserName());
                break;
            }
            case KEYCLOAK: {
                builder.value(user.getId()).ref(this.configuration.getBaseAddress() + "Users/" + user.getId()).display(user.getDisplayName());
                break;
            }
            default: {
                builder.value(user.getId());
            }
        }
        return builder.build();
    }
}

