/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.v2;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Entitlement;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2EntitlementResource;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Group;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Patch;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchImpl;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchOperation;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2PatchValue;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2User;
import net.tirasa.connid.bundles.scim.v2.service.SCIMv2Client;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.spi.ConnectorClass;

@ConnectorClass(displayNameKey="SCIMv2Connector.connector.display", configurationClass=SCIMConnectorConfiguration.class, messageCatalogPaths={"net.tirasa.connid.bundles.scim.common.Messages"})
public class SCIMv2Connector
extends AbstractSCIMConnector<SCIMv2User, SCIMv2Group, SCIMv2EntitlementResource, SCIMv2Patch, SCIMv2Client> {
    private Schema schema;

    @Override
    protected SCIMv2Client buildSCIMClient(SCIMConnectorConfiguration configuration) {
        return new SCIMv2Client(configuration);
    }

    public Schema schema() {
        LOG.ok("Building SCHEMA definition", new Object[0]);
        if (this.schema == null) {
            this.schema = SCIMAttributeUtils.buildSchema(this.configuration.getCustomAttributesJSON(), this.configuration.getManageComplexEntitlements(), SCIMv2Attribute.class);
        }
        return this.schema;
    }

    @Override
    public SCIMv2Client getClient() {
        return (SCIMv2Client)this.client;
    }

    @Override
    protected SCIMv2User buildNewUserEntity() {
        return new SCIMv2User();
    }

    @Override
    protected SCIMv2Group buildNewGroupEntity() {
        return new SCIMv2Group();
    }

    @Override
    protected void fillGroupPatches(SCIMv2User user, Map<String, SCIMv2Patch> groupPatches, List<String> groupsToAdd, List<String> groupsToRemove) {
        groupsToAdd.forEach(grp -> {
            SCIMv2Patch cfr_ignored_0 = groupPatches.put((String)grp, new SCIMv2PatchImpl.Builder().operations(CollectionUtil.newSet((Object[])new SCIMv2PatchOperation[]{this.configuration.getBaseAddress().contains("salesforce.com") ? new SCIMv2PatchOperation.Builder().op("add").path("members").value(CollectionUtil.newMap((Object)"members", (Object)CollectionUtil.newList((Object[])new SCIMv2PatchValue[]{new SCIMv2PatchValue.Builder().value(user.getId()).build()}))).build() : new SCIMv2PatchOperation.Builder().op("add").path("members").value(CollectionUtil.newList((Object[])new SCIMv2PatchValue[]{new SCIMv2PatchValue.Builder().value(user.getId()).build()})).build()})).build());
        });
        groupsToRemove.forEach(grp -> {
            SCIMv2Patch cfr_ignored_0 = groupPatches.put((String)grp, new SCIMv2PatchImpl.Builder().operations(CollectionUtil.newSet((Object[])new SCIMv2PatchOperation[]{this.configuration.getBaseAddress().contains("salesforce.com") ? new SCIMv2PatchOperation.Builder().op("remove").path("members").value(CollectionUtil.newMap((Object)"members", (Object)CollectionUtil.newList((Object[])new SCIMv2PatchValue[]{new SCIMv2PatchValue.Builder().value(user.getId()).build()}))).build() : new SCIMv2PatchOperation.Builder().op("remove").path("members").value(CollectionUtil.newList((Object[])new SCIMv2PatchValue[]{new SCIMv2PatchValue.Builder().value(user.getId()).build()})).build()})).build());
        });
    }

    @Override
    protected void manageEntitlements(SCIMv2User user, List<String> values) {
        List<SCIMv2EntitlementResource> scimEntitlementRefs = values == null ? Collections.emptyList() : values.stream().map(((SCIMv2Client)this.client)::getEntitlement).filter(g -> g != null).collect(Collectors.toList());
        scimEntitlementRefs.forEach(e -> user.getEntitlements().add(new SCIMv2Entitlement.Builder().value(e.getId()).ref(this.configuration.getBaseAddress() + "Entitlements/" + e.getId()).display(e.getDisplayName()).primary(true).type(e.getType()).build()));
    }
}

