/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.dto.SCIMSchema;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public final class SCIMUtils {
    private static final Log LOG = Log.getLog(SCIMUtils.class);
    public static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_EMPTY);

    public static List<Field> getAllFieldsList(Class<?> cls) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            Collections.addAll(allFields, declaredFields);
        }
        return allFields;
    }

    public static void handleGeneralError(String message) {
        LOG.error("General error : {0}", new Object[]{message});
        throw new ConnectorException(message);
    }

    public static void handleGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw new ConnectorException(message, (Throwable)ex);
    }

    public static void wrapGeneralError(String message, Exception ex) {
        LOG.error((Throwable)ex, message, new Object[0]);
        throw ConnectorException.wrap((Throwable)ex);
    }

    public static boolean isEmptyObject(Object obj) {
        return obj == null || obj instanceof List && new ArrayList((List)obj).isEmpty() || obj instanceof String && StringUtil.isBlank((String)((String)String.class.cast(obj)));
    }

    public static <T extends SCIMBaseAttribute<T>> String cleanAttributesToGet(Set<String> attributesToGet, String customAttributesJSON, Class<T> attrType) {
        return SCIMUtils.cleanAttributesToGet(attributesToGet, customAttributesJSON, attrType, true);
    }

    public static <T extends SCIMBaseAttribute<T>> String cleanAttributesToGet(Set<String> attributesToGet, String customAttributesJSON, Class<T> attrType, boolean addCustomAttrsToQueryParams) {
        if (attributesToGet.isEmpty()) {
            return SCIMAttributeUtils.defaultAttributesToGet();
        }
        SCIMSchema customAttributesObj = StringUtil.isBlank((String)customAttributesJSON) ? null : (SCIMSchema)SCIMUtils.extractSCIMSchemas(customAttributesJSON, attrType).orElse(null);
        String result = "";
        for (String attributeToGet : attributesToGet) {
            if (attributeToGet.contains("__") || attributeToGet.contains("meta.") || attributeToGet.toLowerCase().contains("password")) continue;
            if (attributeToGet.contains("name.")) {
                result = result + "name".concat(",");
                continue;
            }
            if (attributeToGet.contains("addresses.")) {
                result = result + "addresses".concat(",");
                continue;
            }
            if (attributeToGet.contains("phoneNumbers.")) {
                result = result + "phoneNumbers".concat(",");
                continue;
            }
            if (attributeToGet.contains("ims.")) {
                result = result + "ims".concat(",");
                continue;
            }
            if (attributeToGet.contains("emails.")) {
                result = result + "emails".concat(",");
                continue;
            }
            if (attributeToGet.contains("roles.")) {
                result = result + "roles".concat(",");
                continue;
            }
            if (attributeToGet.contains("groups.")) {
                result = result + "groups".concat(",");
                continue;
            }
            if (attributeToGet.contains("photos.")) {
                result = result + "photos".concat(",");
                continue;
            }
            if (attributeToGet.contains("x509Certificates.")) {
                result = result + "x509Certificates".concat(",");
                continue;
            }
            if (attributeToGet.contains("entitlements.")) {
                result = result + "entitlements".concat(",");
                continue;
            }
            if (attributeToGet.startsWith("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User")) {
                result = result + "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User" + attributeToGet.replace("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", "").replaceFirst(".", ":").concat(",");
                continue;
            }
            if (customAttributesObj == null) {
                result = result + attributeToGet.concat(",");
                continue;
            }
            if (SCIMUtils.isCustomAttribute(customAttributesObj, attributeToGet)) continue;
            result = result + attributeToGet.concat(",");
        }
        if (customAttributesObj != null && addCustomAttrsToQueryParams) {
            for (SCIMBaseAttribute attribute : customAttributesObj.getAttributes()) {
                String attributeName = attribute instanceof SCIMv2Attribute ? ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attribute)).getExtensionSchema() + ":" + attribute.getName() : attribute.getName();
                if (result.contains(attributeName)) continue;
                result = result + attributeName.concat(",");
            }
        }
        if (!result.contains("userName,")) {
            result = result + "userName".concat(",");
        }
        if (!result.contains("id,")) {
            result = result + "id".concat(",");
        }
        if (!result.contains("name,")) {
            result = result + "name".concat(",");
        }
        return StringUtil.isBlank((String)result) ? SCIMAttributeUtils.defaultAttributesToGet() : result.substring(0, result.length() - 1);
    }

    private static <T extends SCIMBaseAttribute<T>> boolean isCustomAttribute(SCIMSchema<T> customAttributes, String attribute) {
        for (SCIMBaseAttribute customAttribute : customAttributes.getAttributes()) {
            String externalAttributeName = customAttribute instanceof SCIMv11Attribute ? ((SCIMv11Attribute)SCIMv11Attribute.class.cast(customAttribute)).getSchema().concat(".").concat(customAttribute.getName()) : ((SCIMv2Attribute)SCIMv2Attribute.class.cast(customAttribute)).getExtensionSchema().concat(".").concat(customAttribute.getName());
            if (!externalAttributeName.equals(attribute)) continue;
            return true;
        }
        return false;
    }

    public static <T extends SCIMBaseAttribute<T>> Optional<SCIMSchema<T>> extractSCIMSchemas(String json, Class<T> attrType) {
        if (StringUtil.isBlank((String)json)) {
            return Optional.empty();
        }
        try {
            SCIMSchema scimSchema = (SCIMSchema)MAPPER.readValue(json, MAPPER.getTypeFactory().constructParametricType(SCIMSchema.class, new Class[]{attrType}));
            if (SCIMv2Attribute.class.equals(attrType)) {
                scimSchema.getAttributes().forEach(attr -> ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attr)).setExtensionSchema(scimSchema.getId()));
            }
            return scimSchema.getAttributes().isEmpty() ? Optional.empty() : Optional.of(scimSchema);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While parsing custom attributes JSON object, taken from connector configuration", new Object[0]);
            return Optional.empty();
        }
    }

    private SCIMUtils() {
    }
}

