/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.scim.common.AbstractSCIMConnector;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseAttribute;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import net.tirasa.connid.bundles.scim.v11.dto.SCIMv11Attribute;
import net.tirasa.connid.bundles.scim.v2.dto.Mutability;
import net.tirasa.connid.bundles.scim.v2.dto.SCIMv2Attribute;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;

public final class SCIMAttributeUtils {
    public static final String ATTRIBUTE_ID = "id";
    public static final String USER_ATTRIBUTE_USERNAME = "userName";
    public static final String USER_ATTRIBUTE_PASSWORD = "password";
    public static final String USER_ATTRIBUTE_ACTIVE = "active";
    public static final String ENTERPRISE_USER = "active";
    public static final String USER_ATTRIBUTE_EXTERNAL_ID = "externalId";
    public static final String SCIM_USER_NAME = "name";
    public static final String SCIM_USER_META = "meta";
    public static final String SCIM_USER_ADDRESSES = "addresses";
    public static final String SCIM_USER_PHONE_NUMBERS = "phoneNumbers";
    public static final String SCIM_USER_IMS = "ims";
    public static final String SCIM_USER_EMAILS = "emails";
    public static final String SCIM_USER_ROLES = "roles";
    public static final String SCIM_USER_ENTITLEMENTS = "entitlements";
    public static final String SCIM_USER_X509CERTIFICATES = "x509Certificates";
    public static final String SCIM_USER_GROUPS = "groups";
    public static final String SCIM_USER_GROUPS_TO_ADD = "groupsToAdd";
    public static final String SCIM_USER_GROUPS_TO_REMOVE = "groupsToRemove";
    public static final String SCIM11_REMOVE = "delete";
    public static final String SCIM2_REMOVE = "remove";
    public static final String SCIM2_ADD = "add";
    public static final String SCIM2_REPLACE = "replace";
    public static final String SCIM_USER_PHOTOS = "photos";
    public static final String SCIM_USER_SCHEMAS = "schemas";
    public static final String SCIM_SCHEMA_TYPE_COMPLEX = "complex";
    public static final String SCIM_SCHEMA_TYPE_DEFAULT = "default";
    public static final String SCIM_SCHEMA_TYPE_PROFILE = "Profile";
    public static final String SCIM_SCHEMA_EXTENSION = "extension";
    public static final String SCIM_ENTERPRISE_EMPLOYEE_NUMBER = "employeeNumber";
    public static final String SCIM_ENTERPRISE_EMPLOYEE_MANAGER_VALUE = "manager.value";
    public static final String SCIM_ENTERPRISE_EMPLOYEE_MANAGER_REF = "manager.ref";
    public static final String SCIM_ENTERPRISE_EMPLOYEE_MANAGER_DISPLAY_NAME = "manager.displayName";
    public static final String SCIM_GROUP_DISPLAY_NAME = "displayName";
    public static final String SCIM_GROUP_MEMBERS = "members";

    public static <T extends SCIMBaseAttribute<T>> Schema buildSchema(String customAttributes, Boolean manageComplexEntitlements, Class<T> attrType) {
        SchemaBuilder builder = new SchemaBuilder(AbstractSCIMConnector.class);
        ObjectClassInfoBuilder userBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.ACCOUNT_NAME);
        userBuilder.addAttributeInfo(Name.INFO);
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)ATTRIBUTE_ID).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)USER_ATTRIBUTE_EXTERNAL_ID).setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)USER_ATTRIBUTE_USERNAME).setRequired(true).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.familyName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.givenName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.middleName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.honorificPrefix").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"name.honorificSuffix").build());
        userBuilder.addAttributeInfo(OperationalAttributeInfos.ENABLE);
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"active").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(OperationalAttributeInfos.PASSWORD);
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)SCIM_GROUP_DISPLAY_NAME).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"nickName").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"profileUrl").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"title").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"userType").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"locale").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"preferredLanguage").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"timezone").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.work.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.work.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.work.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.home.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.home.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.home.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.other.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.other.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"emails.other.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.work.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.work.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.work.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.other.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.other.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.other.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.pager.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.pager.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.pager.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.fax.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.fax.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.fax.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.mobile.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.mobile.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"phoneNumbers.mobile.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.aim.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.aim.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.aim.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.xmpp.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.xmpp.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.xmpp.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.skype.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.skype.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.skype.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.qq.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.qq.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.qq.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.yahoo.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.yahoo.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.yahoo.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.msn.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.msn.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.msn.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.icq.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.icq.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.icq.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.gtalk.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.gtalk.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"ims.gtalk.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.photo.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.photo.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.photo.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.thumbnail.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.thumbnail.operation").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"photos.thumbnail.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.streetAddress").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.locality").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.region").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.postalCode").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.country").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.work.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.streetAddress").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.locality").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.region").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.postalCode").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.country").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.home.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.streetAddress").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.locality").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.region").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.postalCode").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.country").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.formatted").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"addresses.other.primary").setType(Boolean.class).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"groups.default.value").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"roles.default.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"entitlements.default.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"x509Certificates.default.value").build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)SCIM_USER_SCHEMAS).setMultiValued(true).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.created").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.lastModified").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.location").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.version").setUpdateable(false).build());
        userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"meta.attributes").setMultiValued(true).build());
        SCIMUtils.extractSCIMSchemas(customAttributes, attrType).ifPresent(scimSchema -> {
            for (SCIMBaseAttribute attribute : scimSchema.getAttributes()) {
                AttributeInfoBuilder attributeInfoBuilder = AttributeInfoBuilder.define((String)(attribute instanceof SCIMv11Attribute ? ((SCIMv11Attribute)SCIMv11Attribute.class.cast(attribute)).getSchema().concat(".").concat(attribute.getName()) : ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attribute)).getExtensionSchema().concat(".").concat(attribute.getName())));
                attributeInfoBuilder.setMultiValued(attribute.getMultiValued().booleanValue()).setRequired(attribute.getRequired().booleanValue()).setUpdateable(attribute instanceof SCIMv11Attribute ? !((SCIMv11Attribute)SCIMv11Attribute.class.cast(attribute)).getReadOnly().booleanValue() : Mutability.readWrite == ((SCIMv2Attribute)SCIMv2Attribute.class.cast(attribute)).getMutability());
                switch (attribute.getType()) {
                    case "boolean": {
                        attributeInfoBuilder.setType(Boolean.class);
                        break;
                    }
                    default: {
                        attributeInfoBuilder.setType(String.class);
                    }
                }
                userBuilder.addAttributeInfo(attributeInfoBuilder.build());
            }
        });
        if (SCIMv2Attribute.class.equals(attrType)) {
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.employeeNumber").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.costCenter").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.organization").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.division").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.department").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.manager.value").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.manager.ref").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User.manager.displayName").setMultiValued(false).build());
            if (manageComplexEntitlements.booleanValue()) {
                userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)SCIM_USER_ENTITLEMENTS).setMultiValued(false).build());
            }
        } else {
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:scim:schemas:extension:enterprise:1.0.employeeNumber").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:scim:schemas:extension:enterprise:1.0.manager.managerId").setMultiValued(false).build());
            userBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)"urn:scim:schemas:extension:enterprise:1.0.manager.displayName").setMultiValued(false).build());
        }
        ObjectClassInfo user = userBuilder.build();
        builder.defineObjectClass(user);
        ObjectClassInfoBuilder groupBuilder = new ObjectClassInfoBuilder().setType(ObjectClass.GROUP_NAME);
        groupBuilder.addAttributeInfo(AttributeInfoBuilder.define((String)SCIM_GROUP_DISPLAY_NAME).setMultiValued(false).build());
        builder.defineObjectClass(groupBuilder.build());
        return builder.build();
    }

    public static AttributeBuilder buildAttributeFromClassField(Field field, Object that) throws IllegalArgumentException, IllegalAccessException {
        return SCIMAttributeUtils.doBuildAttributeFromClassField(field.get(that), field.getName(), field.getType());
    }

    public static AttributeBuilder doBuildAttributeFromClassField(Object value, String name, Class<?> clazz) {
        AttributeBuilder attributeBuilder = new AttributeBuilder();
        if (value != null) {
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                attributeBuilder.addValue(new Object[]{Boolean.class.cast(value)});
            } else if (value instanceof List) {
                ArrayList list = new ArrayList((List)value);
                if (list.size() > 1) {
                    for (Object elem : list) {
                        attributeBuilder.addValue((Collection)SCIMAttributeUtils.doBuildAttributeFromClassField(elem, name, elem.getClass()).getValue());
                    }
                } else if (!list.isEmpty() && list.get(0) != null) {
                    attributeBuilder.addValue(new Object[]{list.get(0).toString()});
                }
            } else {
                attributeBuilder.addValue(new Object[]{value.toString()});
            }
        }
        if (name != null) {
            attributeBuilder.setName(name);
        }
        return attributeBuilder;
    }

    public static String defaultAttributesToGet() {
        return USER_ATTRIBUTE_USERNAME.concat(",").concat(ATTRIBUTE_ID).concat(",").concat(SCIM_USER_NAME);
    }

    public static void addAttribute(Set<Attribute> toAttrs, Set<Attribute> attrs, Class<?> type) {
        for (Attribute toAttribute : toAttrs) {
            attrs.add(SCIMAttributeUtils.doBuildAttributeFromClassField(toAttribute.getValue(), toAttribute.getName(), type).build());
        }
    }

    private SCIMAttributeUtils() {
    }
}

