/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap;

import com.sun.jndi.ldap.ctl.PasswordExpiredResponseControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import net.tirasa.connid.bundles.ldap.LdapConfiguration;
import net.tirasa.connid.bundles.ldap.commons.LdapNativeSchema;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.commons.ServerNativeSchema;
import net.tirasa.connid.bundles.ldap.commons.StaticNativeSchema;
import net.tirasa.connid.bundles.ldap.schema.LdapSchema;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorSecurityException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.PasswordExpiredException;

public class LdapConnection {
    private static final Set<String> LDAP_BINARY_SYNTAX_ATTRS = CollectionUtil.newCaseInsensitiveSet();
    private static final Set<String> LDAP_BINARY_OPTION_ATTRS;
    protected static final String LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final Log LOG;
    protected final LdapConfiguration config;
    protected LdapSchema schema;
    protected LdapContext initCtx;
    protected Set<String> supportedControls;
    protected ServerType serverType;

    public LdapConnection(LdapConfiguration config) {
        this.config = config;
        this.schema = new LdapSchema(this);
    }

    public String format(String key, String dflt, Object ... args) {
        return this.config.getConnectorMessages().format(key, dflt, args);
    }

    public LdapConfiguration getConfiguration() {
        return this.config;
    }

    public LdapContext getInitialContext() {
        if (this.initCtx != null) {
            return this.initCtx;
        }
        this.initCtx = this.connect(this.config.getPrincipal(), this.config.getCredentials());
        return this.initCtx;
    }

    protected LdapContext connect(String principal, GuardedString credentials) {
        Pair<AuthenticationResult, LdapContext> pair = this.createContext(principal, credentials);
        if (((AuthenticationResult)pair.first).getType().equals((Object)AuthenticationResultType.SUCCESS)) {
            return (LdapContext)pair.second;
        }
        ((AuthenticationResult)pair.first).propagate();
        throw new IllegalStateException("Should never get here");
    }

    protected Pair<AuthenticationResult, LdapContext> createContext(String principal, GuardedString credentials) {
        final ArrayList<Pair<AuthenticationResult, LdapContext>> result = new ArrayList<Pair<AuthenticationResult, LdapContext>>(1);
        final Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", LDAP_CTX_FACTORY);
        env.put("java.naming.provider.url", this.getLdapUrls());
        env.put("java.naming.referral", "follow");
        env.put("com.sun.jndi.ldap.connect.timeout", Long.toString(this.config.getConnectTimeout()));
        env.put("com.sun.jndi.ldap.read.timeout", Long.toString(this.config.getReadTimeout()));
        if (this.config.isSsl()) {
            env.put("java.naming.security.protocol", "ssl");
        }
        String authentication = StringUtil.isNotBlank((String)principal) ? "simple" : "none";
        env.put("java.naming.security.authentication", authentication);
        if (StringUtil.isNotBlank((String)principal)) {
            env.put("java.naming.security.principal", principal);
            if (credentials != null) {
                credentials.access(new GuardedString.Accessor(){

                    public void access(char[] clearChars) {
                        if (clearChars == null || clearChars.length == 0) {
                            throw new InvalidCredentialException("Password is blank");
                        }
                        env.put("java.naming.security.credentials", clearChars);
                        result.add(LdapConnection.this.createContext(env));
                    }
                });
                assert (!result.isEmpty());
            } else {
                result.add(this.createContext(env));
            }
        } else {
            result.add(this.createContext(env));
        }
        return (Pair)result.get(0);
    }

    protected Pair<AuthenticationResult, LdapContext> createContext(Hashtable<?, ?> env) {
        AuthenticationResult authnResult = null;
        InitialLdapContext context = null;
        try {
            context = new InitialLdapContext(env, null);
            if (this.config.isRespectResourcePasswordPolicyChangeAfterReset() && LdapConnection.hasPasswordExpiredControl(context.getResponseControls())) {
                authnResult = new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED);
            }
        }
        catch (AuthenticationException e) {
            String message = e.getMessage().toLowerCase();
            authnResult = message.contains("password expired") ? new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED, e) : (message.contains("password has expired") ? new AuthenticationResult(AuthenticationResultType.PASSWORD_EXPIRED, e) : new AuthenticationResult(AuthenticationResultType.FAILED, e));
        }
        catch (NamingException e) {
            authnResult = new AuthenticationResult(AuthenticationResultType.FAILED, e);
        }
        if (authnResult == null) {
            assert (context != null);
            authnResult = new AuthenticationResult(AuthenticationResultType.SUCCESS);
        }
        return new Pair((Object)authnResult, (Object)context);
    }

    protected static boolean hasPasswordExpiredControl(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PasswordExpiredResponseControl)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getLdapUrls() {
        StringBuilder builder = new StringBuilder();
        builder.append("ldap://");
        builder.append(this.config.getHost());
        builder.append(':');
        builder.append(this.config.getPort());
        for (String failover : LdapUtil.nullAsEmpty(this.config.getFailover())) {
            builder.append(' ');
            builder.append(failover);
        }
        return builder.toString();
    }

    public void close() {
        try {
            LdapConnection.quietClose(this.initCtx);
        }
        finally {
            this.initCtx = null;
        }
    }

    protected static void quietClose(LdapContext ctx) {
        try {
            if (ctx != null) {
                ctx.close();
            }
        }
        catch (NamingException e) {
            LOG.warn((Throwable)e, null, new Object[0]);
        }
    }

    public LdapSchema getSchema() {
        return this.schema;
    }

    public LdapNativeSchema createNativeSchema() {
        try {
            if (this.config.isReadSchema()) {
                return new ServerNativeSchema(this);
            }
            return new StaticNativeSchema();
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public AuthenticationResult authenticate(String entryDN, GuardedString password) {
        assert (entryDN != null);
        LOG.ok("Attempting to authenticate {0}", new Object[]{entryDN});
        Pair<AuthenticationResult, LdapContext> pair = this.createContext(entryDN, password);
        if (pair.second != null) {
            LdapConnection.quietClose((LdapContext)pair.second);
        }
        LOG.ok("Authentication result: {0}", new Object[]{pair.first});
        return (AuthenticationResult)pair.first;
    }

    public void test() {
        this.checkAlive();
    }

    public void checkAlive() {
        try {
            Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"subschemaSubentry"});
            attrs.get("subschemaSubentry");
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    public boolean supportsControl(String oid) {
        return this.getSupportedControls().contains(oid);
    }

    protected Set<String> getSupportedControls() {
        if (this.supportedControls == null) {
            try {
                Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"supportedControl"});
                this.supportedControls = Collections.unmodifiableSet(LdapUtil.getStringAttrValues(attrs, "supportedControl"));
            }
            catch (NamingException e) {
                LOG.warn((Throwable)e, "Exception while retrieving the supported controls", new Object[0]);
                this.supportedControls = Collections.emptySet();
            }
        }
        return this.supportedControls;
    }

    public ServerType getServerType() {
        if (this.serverType == null) {
            this.serverType = this.detectServerType();
        }
        return this.serverType;
    }

    protected ServerType detectServerType() {
        try {
            Attributes attrs = this.getInitialContext().getAttributes("", new String[]{"vendorVersion"});
            String vendorVersion = LdapUtil.getStringAttrValue(attrs, "vendorVersion");
            if (vendorVersion != null) {
                if ((vendorVersion = vendorVersion.toLowerCase()).contains("opendj")) {
                    return ServerType.OPENDJ;
                }
                if (vendorVersion.contains("sun") && vendorVersion.contains("directory")) {
                    return ServerType.SUN_DSEE;
                }
            }
        }
        catch (NamingException e) {
            LOG.warn((Throwable)e, "Exception while detecting the server type", new Object[0]);
        }
        return ServerType.UNKNOWN;
    }

    public boolean needsBinaryOption(String attrName) {
        return LDAP_BINARY_OPTION_ATTRS.contains(attrName);
    }

    public boolean isBinarySyntax(String attrName) {
        return LDAP_BINARY_SYNTAX_ATTRS.contains(attrName);
    }

    static {
        LDAP_BINARY_SYNTAX_ATTRS.add("audio");
        LDAP_BINARY_SYNTAX_ATTRS.add("jpegPhoto");
        LDAP_BINARY_SYNTAX_ATTRS.add("photo");
        LDAP_BINARY_SYNTAX_ATTRS.add("personalSignature");
        LDAP_BINARY_SYNTAX_ATTRS.add("userPassword");
        LDAP_BINARY_SYNTAX_ATTRS.add("userCertificate");
        LDAP_BINARY_SYNTAX_ATTRS.add("caCertificate");
        LDAP_BINARY_SYNTAX_ATTRS.add("authorityRevocationList");
        LDAP_BINARY_SYNTAX_ATTRS.add("deltaRevocationList");
        LDAP_BINARY_SYNTAX_ATTRS.add("certificateRevocationList");
        LDAP_BINARY_SYNTAX_ATTRS.add("crossCertificatePair");
        LDAP_BINARY_SYNTAX_ATTRS.add("x500UniqueIdentifier");
        LDAP_BINARY_SYNTAX_ATTRS.add("supportedAlgorithms");
        LDAP_BINARY_SYNTAX_ATTRS.add("javaSerializedData");
        LDAP_BINARY_SYNTAX_ATTRS.add("thumbnailPhoto");
        LDAP_BINARY_SYNTAX_ATTRS.add("thumbnailLogo");
        LDAP_BINARY_OPTION_ATTRS = CollectionUtil.newCaseInsensitiveSet();
        LDAP_BINARY_OPTION_ATTRS.add("userCertificate");
        LDAP_BINARY_OPTION_ATTRS.add("caCertificate");
        LDAP_BINARY_OPTION_ATTRS.add("authorityRevocationList");
        LDAP_BINARY_OPTION_ATTRS.add("deltaRevocationList");
        LDAP_BINARY_OPTION_ATTRS.add("certificateRevocationList");
        LDAP_BINARY_OPTION_ATTRS.add("crossCertificatePair");
        LDAP_BINARY_OPTION_ATTRS.add("supportedAlgorithms");
        LOG = Log.getLog(LdapConnection.class);
    }

    public static enum ServerType {
        SUN_DSEE,
        OPENDJ,
        UNKNOWN;

    }

    public static class AuthenticationResult {
        protected final AuthenticationResultType type;
        protected final Exception cause;

        public AuthenticationResult(AuthenticationResultType type) {
            this(type, null);
        }

        public AuthenticationResult(AuthenticationResultType type, Exception cause) {
            assert (type != null);
            this.type = type;
            this.cause = cause;
        }

        public void propagate() {
            this.type.propagate(this.cause);
        }

        public AuthenticationResultType getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("AuthenticationResult[type: ").append((Object)this.type);
            if (this.cause != null) {
                result.append("; cause: ").append(this.cause.getMessage());
            }
            result.append(']');
            return result.toString();
        }
    }

    public static enum AuthenticationResultType {
        SUCCESS{

            @Override
            public void propagate(Exception cause) {
            }
        }
        ,
        PASSWORD_EXPIRED{

            @Override
            public void propagate(Exception cause) {
                throw new PasswordExpiredException((Throwable)cause);
            }
        }
        ,
        FAILED{

            @Override
            public void propagate(Exception cause) {
                throw new ConnectorSecurityException((Throwable)cause);
            }
        };


        public abstract void propagate(Exception var1);
    }
}

