/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.kafka.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.io.IOException;
import java.util.Base64;
import java.util.List;
import org.identityconnectors.common.security.GuardedString;

public abstract class AbstractValueSerializer<T>
extends JsonSerializer<T> {
    public static final String BYTE_ARRAY_PREFIX = "<binary>";
    public static final String BYTE_ARRAY_SUFFIX = "</binary>";

    protected void doSerialize(List<Object> value, JsonGenerator jgen) throws IOException {
        if (value == null) {
            jgen.writeNull();
        } else {
            jgen.writeStartArray();
            for (Object v : value) {
                if (v == null) {
                    jgen.writeNull();
                    continue;
                }
                if (v instanceof GuardedString) {
                    jgen.writeObject(v);
                    continue;
                }
                if (v instanceof Integer) {
                    jgen.writeNumber(((Integer)v).intValue());
                    continue;
                }
                if (v instanceof Long) {
                    jgen.writeNumber(((Long)v).longValue());
                    continue;
                }
                if (v instanceof Double) {
                    jgen.writeNumber(((Double)v).doubleValue());
                    continue;
                }
                if (v instanceof Boolean) {
                    jgen.writeBoolean(((Boolean)v).booleanValue());
                    continue;
                }
                if (v instanceof byte[]) {
                    jgen.writeString(BYTE_ARRAY_PREFIX + Base64.getEncoder().encodeToString((byte[])v) + BYTE_ARRAY_SUFFIX);
                    continue;
                }
                jgen.writeString(v.toString());
            }
            jgen.writeEndArray();
        }
    }
}

