/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.azure.service;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.authentication.TokenCredentialAuthProvider;
import com.microsoft.graph.requests.GraphServiceClient;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.tirasa.connid.bundles.azure.AzureConnectorConfiguration;
import net.tirasa.connid.bundles.azure.utils.AzureUtils;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AzureService {
    private static final Log LOG = Log.getLog(AzureService.class);
    public static final String METADATA_NAME_ID = "Name";
    public static final String METADATA_TYPE_ID = "Type";
    public static final String METADATA_NULLABLE_ID = "Nullable";
    public static final String METADATA_COLLECTION_VALUE = "Collection";
    public static final String USER_METADATA_TYPE_ID_VALUE = "User";
    public static final String GROUP_METADATA_TYPE_ID_VALUE = "Group";
    protected final AzureConnectorConfiguration config;
    private IAuthenticationResult authenticationResult;

    public AzureService(AzureConnectorConfiguration config) {
        this.config = config;
    }

    private void doAuth() {
        LOG.ok("Performing Azure account authentication", new Object[0]);
        try {
            PublicClientApplication pca = ((PublicClientApplication.Builder)PublicClientApplication.builder((String)this.config.getClientId()).authority(this.config.getAuthority())).build();
            UserNamePasswordParameters parameters = UserNamePasswordParameters.builder(Collections.singleton(this.config.getScopes()), (String)this.config.getUsername(), (char[])this.config.getPassword().toCharArray()).build();
            this.authenticationResult = (IAuthenticationResult)pca.acquireToken(parameters).join();
            LOG.ok("==username/password flow succeeded", new Object[0]);
        }
        catch (MalformedURLException ex) {
            AzureUtils.handleGeneralError("While performing Azure authentication", ex);
        }
    }

    protected void checkAuth() {
        if (!this.isAuthenticated()) {
            this.doAuth();
        }
        this.checkTokenExpiry();
    }

    private boolean isAuthenticated() {
        return this.authenticationResult != null && StringUtil.isNotBlank((String)this.authenticationResult.accessToken());
    }

    private void checkTokenExpiry() {
        Date currentDate = new Date();
        Date expireOnDate = this.authenticationResult.expiresOnDate();
        if (currentDate.after(expireOnDate)) {
            LOG.ok("Token expired! Refreshing...", new Object[0]);
            this.doAuth();
        }
    }

    public GraphServiceClient getGraphServiceClient() {
        this.checkAuth();
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.config.getClientId())).clientSecret(this.config.getClientSecret()).tenantId(this.config.getTenantId())).build();
        TokenCredentialAuthProvider tokenCredAuthProvider = new TokenCredentialAuthProvider(Collections.singletonList(this.config.getScopes()), (TokenCredential)clientSecretCredential);
        return GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)tokenCredAuthProvider).buildClient();
    }

    public static List<Map<String, String>> getMetadata(String type) {
        return AzureService.getXMLObjectFromAzureAD(type);
    }

    private static List<Map<String, String>> getXMLObjectFromAzureAD(String type) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try {
            OkHttpClient client = new OkHttpClient();
            Request request = new Request.Builder().url("https://graph.windows.net/$metadata").addHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").addHeader("Accept-Encoding", "gzip, deflate, br").build();
            Response response = client.newCall(request).execute();
            InputStream xml = response.body().byteStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xml);
            doc.getDocumentElement().normalize();
            result.addAll(AzureService.getAttributesFromNodeList(doc, type));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            AzureUtils.handleGeneralError("While getting xml metadata object", ex);
        }
        return result;
    }

    private static List<Map<String, String>> getAttributesFromNodeList(Document doc, String objType) {
        Node nNode;
        int i;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        NodeList entityTypeList = doc.getElementsByTagName("EntityType");
        NodeList complexTypeList = doc.getElementsByTagName("ComplexType");
        for (i = 0; i < entityTypeList.getLength(); ++i) {
            nNode = entityTypeList.item(i);
            NodeList entitiesList = nNode.getChildNodes();
            Element eElement = (Element)((Object)entitiesList);
            String nodeName = eElement.getAttribute(METADATA_NAME_ID);
            if (!StringUtil.isNotBlank((String)nodeName) || !nodeName.equals(objType)) continue;
            for (int j = 0; j < entitiesList.getLength(); ++j) {
                Node subNode = entitiesList.item(j);
                if (!subNode.getNodeName().equals("Property")) continue;
                eElement = (Element)subNode;
                nodeName = eElement.getAttribute(METADATA_NAME_ID);
                String nodeType = eElement.getAttribute(METADATA_TYPE_ID);
                String nodeNullable = eElement.getAttribute(METADATA_NULLABLE_ID);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(METADATA_NAME_ID, nodeName);
                if (StringUtil.isNotBlank((String)nodeType)) {
                    map.put(METADATA_TYPE_ID, nodeType.replace("Edm.", ""));
                }
                if (StringUtil.isNotBlank((String)nodeNullable)) {
                    map.put(METADATA_NULLABLE_ID, nodeNullable);
                }
                list.add(map);
            }
        }
        for (i = 0; i < complexTypeList.getLength(); ++i) {
            nNode = complexTypeList.item(i);
            Element eElement = (Element)nNode;
            String nodeName = eElement.getAttribute(METADATA_NAME_ID);
            if (!StringUtil.isNotBlank((String)nodeName) || !nodeName.equals(objType)) continue;
            String nodeType = eElement.getAttribute(METADATA_TYPE_ID);
            String nodeNullable = eElement.getAttribute(METADATA_NULLABLE_ID);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(METADATA_NAME_ID, nodeName);
            if (StringUtil.isNotBlank((String)nodeType)) {
                map.put(METADATA_TYPE_ID, nodeType.replace("Edm.", ""));
            }
            if (StringUtil.isNotBlank((String)nodeNullable)) {
                map.put(METADATA_NULLABLE_ID, nodeNullable);
            }
            list.add(map);
        }
        return list;
    }
}

