/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ad.crud;

import java.util.TreeSet;
import javax.naming.NamingException;
import net.tirasa.connid.bundles.ad.ADConnection;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapModifyOperation;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public class ADDelete
extends LdapModifyOperation {
    private final ObjectClass oclass;
    private final Uid uid;
    private final ADConnection conn;

    public ADDelete(ADConnection conn, ObjectClass oclass, Uid uid) {
        super((LdapConnection)conn);
        this.oclass = oclass;
        this.uid = uid;
        this.conn = conn;
    }

    public void delete() {
        String entryDN = "objectGUID".equals(this.conn.getSchemaMapping().getLdapUidAttribute(this.oclass)) ? String.format("<GUID=%s>", this.uid.getUidValue()) : LdapSearches.getEntryDN((LdapConnection)this.conn, (ObjectClass)this.oclass, (Uid)this.uid);
        TreeSet ldapGroups = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        ldapGroups.addAll(this.groupHelper.getLdapGroups(entryDN));
        this.groupHelper.removeLdapGroupMemberships(entryDN, ldapGroups);
        try {
            this.conn.getInitialContext().destroySubcontext(entryDN);
        }
        catch (NamingException e) {
            throw new ConnectorException((Throwable)e);
        }
    }
}

