/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.db.scriptedsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConfiguration;
import net.tirasa.connid.commons.db.JNDIUtil;
import net.tirasa.connid.commons.db.SQLUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectionBrokenException;
import org.identityconnectors.framework.common.objects.ConnectorMessages;

public class ScriptedSQLConnection {
    private static final Log LOG = Log.getLog(ScriptedSQLConnection.class);
    private ScriptedSQLConfiguration _configuration;
    private Connection sqlConn = null;

    public ScriptedSQLConnection(ScriptedSQLConfiguration configuration) {
        this._configuration = configuration;
    }

    private static Connection connect(ScriptedSQLConfiguration config) {
        Connection connection;
        String login = config.getUser();
        GuardedString password = config.getPassword();
        String datasource = config.getDatasource();
        if (StringUtil.isNotBlank((String)datasource)) {
            LOG.info("Get a new connection using datasource {0}", new Object[]{datasource});
            String[] jndiProperties = config.getJndiProperties();
            ConnectorMessages connectorMessages = config.getConnectorMessages();
            Properties prop = JNDIUtil.arrayToProperties((String[])jndiProperties, (ConnectorMessages)connectorMessages);
            connection = StringUtil.isNotBlank((String)login) && password != null ? SQLUtil.getDatasourceConnection((String)datasource, (String)login, (GuardedString)password, (Properties)prop) : SQLUtil.getDatasourceConnection((String)datasource, (Properties)prop);
            LOG.ok("The new connection using datasource {0} is created", new Object[]{datasource});
        } else {
            String driver = config.getJdbcDriver();
            String connectionUrl = config.formatUrlTemplate();
            LOG.info("Getting a new connection using connection url {0} and user {1}", new Object[]{connectionUrl, login});
            connection = SQLUtil.getDriverMangerConnection((String)driver, (String)connectionUrl, (String)login, (GuardedString)password);
            LOG.ok("The new connection using connection url {0} and user {1} is created", new Object[]{connectionUrl, login});
        }
        try {
            if (config.isAutoCommit()) {
                LOG.info("Setting AutoCommit to true", new Object[0]);
                connection.setAutoCommit(true);
            } else {
                LOG.info("Setting AutoCommit to false", new Object[0]);
                connection.setAutoCommit(false);
            }
        }
        catch (SQLException expected) {
            LOG.error((Throwable)expected, "setAutoCommit() exception", new Object[0]);
        }
        return connection;
    }

    public void dispose() {
        SQLUtil.closeQuietly((Connection)this.sqlConn);
    }

    public void test() {
        try {
            if (null == this.getSqlConnection() || this.sqlConn.isClosed() || !this.sqlConn.isValid(2)) {
                throw new ConnectionBrokenException("JDBC connection is broken");
            }
        }
        catch (SQLException e) {
            throw ConnectionBrokenException.wrap((Throwable)e);
        }
    }

    public Connection getSqlConnection() {
        if (this.sqlConn == null) {
            this.sqlConn = ScriptedSQLConnection.connect(this._configuration);
        }
        return this.sqlConn;
    }

    public void setSqlConnection(Connection connection) {
        this.sqlConn = connection;
    }
}

