/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.PropertyBundle;

public final class GenericTextProviderSPI
implements TextProvider {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final Set<String> TYPES;
    private static final Set<String> LANGUAGES;
    private static final Set<Locale> LOCALES;

    @Override
    public boolean supportsCalendarType(String string) {
        return TYPES.contains(string);
    }

    @Override
    public boolean supportsLanguage(Locale locale) {
        return true;
    }

    @Override
    public String[] getSupportedCalendarTypes() {
        return TYPES.toArray(new String[TYPES.size()]);
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[LOCALES.size()]);
    }

    @Override
    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (string.equals("roc") || string.equals("buddhist")) {
            List<String> list = CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext).getTextForms();
            return list.toArray(new String[list.size()]);
        }
        if (string.equals("japanese")) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }
        if (string.equals("dangi") || string.equals("vietnam")) {
            string = "chinese";
        } else if (string.equals("hindu")) {
            string = "indian";
        } else if (string.equals("juche")) {
            return CalendarText.getIsoInstance(locale).getStdMonths(textWidth, outputContext).getTextForms().toArray(new String[12]);
        }
        PropertyBundle propertyBundle = GenericTextProviderSPI.getBundle(string, locale);
        if (textWidth == TextWidth.SHORT) {
            textWidth = TextWidth.ABBREVIATED;
        }
        String string2 = GenericTextProviderSPI.getKey(propertyBundle, "MONTH_OF_YEAR");
        String[] stringArray = GenericTextProviderSPI.lookupBundle(propertyBundle, string, locale.getLanguage(), GenericTextProviderSPI.countOfMonths(string), string2, textWidth, outputContext, bl, 1);
        if (stringArray == null) {
            if (outputContext == OutputContext.STANDALONE) {
                if (textWidth != TextWidth.NARROW) {
                    stringArray = this.months(string, locale, textWidth, OutputContext.FORMAT, bl);
                }
            } else if (textWidth == TextWidth.ABBREVIATED) {
                stringArray = this.months(string, locale, TextWidth.WIDE, OutputContext.FORMAT, bl);
            } else if (textWidth == TextWidth.NARROW) {
                stringArray = this.months(string, locale, textWidth, OutputContext.STANDALONE, bl);
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find calendar month.", GenericTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    @Override
    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return EMPTY_STRINGS;
    }

    @Override
    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return EMPTY_STRINGS;
    }

    @Override
    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        String[] stringArray;
        if (string.equals("chinese") || string.equals("vietnam")) {
            return EMPTY_STRINGS;
        }
        if (string.equals("japanese")) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"M", "T", "S", "H"};
            }
            return new String[]{"Meiji", "Taish\u014d", "Sh\u014dwa", "Heisei"};
        }
        if (string.equals("dangi") || string.equals("juche")) {
            String[] stringArray2 = this.eras("korean", locale, textWidth);
            String[] stringArray3 = new String[]{string.equals("dangi") ? stringArray2[0] : stringArray2[1]};
            return stringArray3;
        }
        PropertyBundle propertyBundle = GenericTextProviderSPI.getBundle(string, locale);
        if (textWidth == TextWidth.SHORT) {
            textWidth = TextWidth.ABBREVIATED;
        }
        if ((stringArray = GenericTextProviderSPI.lookupBundle(propertyBundle, string, locale.getLanguage(), GenericTextProviderSPI.countOfEras(string), GenericTextProviderSPI.getKey(propertyBundle, "ERA"), textWidth, OutputContext.FORMAT, false, 0)) == null && textWidth != TextWidth.ABBREVIATED) {
            stringArray = this.eras(string, locale, TextWidth.ABBREVIATED);
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find calendar resource for era.", GenericTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    @Override
    public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return EMPTY_STRINGS;
    }

    public String toString() {
        return "GenericTextProviderSPI";
    }

    static PropertyBundle getBundle(String string, Locale locale) {
        return PropertyBundle.load("calendar/names/" + string + "/" + string, LANGUAGES.contains(LanguageMatch.getAlias(locale)) ? locale : Locale.ROOT);
    }

    private static String[] lookupBundle(PropertyBundle propertyBundle, String string, String string2, int n, String string3, TextWidth textWidth, OutputContext outputContext, boolean bl, int n2) {
        String[] stringArray = new String[n];
        boolean bl2 = string3.length() == 1;
        for (int i = 0; i < n; ++i) {
            String string4;
            String string5;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3);
            stringBuilder.append('(');
            if (bl2) {
                char c = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
                if (bl) {
                    stringBuilder.append('|');
                    stringBuilder.append("LEAP");
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i + n2);
            if (bl && i == 6 && string.equals("hebrew")) {
                stringBuilder.append('L');
            }
            if (propertyBundle.containsKey(string5 = stringBuilder.toString())) {
                string4 = propertyBundle.getString(string5);
                if (bl && string.equals("chinese")) {
                    string4 = GenericTextProviderSPI.toLeapForm(string4, string2, textWidth, outputContext);
                }
            } else {
                return null;
            }
            stringArray[i] = string4;
        }
        return stringArray;
    }

    private static String toLeapForm(String string, String string2, TextWidth textWidth, OutputContext outputContext) {
        string = string2.equals("en") ? (textWidth == TextWidth.NARROW ? "i" + string : "(leap) " + string) : (string2.equals("de") || string2.equals("es") || string2.equals("fr") || string2.equals("it") || string2.equals("pt") || string2.equals("ro") ? (textWidth == TextWidth.NARROW ? "i" + string : "(i) " + string) : (string2.equals("ja") ? "\u958f" + string : (string2.equals("ko") ? "\uc724" + string : (string2.equals("zh") ? "\u958f" + string : (string2.equals("vi") ? (textWidth == TextWidth.NARROW ? string + "n" : string + (outputContext == OutputContext.STANDALONE ? " Nhu\u1eadn" : " nhu\u1eadn")) : "*" + string)))));
        return string;
    }

    private static String getKey(PropertyBundle propertyBundle, String string) {
        if (propertyBundle.containsKey("useShortKeys") && "true".equals(propertyBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static ClassLoader getDefaultLoader() {
        return GenericTextProviderSPI.class.getClassLoader();
    }

    private static int countOfMonths(String string) {
        return string.equals("coptic") || string.equals("ethiopic") || string.equals("generic") || string.equals("hebrew") ? 13 : 12;
    }

    private static int countOfEras(String string) {
        if (string.equals("hindu")) {
            return 6;
        }
        return string.equals("ethiopic") || string.equals("generic") || string.equals("roc") || string.equals("buddhist") || string.equals("korean") ? 2 : 1;
    }

    static {
        PropertyBundle propertyBundle = PropertyBundle.load("calendar/names/generic/generic", Locale.ROOT);
        String[] stringArray = propertyBundle.getString("languages").split(" ");
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, stringArray);
        hashSet.add("");
        LANGUAGES = Collections.unmodifiableSet(hashSet);
        HashSet<Locale> hashSet2 = new HashSet<Locale>();
        for (String string : LANGUAGES) {
            if (string.isEmpty()) {
                hashSet2.add(Locale.ROOT);
                continue;
            }
            hashSet2.add(new Locale(string));
        }
        LOCALES = Collections.unmodifiableSet(hashSet2);
        HashSet hashSet3 = new HashSet();
        hashSet3.add("buddhist");
        hashSet3.add("chinese");
        hashSet3.add("coptic");
        hashSet3.add("dangi");
        hashSet3.add("ethiopic");
        hashSet3.add("frenchrev");
        hashSet3.add("hindu");
        hashSet3.add("generic");
        hashSet3.add("hebrew");
        hashSet3.add("indian");
        hashSet3.add("islamic");
        hashSet3.add("japanese");
        hashSet3.add("juche");
        hashSet3.add("persian");
        hashSet3.add("roc");
        hashSet3.add("vietnam");
        TYPES = Collections.unmodifiableSet(hashSet3);
    }
}

