/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.NumberSystem;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.PropertyBundle;

public final class SymbolProviderSPI
implements NumberSymbolProvider {
    private static final Locale[] EMPTY_ARRAY = new Locale[0];
    public static final Set<String> SUPPORTED_LOCALES;
    public static final SymbolProviderSPI INSTANCE;
    private static final Map<String, NumberSystem> CLDR_NAMES;

    @Override
    public Locale[] getAvailableLocales() {
        return EMPTY_ARRAY;
    }

    @Override
    public char getZeroDigit(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "zero", NumberSymbolProvider.DEFAULT.getZeroDigit(locale));
    }

    @Override
    public char getDecimalSeparator(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "separator", NumberSymbolProvider.DEFAULT.getDecimalSeparator(locale));
    }

    @Override
    public String getPlusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "plus", NumberSymbolProvider.DEFAULT.getPlusSign(locale));
    }

    @Override
    public String getMinusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "minus", NumberSymbolProvider.DEFAULT.getMinusSign(locale));
    }

    @Override
    public NumberSystem getDefaultNumberSystem(Locale locale) {
        String string = SymbolProviderSPI.lookup(locale, "numsys", NumberSystem.ARABIC.getCode());
        NumberSystem numberSystem = CLDR_NAMES.get(string);
        if (numberSystem == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unrecognized number system: ");
            stringBuilder.append(string);
            stringBuilder.append(" (locale=");
            stringBuilder.append(locale);
            stringBuilder.append(')');
            throw new IllegalStateException(stringBuilder.toString());
        }
        return numberSystem;
    }

    public String toString() {
        return "SymbolProviderSPI";
    }

    private static char lookup(Locale locale, String string, char c) {
        PropertyBundle propertyBundle = SymbolProviderSPI.getBundle(locale);
        if (propertyBundle != null && propertyBundle.containsKey(string)) {
            return propertyBundle.getString(string).charAt(0);
        }
        return c;
    }

    private static String lookup(Locale locale, String string, String string2) {
        PropertyBundle propertyBundle = SymbolProviderSPI.getBundle(locale);
        if (propertyBundle != null && propertyBundle.containsKey(string)) {
            return propertyBundle.getString(string);
        }
        return string2;
    }

    private static PropertyBundle getBundle(Locale locale) {
        if (SUPPORTED_LOCALES.contains(LanguageMatch.getAlias(locale))) {
            return PropertyBundle.load("i18n/numbers/symbol", locale);
        }
        return null;
    }

    static {
        PropertyBundle propertyBundle = PropertyBundle.load("i18n/numbers/symbol", Locale.ROOT);
        String[] stringArray = propertyBundle.getString("locales").split(" ");
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        SUPPORTED_LOCALES = Collections.unmodifiableSet(hashSet);
        INSTANCE = new SymbolProviderSPI();
        HashMap<String, NumberSystem> hashMap = new HashMap<String, NumberSystem>();
        for (NumberSystem numberSystem : NumberSystem.values()) {
            hashMap.put(numberSystem.getCode(), numberSystem);
        }
        CLDR_NAMES = Collections.unmodifiableMap(hashMap);
    }
}

