/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Locale;
import net.time4j.base.MathUtils;
import net.time4j.format.Leniency;

public enum NumberSystem {
    ARABIC("latn"){

        @Override
        public String toNumeral(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Cannot convert: " + n);
            }
            return Integer.toString(n);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n = Integer.parseInt(string);
            if (n < 0) {
                throw new NumberFormatException("Cannot convert negative number: " + string);
            }
            return n;
        }

        @Override
        public boolean contains(char c) {
            return c >= '0' && c <= '9';
        }

        @Override
        public String getDigits() {
            return "0123456789";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ARABIC_INDIC("arab"){

        @Override
        public String getDigits() {
            return "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ARABIC_INDIC_EXT("arabext"){

        @Override
        public String getDigits() {
            return "\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    BENGALI("beng"){

        @Override
        public String getDigits() {
            return "\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    DEVANAGARI("deva"){

        @Override
        public String getDigits() {
            return "\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    DOZENAL("dozenal"){

        @Override
        public String toNumeral(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Cannot convert: " + n);
            }
            return Integer.toString(n, 12).replace('a', '\u218a').replace('b', '\u218b');
        }

        @Override
        public int toNumeral(int n, Appendable appendable) throws IOException {
            if (n >= 0) {
                int n2;
                int n3 = 0;
                for (n2 = 1; n2 <= 4; ++n2) {
                    if (n >= D_FACTORS[n2]) continue;
                    n3 = n2;
                    break;
                }
                if (n3 > 0) {
                    n2 = n3 - 1;
                    do {
                        int n4;
                        appendable.append((char)((n4 = n / D_FACTORS[n2]) == 11 ? 8587 : (char)(n4 == 10 ? 8586 : (char)(n4 + 48))));
                        n -= n4 * D_FACTORS[n2];
                    } while (--n2 >= 0);
                    return n3;
                }
            }
            return super.toNumeral(n, appendable);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n = Integer.parseInt(string.replace('\u218a', 'a').replace('\u218b', 'b'), 12);
            if (n < 0) {
                throw new NumberFormatException("Cannot convert negative number: " + string);
            }
            return n;
        }

        @Override
        public boolean contains(char c) {
            return c >= '0' && c <= '9' || c == '\u218a' || c == '\u218b';
        }

        @Override
        public String getDigits() {
            return "0123456789\u218a\u218b";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    ETHIOPIC("ethiopic"){

        @Override
        public String toNumeral(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Can only convert positive numbers: " + n);
            }
            String string = String.valueOf(n);
            int n2 = string.length() - 1;
            if (n2 % 2 == 0) {
                string = "0" + string;
                ++n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n2; i >= 0; --i) {
                char c;
                char c2 = '\u0000';
                char c3 = '\u0000';
                char c4 = string.charAt(n2 - i);
                if ((c = string.charAt(n2 - --i)) != '0') {
                    c3 = (char)(c + 4920);
                }
                if (c4 != '0') {
                    c2 = (char)(c4 + 4929);
                }
                int n3 = i % 4 / 2;
                char c5 = '\u0000';
                if (i != 0) {
                    char c6 = n3 != 0 ? (c3 != '\u0000' || c2 != '\u0000' ? (char)'\u137b' : '\u0000') : (c5 = '\u137c');
                }
                if (c3 == '\u1369' && c2 == '\u0000' && n2 > 1 && (c5 == '\u137b' || i + 1 == n2)) {
                    c3 = '\u0000';
                }
                if (c2 != '\u0000') {
                    stringBuilder.append(c2);
                }
                if (c3 != '\u0000') {
                    stringBuilder.append(c3);
                }
                if (c5 == '\u0000') continue;
                stringBuilder.append(c5);
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = n = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c >= '\u1369' && c < '\u1372') {
                    n3 += '\u0001' + c - 4969;
                    continue;
                }
                if (c >= '\u1372' && c < '\u137b') {
                    n3 += ('\u0001' + c - 4978) * 10;
                    continue;
                }
                if (c == '\u137c') {
                    if (bl && n3 == 0) {
                        n3 = 1;
                    }
                    n2 = NumberSystem.addEthiopic(n2, n3, n4);
                    n4 = bl ? (n4 *= 100) : (n4 *= 10000);
                    n3 = 0;
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (c != '\u137b') continue;
                n2 = NumberSystem.addEthiopic(n2, n3, n4);
                n4 *= 100;
                n3 = 0;
                bl = true;
                bl2 = false;
            }
            if ((bl || bl2) && n3 == 0) {
                n3 = 1;
            }
            n2 = NumberSystem.addEthiopic(n2, n3, n4);
            return n2;
        }

        @Override
        public boolean contains(char c) {
            return c >= '\u1369' && c <= '\u137c';
        }

        @Override
        public String getDigits() {
            return "\u1369\u136a\u136b\u136c\u136d\u136e\u136f\u1370\u1371\u1372\u1373\u1374\u1375\u1376\u1377\u1378\u1379\u137a\u137b\u137c";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    GUJARATI("gujr"){

        @Override
        public String getDigits() {
            return "\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    JAPANESE("jpan"){

        @Override
        public String toNumeral(int n) {
            if (n < 1 || n > 9999) {
                throw new IllegalArgumentException("Cannot convert: " + n);
            }
            String string = this.getDigits();
            int n2 = n / 1000;
            int n3 = n % 1000;
            int n4 = n3 / 100;
            int n5 = (n3 %= 100) / 10;
            int n6 = n3 % 10;
            StringBuilder stringBuilder = new StringBuilder();
            if (n2 >= 1) {
                if (n2 > 1) {
                    stringBuilder.append(string.charAt(n2 - 1));
                }
                stringBuilder.append('\u5343');
            }
            if (n4 >= 1) {
                if (n4 > 1) {
                    stringBuilder.append(string.charAt(n4 - 1));
                }
                stringBuilder.append('\u767e');
            }
            if (n5 >= 1) {
                if (n5 > 1) {
                    stringBuilder.append(string.charAt(n5 - 1));
                }
                stringBuilder.append('\u5341');
            }
            if (n6 > 0) {
                stringBuilder.append(string.charAt(n6 - 1));
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string2 = this.getDigits();
            block5: for (int i = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\u5341': {
                        if (n2 == 0 && n3 == 0 && n4 == 0) {
                            ++n2;
                            continue block5;
                        }
                        throw new IllegalArgumentException("Invalid Japanese numeral: " + string);
                    }
                    case '\u767e': {
                        if (n3 == 0 && n4 == 0) {
                            ++n3;
                            continue block5;
                        }
                        throw new IllegalArgumentException("Invalid Japanese numeral: " + string);
                    }
                    case '\u5343': {
                        if (n4 == 0) {
                            ++n4;
                            continue block5;
                        }
                        throw new IllegalArgumentException("Invalid Japanese numeral: " + string);
                    }
                    default: {
                        boolean bl = false;
                        for (int j = 0; j < 9; ++j) {
                            if (string2.charAt(j) != c) continue;
                            int n5 = j + 1;
                            if (n4 == 1) {
                                n += n5 * 1000;
                                n4 = -1;
                            } else if (n3 == 1) {
                                n += n5 * 100;
                                n3 = -1;
                            } else if (n2 == 1) {
                                n += n5 * 10;
                                n2 = -1;
                            } else {
                                n += n5;
                            }
                            bl = true;
                            break;
                        }
                        if (bl) continue block5;
                        throw new IllegalArgumentException("Invalid Japanese numeral: " + string);
                    }
                }
            }
            if (n2 == 1) {
                n += 10;
            }
            if (n3 == 1) {
                n += 100;
            }
            if (n4 == 1) {
                n += 1000;
            }
            return n;
        }

        @Override
        public String getDigits() {
            return "\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    KHMER("khmr"){

        @Override
        public String getDigits() {
            return "\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    MYANMAR("mymr"){

        @Override
        public String getDigits() {
            return "\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ORYA("orya"){

        @Override
        public String getDigits() {
            return "\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ROMAN("roman"){

        @Override
        public String toNumeral(int n) {
            if (n < 1 || n > 3999) {
                throw new IllegalArgumentException("Out of range (1-3999): " + n);
            }
            int n2 = n;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < NUMBERS.length; ++i) {
                while (n2 >= NUMBERS[i]) {
                    stringBuilder.append(LETTERS[i]);
                    n2 -= NUMBERS[i];
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            if (string.isEmpty()) {
                throw new NumberFormatException("Empty Roman numeral.");
            }
            String string2 = string.toUpperCase(Locale.US);
            boolean bl = leniency.isStrict();
            int n = string.length();
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                int n4;
                char c = string2.charAt(n2);
                int n5 = NumberSystem.getValue(c);
                int n6 = 1;
                if (n4 == n) {
                    n3 += n5;
                } else {
                    for (n4 = n2 + 1; n4 < n; ++n4) {
                        char c2 = string2.charAt(n4);
                        if (c2 == c) {
                            if (++n6 < 4 || !bl) continue;
                            throw new NumberFormatException("Roman numeral contains more than 3 equal letters in sequence: " + string);
                        }
                        int n7 = NumberSystem.getValue(c2);
                        if (n7 < n5) {
                            n3 += n5 * n6;
                            break;
                        }
                        if (bl && (n6 > 1 || !NumberSystem.isValidRomanCombination(c, c2))) {
                            throw new NumberFormatException("Not conform with modern usage: " + string);
                        }
                        n3 = n3 + n7 - n5 * n6;
                        break;
                    }
                }
                n2 = --n4;
            }
            if (n3 > 3999) {
                throw new NumberFormatException("Roman numbers bigger than 3999 not supported.");
            }
            if (bl) {
                if (n3 >= 900 && string2.contains("DCD")) {
                    throw new NumberFormatException("Roman number contains invalid sequence DCD.");
                }
                if (n3 >= 90 && string2.contains("LXL")) {
                    throw new NumberFormatException("Roman number contains invalid sequence LXL.");
                }
                if (n3 >= 9 && string2.contains("VIV")) {
                    throw new NumberFormatException("Roman number contains invalid sequence VIV.");
                }
            }
            return n3;
        }

        @Override
        public boolean contains(char c) {
            char c2 = Character.toUpperCase(c);
            return c2 == 'I' || c2 == 'V' || c2 == 'X' || c2 == 'L' || c2 == 'C' || c2 == 'D' || c2 == 'M';
        }

        @Override
        public String getDigits() {
            return "IVXLCDM";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    TELUGU("telu"){

        @Override
        public String getDigits() {
            return "\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    THAI("thai"){

        @Override
        public String getDigits() {
            return "\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    };

    private static final char ETHIOPIC_ONE = '\u1369';
    private static final char ETHIOPIC_TEN = '\u1372';
    private static final char ETHIOPIC_HUNDRED = '\u137b';
    private static final char ETHIOPIC_TEN_THOUSAND = '\u137c';
    private static final int[] NUMBERS;
    private static final String[] LETTERS;
    private static final int[] D_FACTORS;
    private final String code;

    private NumberSystem(String string2) {
        this.code = string2;
    }

    public String toNumeral(int n) {
        if (this.isDecimal() && n >= 0) {
            int n2 = this.getDigits().charAt(0) - 48;
            String string = Integer.toString(n);
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string.length();
            for (int i = 0; i < n3; ++i) {
                int n4 = string.charAt(i) + n2;
                stringBuilder.append((char)n4);
            }
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Cannot convert: " + n);
    }

    public int toNumeral(int n, Appendable appendable) throws IOException {
        String string = this.toNumeral(n);
        appendable.append(string);
        return string.length();
    }

    public final int toInteger(String string) {
        return this.toInteger(string, Leniency.SMART);
    }

    public int toInteger(String string, Leniency leniency) {
        if (this.isDecimal()) {
            int n;
            int n2 = this.getDigits().charAt(0) - 48;
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string.length();
            for (n = 0; n < n3; ++n) {
                int n4 = string.charAt(n) - n2;
                stringBuilder.append((char)n4);
            }
            n = Integer.parseInt(stringBuilder.toString());
            if (n < 0) {
                throw new NumberFormatException("Cannot convert negative number: " + string);
            }
            return n;
        }
        throw new NumberFormatException("Cannot convert: " + string);
    }

    public boolean contains(char c) {
        String string = this.getDigits();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public String getDigits() {
        throw new AbstractMethodError();
    }

    public boolean isDecimal() {
        throw new AbstractMethodError();
    }

    public String getCode() {
        return this.code;
    }

    private static int addEthiopic(int n, int n2, int n3) {
        return MathUtils.safeAdd(n, MathUtils.safeMultiply(n2, n3));
    }

    private static int getValue(char c) {
        switch (c) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new NumberFormatException("Invalid Roman digit: " + c);
    }

    private static boolean isValidRomanCombination(char c, char c2) {
        switch (c) {
            case 'C': {
                return c2 == 'M' || c2 == 'D';
            }
            case 'X': {
                return c2 == 'C' || c2 == 'L';
            }
            case 'I': {
                return c2 == 'X' || c2 == 'V';
            }
        }
        return false;
    }

    static {
        NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        D_FACTORS = new int[]{1, 12, 144, 1728, 20736};
    }
}

