/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.util.Locale;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarEra;
import net.time4j.format.CalendarText;
import net.time4j.format.TextWidth;

public enum HinduEra implements CalendarEra
{
    KALI_YUGA,
    NEPALESE,
    KOLLAM,
    VIKRAMA,
    SAKA,
    BENGAL;

    private static final int[] SAKA_OFFSETS;

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth) {
        CalendarText calendarText = CalendarText.getInstance("extra/hindu", locale);
        return calendarText.getEras(textWidth).print(this);
    }

    public int yearOfEra(HinduEra hinduEra, int n) {
        try {
            return MathUtils.safeSubtract(MathUtils.safeAdd(n, SAKA_OFFSETS[this.ordinal()]), SAKA_OFFSETS[hinduEra.ordinal()]);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
    }

    static {
        SAKA_OFFSETS = new int[]{3179, 955, 900, 135, 0, -515};
    }
}

