/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;

abstract class HinduCS
implements CalendarSystem<HinduCalendar> {
    static final long KALI_YUGA_EPOCH = -1132959L;
    final HinduVariant variant;

    HinduCS(HinduVariant hinduVariant) {
        if (hinduVariant == null) {
            throw new NullPointerException();
        }
        this.variant = hinduVariant;
    }

    @Override
    public final HinduCalendar transform(long l) {
        long l2 = this.getMinimumSinceUTC();
        long l3 = this.getMaximumSinceUTC();
        if (l < l2 || l > l3) {
            throw new IllegalArgumentException("Out of range: " + l2 + " <= " + l + " <= " + l3);
        }
        return this.create(l);
    }

    @Override
    public final long transform(HinduCalendar hinduCalendar) {
        return hinduCalendar.getDaysSinceEpochUTC();
    }

    @Override
    public List<CalendarEra> getEras() {
        ArrayList<HinduEra> arrayList = new ArrayList<HinduEra>(Arrays.asList(HinduEra.values()));
        return Collections.unmodifiableList(arrayList);
    }

    abstract HinduCalendar create(long var1);

    abstract HinduCalendar create(int var1, HinduMonth var2, HinduDay var3);

    abstract boolean isValid(int var1, HinduMonth var2, HinduDay var3);

    final boolean isExpunged(int n, HinduMonth hinduMonth) {
        long l = this.create(n, hinduMonth, HinduDay.valueOf(15)).getDaysSinceEpochUTC();
        HinduCalendar hinduCalendar = this.create(l);
        return !hinduCalendar.getMonth().getValue().equals(hinduMonth.getValue());
    }

    final boolean isExpunged(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
        long l = this.create(n, hinduMonth, hinduDay).getDaysSinceEpochUTC();
        HinduCalendar hinduCalendar = this.create(l);
        return hinduCalendar.getExpiredYearOfKaliYuga() != n || !hinduCalendar.getMonth().equals(hinduMonth) || !hinduCalendar.getDayOfMonth().equals(hinduDay);
    }

    static double modulo(double d, double d2) {
        return d - d2 * Math.floor(d / d2);
    }
}

