/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.Moment;
import net.time4j.base.MathUtils;
import net.time4j.calendar.EastAsianCS;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.astro.JulianDay;
import net.time4j.calendar.astro.StdSolarCalculator;
import net.time4j.tz.ZonalOffset;

public enum SolarTerm {
    MINOR_01_LICHUN_315,
    MAJOR_01_YUSHUI_330,
    MINOR_02_JINGZHE_345,
    MAJOR_02_CHUNFEN_000,
    MINOR_03_QINGMING_015,
    MAJOR_03_GUYU_030,
    MINOR_04_LIXIA_045,
    MAJOR_04_XIAOMAN_060,
    MINOR_05_MANGZHONG_075,
    MAJOR_05_XIAZHI_090,
    MINOR_06_XIAOSHU_105,
    MAJOR_06_DASHU_120,
    MINOR_07_LIQIU_135,
    MAJOR_07_CHUSHU_150,
    MINOR_08_BAILU_165,
    MAJOR_08_QIUFEN_180,
    MINOR_09_HANLU_195,
    MAJOR_09_SHUANGJIANG_210,
    MINOR_10_LIDONG_225,
    MAJOR_10_XIAOXUE_240,
    MINOR_11_DAXUE_255,
    MAJOR_11_DONGZHI_270,
    MINOR_12_XIAOHAN_285,
    MAJOR_12_DAHAN_300;

    private static final SolarTerm[] ENUMS;
    private static final double MEAN_TROPICAL_YEAR = 365.242189;
    private static final String[] SIMPLE;
    private static final String[] TRANSSCRIPTION;
    private static final String[] CHINESE_SIMPLIFIED;
    private static final String[] CHINESE_TRADITIONAL;
    private static final String[] KOREAN;
    private static final String[] VIETNAMESE;
    private static final String[] JAPANESE;

    public static SolarTerm ofMajor(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[2 * n - 1];
    }

    public static SolarTerm ofMinor(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[2 * (n - 1)];
    }

    public static SolarTerm of(Moment moment) {
        double d = JulianDay.ofEphemerisTime(moment).getValue();
        int n = (int)Math.floor(SolarTerm.solarLongitude(d) / 15.0);
        return ENUMS[(n + 3) % 24];
    }

    public int getIndex() {
        return this.ordinal() / 2 + 1;
    }

    public boolean isMajor() {
        return this.ordinal() % 2 == 1;
    }

    public boolean isMinor() {
        return this.ordinal() % 2 == 0;
    }

    public int getSolarLongitude() {
        return (this.ordinal() + 21) % 24 * 15;
    }

    public SolarTerm roll(int n) {
        return ENUMS[MathUtils.floorModulo(this.ordinal() + n, 24)];
    }

    public <D extends EastAsianCalendar<?, D>> D onOrAfter(D d) {
        EastAsianCS<D> eastAsianCS = d.getCalendarSystem();
        long l = d.getDaysSinceEpochUTC();
        ZonalOffset zonalOffset = eastAsianCS.getOffset(l);
        Moment moment = eastAsianCS.midnight(l);
        return (D)eastAsianCS.transform(this.atOrAfter(moment).toZonalTimestamp(zonalOffset).toDate().getDaysSinceEpochUTC());
    }

    public String getDisplayName(Locale locale) {
        String[] stringArray = SolarTerm.getTextForms(locale);
        return stringArray[this.ordinal()];
    }

    public static SolarTerm parse(CharSequence charSequence, Locale locale) throws ParseException {
        SolarTerm solarTerm = SolarTerm.parse(charSequence, locale, new ParsePosition(0));
        if (solarTerm == null) {
            throw new ParseException("Cannot parse: " + charSequence, 0);
        }
        return solarTerm;
    }

    static SolarTerm parse(CharSequence charSequence, Locale locale, ParsePosition parsePosition) {
        String[] stringArray = SolarTerm.getTextForms(locale);
        boolean bl = locale.getLanguage().isEmpty();
        int n = parsePosition.getIndex();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = charSequence.subSequence(n, Math.min(charSequence.length(), n + string.length())).toString();
            if ((!bl || !string2.equalsIgnoreCase(string)) && !string2.equals(string)) continue;
            parsePosition.setIndex(parsePosition.getIndex() + string.length());
            return ENUMS[i];
        }
        if (locale.getLanguage().isEmpty() || stringArray != TRANSSCRIPTION) {
            parsePosition.setErrorIndex(parsePosition.getIndex());
            return null;
        }
        return SolarTerm.parse(charSequence, Locale.ROOT, parsePosition);
    }

    static double solarLongitude(double d) {
        return StdSolarCalculator.TIME4J.getFeature(d, "solar-longitude");
    }

    private static double modulo360(double d) {
        return d - 360.0 * Math.floor(d / 360.0);
    }

    private static String[] getTextForms(Locale locale) {
        if (locale.getLanguage().equals("zh")) {
            return locale.getCountry().equals("TW") ? CHINESE_TRADITIONAL : CHINESE_SIMPLIFIED;
        }
        if (locale.getLanguage().equals("ko")) {
            return KOREAN;
        }
        if (locale.getLanguage().equals("vi")) {
            return VIETNAMESE;
        }
        if (locale.getLanguage().equals("ja")) {
            return JAPANESE;
        }
        return locale.getLanguage().isEmpty() ? SIMPLE : TRANSSCRIPTION;
    }

    private Moment atOrAfter(Moment moment) {
        double d = this.getSolarLongitude();
        double d2 = JulianDay.ofEphemerisTime(moment).getValue();
        double d3 = d2 + SolarTerm.modulo360(d - SolarTerm.solarLongitude(d2)) * 365.242189 / 360.0;
        double d4 = Math.max(d2, d3 - 5.0);
        double d5 = d3 + 5.0;
        while (true) {
            double d6 = (d4 + d5) / 2.0;
            if (d5 - d4 < 1.0E-5) {
                return JulianDay.ofEphemerisTime(d6).toMoment();
            }
            double d7 = SolarTerm.solarLongitude(d6) - d;
            if (SolarTerm.modulo360(d7) < 180.0) {
                d5 = d6;
                continue;
            }
            d4 = d6;
        }
    }

    static {
        ENUMS = SolarTerm.values();
        SIMPLE = new String[]{"lichun", "yushui", "jingzhe", "chunfen", "qingming", "guyu", "lixia", "xiaoman", "mangzhong", "xiazhi", "xiaoshu", "dashu", "liqiu", "chushu", "bailu", "qiufen", "hanlu", "shuangjiang", "lidong", "xiaoxue", "daxue", "dongzhi", "xiaohan", "dahan"};
        TRANSSCRIPTION = new String[]{"l\u00ecch\u016bn", "y\u01d4shu\u01d0", "j\u012bngzh\u00e9", "ch\u016bnf\u0113n", "q\u012bngm\u00edng", "g\u01d4y\u01d4", "l\u00ecxi\u00e0", "xi\u01ceom\u01cen", "m\u00e1ngzh\u00f2ng", "xi\u00e0zh\u00ec", "xi\u01ceosh\u01d4", "d\u00e0sh\u01d4", "l\u00ecqi\u016b", "ch\u01d4sh\u01d4", "b\u00e1il\u00f9", "qi\u016bf\u0113n", "h\u00e1nl\u00f9", "shu\u0101ngji\u00e0ng", "l\u00ecd\u014dng", "xi\u01ceoxu\u011b", "d\u00e0xu\u011b", "d\u014dngzh\u00ec", "xi\u01ceoh\u00e1n", "d\u00e0h\u00e1n"};
        CHINESE_SIMPLIFIED = new String[]{"\u7acb\u6625", "\u96e8\u6c34", "\u60ca\u86f0", "\u6625\u5206", "\u6e05\u660e", "\u8c37\u96e8", "\u7acb\u590f", "\u5c0f\u6ee1", "\u8292\u79cd", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u5904\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2"};
        CHINESE_TRADITIONAL = new String[]{"\u7acb\u6625", "\u96e8\u6c34", "\u9a5a\u87c4", "\u6625\u5206", "\u6e05\u660e", "\u7a40\u96e8", "\u7acb\u590f", "\u5c0f\u6eff", "\u8292\u7a2e", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u8655\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2"};
        KOREAN = new String[]{"\uc785\ucd98", "\uc6b0\uc218", "\uacbd\uce69", "\ucd98\ubd84", "\uccad\uba85", "\uace1\uc6b0", "\uc785\ud558", "\uc18c\ub9cc", "\ub9dd\uc885", "\ud558\uc9c0", "\uc18c\uc11c", "\ub300\uc11c", "\uc785\ucd94", "\ucc98\uc11c", "\ubc31\ub85c", "\ucd94\ubd84", "\ud55c\ub85c", "\uc0c1\uac15", "\uc785\ub3d9", "\uc18c\uc124", "\ub300\uc124", "\ub3d9\uc9c0", "\uc18c\ud55c", "\ub300\ud55c"};
        VIETNAMESE = new String[]{"L\u1eadp xu\u00e2n", "V\u0169 th\u1ee7y", "Kinh tr\u1eadp", "Xu\u00e2n ph\u00e2n", "Thanh minh", "C\u1ed1c v\u0169", "L\u1eadp h\u1ea1", "Ti\u1ec3u m\u00e3n", "Mang ch\u1ee7ng", "H\u1ea1 ch\u00ed", "Ti\u1ec3u th\u1eed", "\u0110\u1ea1i th\u1eed", "L\u1eadp thu", "X\u1eed th\u1eed", "B\u1ea1ch l\u1ed9", "Thu ph\u00e2n", "H\u00e0n l\u1ed9", "S\u01b0\u01a1ng gi\u00e1ng", "L\u1eadp \u0111\u00f4ng", "Ti\u1ec3u tuy\u1ebft", "\u0110\u1ea1i tuy\u1ebft", "\u0110\u00f4ng ch\u00ed", "Ti\u1ec3u h\u00e0n", "\u0110\u1ea1i h\u00e0n"};
        JAPANESE = new String[]{"\u7acb\u6625", "\u96e8\u6c34", "\u5553\u87c4", "\u6625\u5206", "\u6e05\u660e", "\u7a40\u96e8", "\u7acb\u590f", "\u5c0f\u6e80", "\u8292\u7a2e", "\u590f\u81f3", "\u5c0f\u6691", "\u5927\u6691", "\u7acb\u79cb", "\u51e6\u6691", "\u767d\u9732", "\u79cb\u5206", "\u5bd2\u9732", "\u971c\u964d", "\u7acb\u51ac", "\u5c0f\u96ea", "\u5927\u96ea", "\u51ac\u81f3", "\u5c0f\u5bd2", "\u5927\u5bd2"};
    }
}

