/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android.spi;

import android.content.Context;
import android.text.format.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import net.time4j.android.AssetLocation;
import net.time4j.android.spi.AndroidTickerSPI;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.service.GenericTextProviderSPI;
import net.time4j.calendar.service.KoreanExtension;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.PluralProvider;
import net.time4j.format.TextProvider;
import net.time4j.format.UnitPatternProvider;
import net.time4j.format.WeekdataProvider;
import net.time4j.format.internal.ExtendedPatterns;
import net.time4j.i18n.DefaultPluralProviderSPI;
import net.time4j.i18n.HistoricExtension;
import net.time4j.i18n.IsoTextProviderSPI;
import net.time4j.i18n.SymbolProviderSPI;
import net.time4j.i18n.UnitPatternProviderSPI;
import net.time4j.i18n.WeekdataProviderSPI;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.scale.TickProvider;
import net.time4j.tz.ZoneModelProvider;
import net.time4j.tz.ZoneNameProvider;
import net.time4j.tz.spi.TimezoneRepositoryProviderSPI;
import net.time4j.tz.spi.ZoneNameProviderSPI;

public class AndroidResourceLoader
extends ResourceLoader {
    private static final Map<Class<?>, Iterable<?>> PROVIDERS;
    private static final Set<String> MODULES;
    private Context context = null;
    private AssetLocation assetLocation = null;
    private List<FormatPatternProvider> patterns = Collections.emptyList();

    public void init(Context context, AssetLocation assetLocation) {
        if (context == null) {
            throw new NullPointerException("Missing Android-context.");
        }
        this.context = context;
        this.assetLocation = assetLocation;
        AndroidFormatPatterns androidFormatPatterns = new AndroidFormatPatterns();
        this.patterns = Collections.singletonList(androidFormatPatterns);
    }

    @Override
    public URI locate(String string, Class<?> clazz, String string2) {
        try {
            if (MODULES.contains(string)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("net/time4j/");
                stringBuilder.append(string);
                stringBuilder.append('/');
                stringBuilder.append(string2);
                return new URI(stringBuilder.toString());
            }
            URL uRL = clazz.getClassLoader().getResource(string2);
            if (uRL != null) {
                return uRL.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InputStream load(URI uRI, boolean bl) {
        try {
            if (uRI == null) {
                return null;
            }
            if (uRI.isAbsolute()) {
                URLConnection uRLConnection = uRI.toURL().openConnection();
                uRLConnection.setUseCaches(false);
                return uRLConnection.getInputStream();
            }
            if (this.assetLocation != null) {
                return this.assetLocation.open(uRI.toString());
            }
            if (this.context == null) {
                throw new IllegalStateException("'ApplicationStarter.initialize(context)' must be called first at app start.");
            }
            return this.context.getAssets().open(uRI.toString());
        }
        catch (IOException iOException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public <S> Iterable<S> services(Class<S> clazz) {
        Iterable<?> iterable = PROVIDERS.get(clazz);
        if (iterable == null) {
            if (clazz == FormatPatternProvider.class) {
                iterable = this.patterns;
            } else {
                return ServiceLoader.load(clazz, clazz.getClassLoader());
            }
        }
        return (Iterable)AndroidResourceLoader.cast(iterable);
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    static {
        HashMap<Class, Iterable<Object>> hashMap = new HashMap<Class, Iterable<Object>>();
        hashMap.put(TextProvider.class, new LazyTextdata());
        hashMap.put(ZoneModelProvider.class, new LazyZoneRules());
        hashMap.put(ZoneNameProvider.class, new LazyZoneNames());
        hashMap.put(LeapSecondProvider.class, new LazyLeapseconds());
        hashMap.put(ChronoExtension.class, new LazyExtensions());
        hashMap.put(NumberSymbolProvider.class, new LazyNumberSymbols());
        hashMap.put(PluralProvider.class, new LazyPluraldata());
        hashMap.put(UnitPatternProvider.class, Collections.singleton(new UnitPatternProviderSPI()));
        hashMap.put(WeekdataProvider.class, new LazyWeekdata());
        hashMap.put(TickProvider.class, Collections.singleton(new AndroidTickerSPI()));
        PROVIDERS = Collections.unmodifiableMap(hashMap);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("i18n");
        hashSet.add("calendar");
        hashSet.add("olson");
        hashSet.add("tzdata");
        MODULES = Collections.unmodifiableSet(hashSet);
    }

    private static final class StatelessIterables {
        private static final Iterable<PluralProvider> PLURALS;
        private static final Iterable<ChronoExtension> EXTENSIONS;

        private StatelessIterables() {
        }

        static {
            DefaultPluralProviderSPI defaultPluralProviderSPI = new DefaultPluralProviderSPI();
            PLURALS = Collections.singleton(defaultPluralProviderSPI);
            EXTENSIONS = Arrays.asList(new HistoricExtension(), new KoreanExtension());
        }
    }

    private static final class ZoneDataHolder {
        private static final Iterable<ZoneModelProvider> RULES;
        private static final Iterable<ZoneNameProvider> NAMES;
        private static final Iterable<LeapSecondProvider> LEAPSECONDS;

        private ZoneDataHolder() {
        }

        static {
            TimezoneRepositoryProviderSPI timezoneRepositoryProviderSPI = new TimezoneRepositoryProviderSPI();
            RULES = Collections.singleton(timezoneRepositoryProviderSPI);
            ZoneNameProviderSPI zoneNameProviderSPI = new ZoneNameProviderSPI();
            NAMES = Collections.singleton(zoneNameProviderSPI);
            LeapSecondProvider leapSecondProvider = null;
            for (ZoneModelProvider zoneModelProvider : RULES) {
                if (!(zoneModelProvider instanceof LeapSecondProvider)) continue;
                leapSecondProvider = (LeapSecondProvider)LeapSecondProvider.class.cast(zoneModelProvider);
                break;
            }
            LEAPSECONDS = leapSecondProvider == null ? Collections.emptyList() : Collections.singleton(leapSecondProvider);
        }
    }

    private static final class I18nDataHolder {
        private static final IsoTextProviderSPI ISODATA = new IsoTextProviderSPI();
        private static final Iterable<NumberSymbolProvider> SYMBOLS;
        private static final Iterable<WeekdataProvider> WEEKDATA;
        private static final Iterable<TextProvider> TEXTDATA;

        private I18nDataHolder() {
        }

        static {
            SymbolProviderSPI symbolProviderSPI = SymbolProviderSPI.INSTANCE;
            SYMBOLS = Collections.singleton(symbolProviderSPI);
            WeekdataProviderSPI weekdataProviderSPI = new WeekdataProviderSPI();
            WEEKDATA = Collections.singletonList(weekdataProviderSPI);
            List<TextProvider> list = Arrays.asList(ISODATA, new GenericTextProviderSPI());
            TEXTDATA = Collections.unmodifiableList(list);
        }
    }

    private static final class LazyExtensions
    implements Iterable<ChronoExtension> {
        private LazyExtensions() {
        }

        @Override
        public Iterator<ChronoExtension> iterator() {
            return StatelessIterables.EXTENSIONS.iterator();
        }
    }

    private static final class LazyPluraldata
    implements Iterable<PluralProvider> {
        private LazyPluraldata() {
        }

        @Override
        public Iterator<PluralProvider> iterator() {
            return StatelessIterables.PLURALS.iterator();
        }
    }

    private static final class LazyLeapseconds
    implements Iterable<LeapSecondProvider> {
        private LazyLeapseconds() {
        }

        @Override
        public Iterator<LeapSecondProvider> iterator() {
            return ZoneDataHolder.LEAPSECONDS.iterator();
        }
    }

    private static final class LazyZoneNames
    implements Iterable<ZoneNameProvider> {
        private LazyZoneNames() {
        }

        @Override
        public Iterator<ZoneNameProvider> iterator() {
            return ZoneDataHolder.NAMES.iterator();
        }
    }

    private static final class LazyZoneRules
    implements Iterable<ZoneModelProvider> {
        private LazyZoneRules() {
        }

        @Override
        public Iterator<ZoneModelProvider> iterator() {
            return ZoneDataHolder.RULES.iterator();
        }
    }

    private static final class LazyTextdata
    implements Iterable<TextProvider> {
        private LazyTextdata() {
        }

        @Override
        public Iterator<TextProvider> iterator() {
            return I18nDataHolder.TEXTDATA.iterator();
        }
    }

    private static final class LazyWeekdata
    implements Iterable<WeekdataProvider> {
        private LazyWeekdata() {
        }

        @Override
        public Iterator<WeekdataProvider> iterator() {
            return I18nDataHolder.WEEKDATA.iterator();
        }
    }

    private static final class LazyNumberSymbols
    implements Iterable<NumberSymbolProvider> {
        private LazyNumberSymbols() {
        }

        @Override
        public Iterator<NumberSymbolProvider> iterator() {
            return I18nDataHolder.SYMBOLS.iterator();
        }
    }

    private class AndroidFormatPatterns
    implements ExtendedPatterns {
        private AndroidFormatPatterns() {
        }

        @Override
        public String getDatePattern(DisplayMode displayMode, Locale locale) {
            return this.getDelegate().getDatePattern(displayMode, locale);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale) {
            return this.getTimePattern(displayMode, locale, false);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale, boolean bl) {
            String string = this.getDelegate().getTimePattern(displayMode, locale, bl);
            if (Locale.getDefault().equals(locale)) {
                String string2 = string;
                if (displayMode != DisplayMode.SHORT) {
                    string2 = this.getDelegate().getTimePattern(DisplayMode.SHORT, locale);
                }
                boolean bl2 = string2.indexOf(97) == -1;
                boolean bl3 = DateFormat.is24HourFormat((Context)AndroidResourceLoader.this.context);
                if (bl3 != bl2) {
                    if (bl3) {
                        return this.to24HourFormat(string).replace("  ", " ").trim();
                    }
                    String string3 = locale.getLanguage().equals("en") ? "b" : "B";
                    switch (displayMode) {
                        case FULL: {
                            return "h:mm:ss " + string3 + " zzzz";
                        }
                        case LONG: {
                            return "h:mm:ss " + string3 + " z";
                        }
                        case MEDIUM: {
                            return "h:mm:ss " + string3;
                        }
                    }
                    return "h:mm " + string3;
                }
            }
            return string;
        }

        @Override
        public String getDateTimePattern(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
            return this.getDelegate().getDateTimePattern(displayMode, displayMode2, locale);
        }

        @Override
        public String getIntervalPattern(Locale locale) {
            return this.getDelegate().getIntervalPattern(locale);
        }

        private String to24HourFormat(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = string.length();
            block0: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    stringBuilder.append(c);
                    ++i;
                    while (i < n) {
                        c = string.charAt(i);
                        if (c == '\'') {
                            stringBuilder.append(c);
                            if (i + 1 >= n || string.charAt(i + 1) != '\'') continue block0;
                            ++i;
                        }
                        stringBuilder.append(c);
                        ++i;
                    }
                    continue;
                }
                if (c == 'h') {
                    stringBuilder.append('H');
                    continue;
                }
                if (c == 'a') continue;
                stringBuilder.append(c);
            }
            return stringBuilder.toString();
        }

        private ExtendedPatterns getDelegate() {
            return I18nDataHolder.ISODATA;
        }
    }
}

