/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.frenchrev;

import java.util.Locale;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum FrenchRepublicanMonth {
    VENDEMIAIRE,
    BRUMAIRE,
    FRIMAIRE,
    NIVOSE,
    PLUVIOSE,
    VENTOSE,
    GERMINAL,
    FLOREAL,
    PRAIRIAL,
    MESSIDOR,
    THERMIDOR,
    FRUCTIDOR;

    private static final String[] NAMES_FR;

    public static FrenchRepublicanMonth valueOf(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return FrenchRepublicanMonth.values()[n - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("extra/frenchrev", locale);
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    public String getDayNameInFrench(int n) {
        return NAMES_FR[this.ordinal() * 30 + n - 1];
    }

    static {
        NAMES_FR = new String[]{"Raisin", "Safran", "Ch\u00e2taigne", "Colchique", "Cheval", "Balsamine", "Carotte", "Amaranthe", "Panais", "Cuve", "Pomme de terre", "Immortelle", "Potiron", "R\u00e9s\u00e9da", "\u00c2ne", "Belle de nuit", "Citrouille", "Sarrasin", "Tournesol", "Pressoir", "Chanvre", "P\u00eache", "Navet", "Amaryllis", "B\u0153uf", "Aubergine", "Piment", "Tomate", "Orge", "Tonneau", "Pomme", "C\u00e9leri", "Poire", "Betterave", "Oie", "H\u00e9liotrope", "Figue", "Scorson\u00e8re", "Alisier", "Charrue", "Salsifis", "M\u00e2cre", "Topinambour", "Endive", "Dindon", "Chervis", "Cresson", "Dentelaire", "Grenade", "Herse", "Bacchante", "Azerole", "Garance", "Orange", "Faisan", "Pistache", "Macjonc", "Coing", "Cormier", "Rouleau", "Raiponce", "Turneps", "Chicor\u00e9e", "N\u00e8fle", "Cochon", "M\u00e2che", "Chou-fleur", "Miel", "Geni\u00e8vre", "Pioche", "Cire", "Raifort", "C\u00e8dre", "Sapin", "Chevreuil", "Ajonc", "Cypr\u00e8s", "Lierre", "Sabine", "Hoyau", "\u00c9rable \u00e0 sucre", "Bruy\u00e8re", "Roseau", "Oseille", "Grillon", "Pignon", "Li\u00e8ge", "Truffe", "Olive", "Pelle", "Tourbe", "Houille", "Bitume", "Bitume", "Chien", "Lave", "Terre v\u00e9g\u00e9tale", "Fumier", "Salp\u00eatre", "Fl\u00e9au", "Granit", "Argile", "Ardoise", "Gr\u00e8s", "Lapin", "Silex", "Marne", "Pierre \u00e0 chaux", "Marbre", "Van", "Pierre \u00e0 pl\u00e2tre", "Sel", "Fer", "Cuivre", "Chat", "\u00c9tain", "Plomb", "Zinc", "Mercure", "Crible", "Laur\u00e9ole", "Mousse", "Fragon", "Perce-neige", "Taureau", "Laurier-thym", "Amadouvier", "M\u00e9z\u00e9r\u00e9on", "Peuplier", "Coign\u00e9e", "Ell\u00e9bore", "Brocoli", "Laurier", "Avelinier", "Vache", "Buis", "Lichen", "If", "Pulmonaire", "Serpette", "Thlaspi", "Thimel\u00e9", "Chiendent", "Trainasse", "Li\u00e8vre", "Gu\u00e8de", "Noisetier", "Cyclamen", "Ch\u00e9lidoine", "Tra\u00eeneau", "Tussilage", "Cornouiller", "Violier", "Tro\u00e8ne", "Bouc", "Asaret", "Alaterne", "Violette", "Marceau", "B\u00eache", "Narcisse", "Orme", "Fumeterre", "V\u00e9lar", "Ch\u00e8vre", "\u00c9pinard", "Doronic", "Mouron", "Cerfeuil", "Cordeau", "Mandragore", "Persil", "Cochl\u00e9aria", "P\u00e2querette", "Thon", "Pissenlit", "Sylvie", "Capillaire", "Fr\u00eane", "Plantoir", "Primev\u00e8re", "Platane", "Asperge", "Tulipe", "Poule", "Bette", "Bouleau", "Jonquille", "Aulne", "Couvoir", "Pervenche", "Charme", "Morille", "H\u00eatre", "Abeille", "Laitue", "M\u00e9l\u00e8ze", "Cigu\u00eb", "Radis", "Ruche", "Gainier", "Romaine", "Marronnier", "Roquette", "Pigeon", "Lilas", "An\u00e9mone", "Pens\u00e9e", "Myrtille", "Greffoir", "Rose", "Ch\u00eane", "Foug\u00e8re", "Aub\u00e9pine", "Rossignol", "Ancolie", "Muguet", "Champignon", "Hyacinthe", "R\u00e2teau", "Rhubarbe", "Sainfoin", "B\u00e2ton d'or", "Chamerisier", "Ver \u00e0 soie", "Consoude", "Pimprenelle", "Corbeille d'or", "Arroche", "Sarcloir", "Statice", "Fritillaire", "Bourrache", "Val\u00e9riane", "Carpe", "Fusain", "Civette", "Buglosse", "S\u00e9nev\u00e9", "Houlette", "Luzerne", "H\u00e9m\u00e9rocalle", "Tr\u00e8fle", "Ang\u00e9lique", "Canard", "M\u00e9lisse", "Fromental", "Martagon", "Serpolet", "Faux", "Fraise", "B\u00e9toine", "Pois", "Acacia", "Caille", "\u0152illet", "Sureau", "Pavot", "Tilleul", "Fourche", "Barbeau", "Camomille", "Ch\u00e8vrefeuille", "Caille-lait", "Tanche", "Jasmin", "Verveine", "Thym", "Pivoine", "Chariot", "Seigle", "Avoine", "Oignon", "V\u00e9ronique", "Mulet", "Romarin", "Concombre", "\u00c9chalote", "Absinthe", "Faucille", "Coriandre", "Artichaut", "Girofle", "Lavande", "Chamois", "Tabac", "Groseille", "Gesse", "Cerise", "Parc", "Menthe", "Cumin", "Haricot", "Orcan\u00e8te", "Pintade", "Sauge", "Ail", "Vesce", "Bl\u00e9", "Chal\u00e9mie", "\u00c9peautre", "Bouillon blanc", "Melon", "Ivraie", "B\u00e9lier", "Pr\u00eale", "Armoise", "Carthame", "M\u00fbre", "Arrosoir", "Panic", "Salicorne", "Abricot", "Basilic", "Brebis", "Guimauve", "Lin", "Amande", "Gentiane", "\u00c9cluse", "Carline", "C\u00e2prier", "Lentille", "Aun\u00e9e", "Loutre", "Myrte", "Colza", "Lupin", "Coton", "Moulin", "Prune", "Millet", "Lycoperdon", "Escourgeon", "Saumon", "Tub\u00e9reuse", "Sucrion", "Apocyn", "R\u00e9glisse", "\u00c9chelle", "Past\u00e8que", "Fenouil", "\u00c9pine vinette", "Noix", "Truite", "Citron", "Card\u00e8re", "Nerprun", "Tagette", "Hotte", "\u00c9glantier", "Noisette", "Houblon", "Sorgho", "\u00c9crevisse", "Bigarade", "Verge d'or", "Ma\u00efs", "Marron", "Panier"};
    }
}

