/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.FlagElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.format.expert.ZoneLabels;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneNameProcessor
implements FormatProcessor<TZID> {
    private static final ConcurrentMap<Locale, TZNames> CACHE_ABBREVIATIONS = new ConcurrentHashMap<Locale, TZNames>();
    private static final ConcurrentMap<Locale, TZNames> CACHE_ZONENAMES = new ConcurrentHashMap<Locale, TZNames>();
    private static final int MAX = 25;
    private static final String DEFAULT_PROVIDER = "DEFAULT";
    private final boolean abbreviated;
    private final FormatProcessor<TZID> fallback;
    private final Set<TZID> preferredZones;
    private final Leniency lenientMode;
    private final Locale locale;
    private final int protectedLength;

    TimezoneNameProcessor(boolean bl) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = null;
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
        this.protectedLength = 0;
    }

    TimezoneNameProcessor(boolean bl, Set<TZID> set) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = Collections.unmodifiableSet(new LinkedHashSet<TZID>(set));
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
        this.protectedLength = 0;
    }

    private TimezoneNameProcessor(boolean bl, FormatProcessor<TZID> formatProcessor, Set<TZID> set, Leniency leniency, Locale locale, int n) {
        this.abbreviated = bl;
        this.fallback = formatProcessor;
        this.preferredZones = set;
        this.lenientMode = leniency;
        this.locale = locale;
        this.protectedLength = n;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        if (!chronoDisplay.hasTimezone()) {
            throw new IllegalArgumentException("Cannot extract timezone name from: " + chronoDisplay);
        }
        TZID tZID = chronoDisplay.getTimezone();
        if (tZID instanceof ZonalOffset) {
            return this.fallback.print(chronoDisplay, appendable, attributeQuery, set, bl);
        }
        if (!(chronoDisplay instanceof UnixTime)) {
            throw new IllegalArgumentException("Cannot extract timezone name from: " + chronoDisplay);
        }
        Timezone timezone = Timezone.of(tZID);
        UnixTime unixTime = (UnixTime)UnixTime.class.cast(chronoDisplay);
        String string = timezone.getDisplayName(this.getStyle(timezone.isDaylightSaving(unixTime)), bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        int n2 = string.length();
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
        return n2;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        List<TZID> list;
        Object object;
        Object object2;
        List<TZID> list2;
        List<TZID> list3;
        int n;
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        int n4 = n = bl ? this.protectedLength : attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0);
        if (n > 0) {
            n3 -= n;
        }
        if (n2 >= n3) {
            parseLog.setError(n2, "Missing timezone name.");
            return;
        }
        Locale locale = bl ? this.locale : attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        Leniency leniency = bl ? this.lenientMode : attributeQuery.get(Attributes.LENIENCY, Leniency.SMART);
        String string = this.extractRelevantKey(charSequence, n2, n3);
        if (string.startsWith("GMT") || string.startsWith("UT")) {
            this.fallback.parse(charSequence, parseLog, attributeQuery, parsedEntity, bl);
            return;
        }
        ConcurrentMap<Locale, TZNames> concurrentMap = this.abbreviated ? CACHE_ABBREVIATIONS : CACHE_ZONENAMES;
        Object object3 = (TZNames)concurrentMap.get(locale);
        if (object3 == null) {
            list3 = this.createZoneNames(locale, false);
            list2 = this.createZoneNames(locale, true);
            object3 = new TZNames((ZoneLabels)((Object)list3), (ZoneLabels)((Object)list2));
            if (concurrentMap.size() < 25 && (object2 = (Object)concurrentMap.putIfAbsent(locale, (TZNames)object3)) != null) {
                object3 = object2;
            }
        }
        list3 = new ArrayList();
        list2 = new ArrayList();
        object2 = new int[2];
        ((TZNames)object3).search(charSequence.subSequence(0, n3), n2, list3, list2, (int[])object2);
        int n5 = list3.size() + list2.size();
        if (n5 == 0) {
            parseLog.setError(n2, "\"" + string + "\" does not match any known timezone name.");
            return;
        }
        if (n5 > 1 && !leniency.isStrict()) {
            list3 = TimezoneNameProcessor.excludeWinZones(list3);
            list2 = TimezoneNameProcessor.excludeWinZones(list2);
            n5 = list3.size() + list2.size();
        }
        List<TZID> list4 = list3;
        List<TZID> list5 = list2;
        if (n5 > 1 && !leniency.isLax()) {
            object = attributeQuery.get(Attributes.TIMEZONE_ID, ZonalOffset.UTC);
            boolean bl2 = false;
            if (!(object instanceof ZonalOffset)) {
                for (TZID tZID : list3) {
                    if (!tZID.canonical().equals(object.canonical())) continue;
                    list3 = Collections.singletonList(tZID);
                    list2 = Collections.emptyList();
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    for (TZID tZID : list2) {
                        if (!tZID.canonical().equals(object.canonical())) continue;
                        list3 = Collections.emptyList();
                        list2 = Collections.singletonList(tZID);
                        bl2 = true;
                        break;
                    }
                }
            }
            if (!bl2) {
                if (list3.size() > 0) {
                    list3 = this.resolveUsingPreferred(list3, locale, leniency);
                }
                if (list2.size() > 0) {
                    list2 = this.resolveUsingPreferred(list2, locale, leniency);
                }
            }
        }
        if ((n5 = list3.size() + list2.size()) == 0) {
            object = new ArrayList();
            for (TZID tZID : list4) {
                object.add(tZID.canonical());
            }
            for (TZID tZID : list5) {
                object.add(tZID.canonical());
            }
            parseLog.setError(n2, "Time zone name \"" + string + "\" not found among preferred timezones in locale " + locale + ", candidates=" + object);
            return;
        }
        boolean bl3 = false;
        if (list3.size() > 0) {
            list = list3;
            if (!(n5 == 2 && list2.size() == 1 && list3.get(0).canonical().equals(list2.get(0).canonical()) || list2.isEmpty())) {
                list = new ArrayList<TZID>(list);
                list.addAll(list2);
            }
        } else {
            list = list2;
            bl3 = true;
        }
        if (list.size() == 1 || leniency.isLax()) {
            parsedEntity.put(TimezoneElement.TIMEZONE_ID, list.get(0));
            parsedEntity.put(FlagElement.DAYLIGHT_SAVING, bl3);
            parseLog.setPosition(object2[bl3 ? 1 : 0]);
        } else {
            parseLog.setError(n2, "Time zone name is not unique: \"" + string + "\" in " + TimezoneNameProcessor.toString(list));
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        return new TimezoneNameProcessor(this.abbreviated, this.fallback, this.preferredZones, attributeQuery.get(Attributes.LENIENCY, Leniency.SMART), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT), attributeQuery.get(Attributes.PROTECTED_CHARACTERS, 0));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimezoneNameProcessor) {
            TimezoneNameProcessor timezoneNameProcessor = (TimezoneNameProcessor)object;
            return this.abbreviated == timezoneNameProcessor.abbreviated && (this.preferredZones == null ? timezoneNameProcessor.preferredZones == null : this.preferredZones.equals(timezoneNameProcessor.preferredZones));
        }
        return false;
    }

    public int hashCode() {
        return (this.preferredZones == null ? 0 : this.preferredZones.hashCode()) + (this.abbreviated ? 1 : 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[abbreviated=");
        stringBuilder.append(this.abbreviated);
        stringBuilder.append(", preferredZones=");
        stringBuilder.append(this.preferredZones);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String extractRelevantKey(CharSequence charSequence, int n, int n2) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2 && (Character.isLetter(c = charSequence.charAt(i)) || !this.abbreviated && i > n && !Character.isDigit(c)); ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString().trim();
    }

    private ZoneLabels createZoneNames(Locale locale, boolean bl) {
        ZoneLabels.Node node = null;
        NameStyle nameStyle = this.getStyle(bl);
        for (TZID tZID : Timezone.getAvailableIDs()) {
            String string = Timezone.getDisplayName(tZID, nameStyle, locale);
            if (string.equals(tZID.canonical())) continue;
            node = ZoneLabels.insert(node, string, tZID);
        }
        return new ZoneLabels(node);
    }

    private static List<TZID> excludeWinZones(List<TZID> list) {
        if (list.size() > 1) {
            ArrayList<TZID> arrayList = new ArrayList<TZID>(list);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                TZID tZID = list.get(i);
                if (!tZID.canonical().startsWith("WINDOWS~")) continue;
                arrayList.remove(tZID);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private List<TZID> resolveUsingPreferred(List<TZID> list, Locale locale, Leniency leniency) {
        void var6_13;
        HashMap hashMap = new HashMap();
        hashMap.put(DEFAULT_PROVIDER, new ArrayList());
        block0: for (TZID object2 : list) {
            String string = object2.canonical();
            Set<TZID> set = this.preferredZones;
            String string2 = DEFAULT_PROVIDER;
            int n = string.indexOf(126);
            if (n >= 0) {
                string2 = string.substring(0, n);
            }
            if (set == null) {
                set = Timezone.getPreferredIDs(locale, leniency.isSmart(), string2);
            }
            for (TZID tZID : set) {
                if (!tZID.canonical().equals(string)) continue;
                ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<TZID>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(tZID);
                continue block0;
            }
        }
        Object object3 = (List)hashMap.get(DEFAULT_PROVIDER);
        List<TZID> list2 = list;
        if (object3.isEmpty()) {
            hashMap.remove(DEFAULT_PROVIDER);
            boolean bl = false;
            for (String string2 : hashMap.keySet()) {
                object3 = (List)hashMap.get(string2);
                if (object3.isEmpty()) continue;
                bl = true;
                Object object = object3;
                break;
            }
            if (!bl) {
                List list3 = Collections.emptyList();
            }
        } else {
            Object object = object3;
        }
        return var6_13;
    }

    private NameStyle getStyle(boolean bl) {
        if (bl) {
            return this.abbreviated ? NameStyle.SHORT_DAYLIGHT_TIME : NameStyle.LONG_DAYLIGHT_TIME;
        }
        return this.abbreviated ? NameStyle.SHORT_STANDARD_TIME : NameStyle.LONG_STANDARD_TIME;
    }

    private static String toString(List<TZID> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 16);
        stringBuilder.append('{');
        boolean bl = true;
        for (TZID tZID : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(tZID.canonical());
        }
        return stringBuilder.append('}').toString();
    }

    private static class TZNames {
        private final ZoneLabels stdNames;
        private final ZoneLabels dstNames;

        TZNames(ZoneLabels zoneLabels, ZoneLabels zoneLabels2) {
            this.stdNames = zoneLabels;
            this.dstNames = zoneLabels2;
        }

        void search(CharSequence charSequence, int n, List<TZID> list, List<TZID> list2, int[] nArray) {
            String string = this.stdNames.longestPrefixOf(charSequence, n);
            int n2 = string.length();
            nArray[0] = n + n2;
            String string2 = this.dstNames.longestPrefixOf(charSequence, n);
            int n3 = string2.length();
            nArray[1] = n + n3;
            if (n3 > n2) {
                list2.addAll(this.dstNames.find(string2));
            } else if (n3 < n2) {
                list.addAll(this.stdNames.find(string));
            } else if (n2 > 0) {
                list.addAll(this.stdNames.find(string));
                list2.addAll(this.dstNames.find(string2));
            }
        }
    }
}

