/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.android.AssetLocation;
import net.time4j.android.spi.AndroidResourceLoader;
import net.time4j.base.ResourceLoader;
import net.time4j.format.DisplayMode;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public class ApplicationStarter {
    private static final String VERSION = "v4.3-2019a";
    private static final int RELEASE_YEAR = 2019;
    private static final int RELEASE_MONTH = 4;
    private static final int RELEASE_DAY = 19;
    private static final String TIME4A = "TIME4A";
    private static final AtomicBoolean PREPARED = new AtomicBoolean(false);
    private static final AtomicBoolean REGISTERED = new AtomicBoolean(false);

    private ApplicationStarter() {
    }

    public static void initialize(Application application) {
        ApplicationStarter.initialize((Context)application, false);
    }

    public static void initialize(Context context, boolean bl) {
        long l;
        long l2 = System.nanoTime();
        ApplicationStarter.prepareAssets(context, null);
        ApplicationStarter.registerReceiver(context.getApplicationContext());
        PlainDate plainDate = PlainDate.of(2019, 4, 19);
        Log.i((String)TIME4A, (String)("Starting Time4A (v4.3-2019a published on " + plainDate + ")"));
        if (bl) {
            l = System.nanoTime();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    DisplayMode displayMode = DisplayMode.FULL;
                    TZID tZID = Timezone.ofSystem().getID();
                    Locale locale = Locale.getDefault();
                    Log.i((String)ApplicationStarter.TIME4A, (String)("System time zone at start: [" + tZID.canonical() + "]"));
                    Log.i((String)ApplicationStarter.TIME4A, (String)("System locale at start: [" + locale.toString() + "]"));
                    try {
                        String string = ChronoFormatter.ofMomentStyle(displayMode, displayMode, locale, tZID).format(SystemClock.currentMoment());
                        Log.i((String)ApplicationStarter.TIME4A, (String)string);
                    }
                    catch (RuntimeException runtimeException) {
                        Log.e((String)ApplicationStarter.TIME4A, (String)("Error on prefetch thread with: time zone=" + tZID.canonical() + ", locale=" + locale + "!"), (Throwable)runtimeException);
                        throw runtimeException;
                    }
                    long l2 = (System.nanoTime() - l) / 1000000L;
                    Log.i((String)ApplicationStarter.TIME4A, (String)("Prefetch thread consumed (in ms): " + l2));
                }
            };
            Executors.defaultThreadFactory().newThread(runnable).start();
        }
        l = (System.nanoTime() - l2) / 1000000L;
        Log.i((String)TIME4A, (String)("Main-Thread consumed in ms: " + l));
    }

    public static void prepareAssets(Context context, AssetLocation assetLocation) {
        if (!PREPARED.getAndSet(true)) {
            System.setProperty("net.time4j.base.ResourceLoader", "net.time4j.android.spi.AndroidResourceLoader");
            ((AndroidResourceLoader)ResourceLoader.getInstance()).init(context, assetLocation);
        }
    }

    public static void registerReceiver(Context context) {
        if (context != null && !REGISTERED.getAndSet(true)) {
            System.setProperty("net.time4j.allow.system.tz.override", "true");
            context.registerReceiver((BroadcastReceiver)new TimezoneChangedReceiver(), new IntentFilter("android.intent.action.TIMEZONE_CHANGED"));
        }
    }

    private static class TimezoneChangedReceiver
    extends BroadcastReceiver {
        private TimezoneChangedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Timezone.Cache.refresh();
            Log.i((String)ApplicationStarter.TIME4A, (String)("Event ACTION_TIMEZONE_CHANGED received, system timezone changed to: [" + Timezone.ofSystem().getID().canonical() + "]. Original tz-id reported by Android: [" + intent.getStringExtra("time-zone") + "]"));
        }
    }
}

