/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.EraYearMonthDaySystem;
import net.time4j.calendar.HebrewAnniversary;
import net.time4j.calendar.HebrewEra;
import net.time4j.calendar.HebrewMonth;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.RelatedGregorianYearRule;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.WeekdayRule;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.calendar.service.StdEnumDateElement;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.UnitRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="hebrew")
public final class HebrewCalendar
extends Calendrical<Unit, HebrewCalendar>
implements LocalizedPatternSupport {
    private static final long FIXED_EPOCH = PlainDate.of(-3760, 9, 7).get(EpochDays.RATA_DIE);
    private static final int YEAR_INDEX = 0;
    private static final int DAY_OF_MONTH_INDEX = 2;
    private static final int DAY_OF_YEAR_INDEX = 3;
    @FormattableElement(format="G")
    public static final ChronoElement<HebrewEra> ERA = new StdEnumDateElement<HebrewEra, HebrewCalendar>("ERA", HebrewCalendar.class, HebrewEra.class, 'G');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, HebrewCalendar> YEAR_OF_ERA = new StdIntegerDateElement<HebrewCalendar>("YEAR_OF_ERA", HebrewCalendar.class, 1, 9999, 'y', null, null);
    @FormattableElement(format="M", standalone="L")
    public static final StdCalendarElement<HebrewMonth, HebrewCalendar> MONTH_OF_YEAR = new StdEnumDateElement<HebrewMonth, HebrewCalendar>("MONTH_OF_YEAR", HebrewCalendar.class, HebrewMonth.class, 'M'){

        @Override
        protected boolean hasLeapMonth(ChronoDisplay chronoDisplay) {
            return HebrewCalendar.isLeapYear(chronoDisplay.getInt(YEAR_OF_ERA));
        }

        @Override
        public int printToInt(HebrewMonth hebrewMonth, ChronoDisplay chronoDisplay, AttributeQuery attributeQuery) {
            switch (attributeQuery.get(HebrewMonth.order(), HebrewMonth.Order.CIVIL)) {
                case CIVIL: {
                    return hebrewMonth.getCivilValue(this.hasLeapMonth(chronoDisplay));
                }
                case BIBLICAL: {
                    return hebrewMonth.getBiblicalValue(this.hasLeapMonth(chronoDisplay));
                }
            }
            return this.numerical(hebrewMonth);
        }

        @Override
        public boolean parseFromInt(ChronoEntity<?> chronoEntity, int n) {
            if (n >= 1 && n <= 13) {
                chronoEntity.with(ParsedMonthElement.INSTANCE, n);
                return true;
            }
            return false;
        }
    };
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, HebrewCalendar> DAY_OF_MONTH = new StdIntegerDateElement<HebrewCalendar>("DAY_OF_MONTH", HebrewCalendar.class, 1, 30, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, HebrewCalendar> DAY_OF_YEAR = new StdIntegerDateElement<HebrewCalendar>("DAY_OF_YEAR", HebrewCalendar.class, 1, 355, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, HebrewCalendar> DAY_OF_WEEK = new StdWeekdayElement<HebrewCalendar>(HebrewCalendar.class, HebrewCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<HebrewCalendar> WIM_ELEMENT = new WeekdayInMonthElement<HebrewCalendar>(HebrewCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<HebrewCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final EraYearMonthDaySystem<HebrewCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, HebrewCalendar> ENGINE;
    public static final StdCalendarElement<Weekday, HebrewCalendar> LOCAL_DAY_OF_WEEK;
    public static final StdCalendarElement<Integer, HebrewCalendar> WEEK_OF_YEAR;
    public static final StdCalendarElement<Integer, HebrewCalendar> WEEK_OF_MONTH;
    public static final StdCalendarElement<Integer, HebrewCalendar> BOUNDED_WEEK_OF_YEAR;
    public static final StdCalendarElement<Integer, HebrewCalendar> BOUNDED_WEEK_OF_MONTH;
    private static final long serialVersionUID = -4183006723190472312L;
    private final transient int year;
    private final transient HebrewMonth month;
    private final transient int dom;

    private HebrewCalendar(int n, HebrewMonth hebrewMonth, int n2) {
        this.year = n;
        this.month = hebrewMonth;
        this.dom = n2;
    }

    public static HebrewCalendar of(int n, HebrewMonth hebrewMonth, int n2) {
        int n3 = hebrewMonth.getValue();
        if (!CALSYS.isValid(HebrewEra.ANNO_MUNDI, n, n3, n2)) {
            throw new IllegalArgumentException("Invalid Hebrew date: year=" + n + ", month=" + hebrewMonth + ", day=" + n2);
        }
        return new HebrewCalendar(n, hebrewMonth, n2);
    }

    public static HebrewCalendar ofCivil(int n, int n2, int n3) {
        HebrewMonth hebrewMonth = HebrewMonth.valueOfCivil(n2, HebrewCalendar.isLeapYear(n));
        return HebrewCalendar.of(n, hebrewMonth, n3);
    }

    public static HebrewCalendar ofBiblical(int n, int n2, int n3) {
        HebrewMonth hebrewMonth = HebrewMonth.valueOfBiblical(n2, HebrewCalendar.isLeapYear(n));
        return HebrewCalendar.of(n, hebrewMonth, n3);
    }

    public static HebrewCalendar nowInSystemTime() {
        return (HebrewCalendar)SystemClock.inLocalView().now(HebrewCalendar.axis());
    }

    public HebrewEra getEra() {
        return HebrewEra.ANNO_MUNDI;
    }

    public int getYear() {
        return this.year;
    }

    public HebrewMonth getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dom;
    }

    public Weekday getDayOfWeek() {
        long l = CALSYS.transform(this);
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return this.getInt(DAY_OF_YEAR);
    }

    public int lengthOfMonth() {
        return HebrewCalendar.lengthOfMonth(this.year, this.month);
    }

    public int lengthOfYear() {
        return HebrewCalendar.lengthOfYear(this.year);
    }

    public static boolean isLeapYear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Hebrew year is not positive: " + n);
        }
        return (7 * n + 1) % 19 < 7;
    }

    public boolean isLeapYear() {
        return HebrewCalendar.isLeapYear(this.year);
    }

    public boolean isSabbaticalYear() {
        return this.year % 7 == 0;
    }

    public boolean isRoshChodesh() {
        return this.dom == 1 && this.month != HebrewMonth.TISHRI || this.dom == 30;
    }

    public static boolean isValid(int n, HebrewMonth hebrewMonth, int n2) {
        return CALSYS.isValid(HebrewEra.ANNO_MUNDI, n, hebrewMonth.getValue(), n2);
    }

    public HebrewCalendar barMitzvah() {
        return this.get(HebrewAnniversary.BIRTHDAY.inHebrewYear(this.year + 13));
    }

    public HebrewCalendar batMitzvah() {
        return this.get(HebrewAnniversary.BIRTHDAY.inHebrewYear(this.year + 12));
    }

    public GeneralTimestamp<HebrewCalendar> at(PlainTime plainTime) {
        return GeneralTimestamp.of(this, plainTime);
    }

    public GeneralTimestamp<HebrewCalendar> atTime(int n, int n2) {
        return this.at(PlainTime.of(n, n2));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HebrewCalendar) {
            HebrewCalendar hebrewCalendar = (HebrewCalendar)object;
            return this.dom == hebrewCalendar.dom && this.month == hebrewCalendar.month && this.year == hebrewCalendar.year;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 17 * this.dom + 31 * this.month.getValue() + 37 * this.year;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("AM-");
        String string = String.valueOf(this.year);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        stringBuilder.append(this.month.name());
        stringBuilder.append('-');
        if (this.dom < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.dom);
        return stringBuilder.toString();
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Weekday.SUNDAY, 1, Weekday.FRIDAY, Weekday.SATURDAY);
    }

    public static TimeAxis<Unit, HebrewCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, HebrewCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected HebrewCalendar getContext() {
        return this;
    }

    static int lengthOfMonth(int n, HebrewMonth hebrewMonth) {
        switch (hebrewMonth) {
            case IYAR: 
            case TAMUZ: 
            case ELUL: 
            case TEVET: 
            case ADAR_II: {
                return 29;
            }
            case HESHVAN: {
                int n2 = HebrewCalendar.lengthOfYear(n);
                return n2 == 355 || n2 == 385 ? 30 : 29;
            }
            case KISLEV: {
                int n3 = HebrewCalendar.lengthOfYear(n);
                return n3 == 353 || n3 == 383 ? 29 : 30;
            }
        }
        return 30;
    }

    private static int lengthOfYear(int n) {
        return (int)(HebrewCalendar.hcNewYear(n + 1) - HebrewCalendar.hcNewYear(n));
    }

    private static long hcNewYear(int n) {
        return FIXED_EPOCH + (long)HebrewCalendar.hcDelay1(n) + (long)HebrewCalendar.hcDelay2(n);
    }

    private static int hcDelay2(int n) {
        int n2 = HebrewCalendar.hcDelay1(n);
        int n3 = HebrewCalendar.hcDelay1(n + 1);
        return n3 - n2 == 356 ? 2 : (n2 - HebrewCalendar.hcDelay1(n - 1) == 382 ? 1 : 0);
    }

    private static int hcDelay1(int n) {
        int n2 = (int)Math.floor(HebrewCalendar.hcMolad(n, HebrewMonth.TISHRI) - (double)FIXED_EPOCH + 0.5);
        return 3 * (n2 + 1) % 7 < 3 ? n2 + 1 : n2;
    }

    private static double hcMolad(int n, HebrewMonth hebrewMonth) {
        int n2 = hebrewMonth.getValue() + 6;
        if (n2 > 13) {
            n2 -= 13;
        }
        int n3 = n2 < 7 ? n + 1 : n;
        long l = n2 - 7 + MathUtils.floorDivide(235 * n3 - 234, 19);
        return (double)FIXED_EPOCH - 0.033796296296296297 + (double)l * 29.53059413580247;
    }

    private Object writeReplace() {
        return new SPX(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, HebrewCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)new EraRule())).appendElement(YEAR_OF_ERA, new IntegerRule(0), Unit.YEARS).appendElement(MONTH_OF_YEAR, new MonthRule(), Unit.MONTHS).appendElement(DAY_OF_MONTH, new IntegerRule(2), Unit.DAYS).appendElement(DAY_OF_YEAR, new IntegerRule(3), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<HebrewCalendar>(HebrewCalendar.getDefaultWeekmodel(), new ChronoFunction<HebrewCalendar, CalendarSystem<HebrewCalendar>>(){

            @Override
            public CalendarSystem<HebrewCalendar> apply(HebrewCalendar hebrewCalendar) {
                return CALSYS;
            }
        }), Unit.DAYS).appendElement(WIM_ELEMENT, WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<HebrewCalendar>(CALSYS, DAY_OF_YEAR))).appendUnit(Unit.YEARS, new HebrewUnitRule(Unit.YEARS), Unit.YEARS.getLength(), Collections.singleton(Unit.MONTHS)).appendUnit(Unit.MONTHS, new HebrewUnitRule(Unit.MONTHS), Unit.MONTHS.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.WEEKS, new HebrewUnitRule(Unit.WEEKS), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, new HebrewUnitRule(Unit.DAYS), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension(new CommonElements.Weekengine(HebrewCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, HebrewCalendar.getDefaultWeekmodel()));
        ENGINE = ((TimeAxis.Builder)builder).build();
        LOCAL_DAY_OF_WEEK = CommonElements.localDayOfWeek(HebrewCalendar.axis(), HebrewCalendar.getDefaultWeekmodel());
        WEEK_OF_YEAR = CommonElements.weekOfYear(HebrewCalendar.axis(), HebrewCalendar.getDefaultWeekmodel());
        WEEK_OF_MONTH = CommonElements.weekOfMonth(HebrewCalendar.axis(), HebrewCalendar.getDefaultWeekmodel());
        BOUNDED_WEEK_OF_YEAR = CommonElements.boundedWeekOfYear(HebrewCalendar.axis(), HebrewCalendar.getDefaultWeekmodel());
        BOUNDED_WEEK_OF_MONTH = CommonElements.boundedWeekOfMonth(HebrewCalendar.axis(), HebrewCalendar.getDefaultWeekmodel());
    }

    private static class SPX
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private static final int HEBREW_DATE = 12;
        private transient Object obj;

        public SPX() {
        }

        SPX(Object object) {
            this.obj = object;
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(12);
            this.writeHebrewDate(objectOutput);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException {
            byte by = objectInput.readByte();
            switch (by) {
                case 12: {
                    this.obj = this.readHebrewDate(objectInput);
                    break;
                }
                default: {
                    throw new InvalidObjectException("Unknown calendar type.");
                }
            }
        }

        private Object readResolve() throws ObjectStreamException {
            return this.obj;
        }

        private void writeHebrewDate(ObjectOutput objectOutput) throws IOException {
            HebrewCalendar hebrewCalendar = (HebrewCalendar)this.obj;
            objectOutput.writeInt(hebrewCalendar.getYear());
            objectOutput.writeByte(hebrewCalendar.getMonth().getValue());
            objectOutput.writeByte(hebrewCalendar.getDayOfMonth());
        }

        private HebrewCalendar readHebrewDate(ObjectInput objectInput) throws IOException {
            int n = objectInput.readInt();
            HebrewMonth hebrewMonth = HebrewMonth.valueOf(objectInput.readByte());
            byte by = objectInput.readByte();
            return HebrewCalendar.of(n, hebrewMonth, by);
        }
    }

    private static class HebrewUnitRule
    implements UnitRule<HebrewCalendar> {
        private final Unit unit;

        HebrewUnitRule(Unit unit) {
            this.unit = unit;
        }

        @Override
        public HebrewCalendar addTo(HebrewCalendar hebrewCalendar, long l) {
            switch (this.unit) {
                case YEARS: {
                    int n = MathUtils.safeCast(MathUtils.safeAdd((long)hebrewCalendar.year, l));
                    if (n < 1 || n > 9999) {
                        throw new IllegalArgumentException("Resulting year out of bounds: " + n);
                    }
                    HebrewMonth hebrewMonth = hebrewCalendar.month;
                    if (hebrewMonth == HebrewMonth.ADAR_I && !HebrewCalendar.isLeapYear(n)) {
                        hebrewMonth = HebrewMonth.SHEVAT;
                    }
                    int n2 = Math.min(hebrewCalendar.dom, HebrewCalendar.lengthOfMonth(n, hebrewMonth));
                    return new HebrewCalendar(n, hebrewMonth, n2);
                }
                case MONTHS: {
                    int n = hebrewCalendar.year;
                    int n3 = hebrewCalendar.month.getValue();
                    for (long i = Math.abs(l); i > 0L; --i) {
                        if (l > 0L) {
                            if (++n3 == 6 && !HebrewCalendar.isLeapYear(n)) {
                                ++n3;
                                continue;
                            }
                            if (n3 != 14) continue;
                            n3 = 1;
                            ++n;
                            continue;
                        }
                        if (--n3 == 6 && !HebrewCalendar.isLeapYear(n)) {
                            --n3;
                            continue;
                        }
                        if (n3 != 0) continue;
                        n3 = 13;
                        --n;
                    }
                    HebrewMonth hebrewMonth = HebrewMonth.valueOf(n3);
                    int n4 = Math.min(hebrewCalendar.dom, HebrewCalendar.lengthOfMonth(n, hebrewMonth));
                    return HebrewCalendar.of(n, hebrewMonth, n4);
                }
                case WEEKS: {
                    l = MathUtils.safeMultiply(l, 7L);
                }
                case DAYS: {
                    long l2 = MathUtils.safeAdd(CALSYS.transform(hebrewCalendar), l);
                    return (HebrewCalendar)CALSYS.transform(l2);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }

        @Override
        public long between(HebrewCalendar hebrewCalendar, HebrewCalendar hebrewCalendar2) {
            switch (this.unit) {
                case YEARS: {
                    int n = hebrewCalendar2.year - hebrewCalendar.year;
                    if (n > 0) {
                        if (hebrewCalendar2.month.getValue() < hebrewCalendar.month.getValue()) {
                            --n;
                        } else if (hebrewCalendar2.month.getValue() == hebrewCalendar.month.getValue() && hebrewCalendar2.dom < hebrewCalendar.dom) {
                            --n;
                        }
                    } else if (n < 0) {
                        if (hebrewCalendar2.month.getValue() > hebrewCalendar.month.getValue()) {
                            ++n;
                        } else if (hebrewCalendar2.month.getValue() == hebrewCalendar.month.getValue() && hebrewCalendar2.dom > hebrewCalendar.dom) {
                            ++n;
                        }
                    }
                    return n;
                }
                case MONTHS: {
                    HebrewCalendar hebrewCalendar3 = hebrewCalendar;
                    HebrewCalendar hebrewCalendar4 = hebrewCalendar2;
                    boolean bl = false;
                    if (hebrewCalendar.isAfter(hebrewCalendar2)) {
                        hebrewCalendar3 = hebrewCalendar2;
                        hebrewCalendar4 = hebrewCalendar;
                        bl = true;
                    }
                    int n = 0;
                    int n2 = hebrewCalendar3.year;
                    int n3 = hebrewCalendar3.month.getValue();
                    while (n2 < hebrewCalendar4.year || n2 == hebrewCalendar4.year && n3 < hebrewCalendar4.month.getValue()) {
                        ++n;
                        if (++n3 == 6 && !HebrewCalendar.isLeapYear(n2)) {
                            ++n3;
                            continue;
                        }
                        if (n3 != 14) continue;
                        n3 = 1;
                        ++n2;
                    }
                    if (n > 0 && hebrewCalendar3.dom > hebrewCalendar4.dom) {
                        --n;
                    }
                    return bl ? -n : n;
                }
                case WEEKS: {
                    return Unit.DAYS.between(hebrewCalendar, hebrewCalendar2) / 7;
                }
                case DAYS: {
                    return CALSYS.transform(hebrewCalendar2) - CALSYS.transform(hebrewCalendar);
                }
            }
            throw new UnsupportedOperationException(this.unit.name());
        }
    }

    private static class Merger
    implements ChronoMerger<HebrewCalendar> {
        private Merger() {
        }

        @Override
        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            return GenericDatePatterns.get("hebrew", displayStyle, locale);
        }

        @Override
        public HebrewCalendar createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            TZID tZID;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
            } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
                tZID = Timezone.ofSystem().getID();
            } else {
                return null;
            }
            StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
            return (HebrewCalendar)Moment.from(timeSource.currentTime()).toGeneralTimestamp(ENGINE, tZID, startOfDay).toDate();
        }

        @Override
        public HebrewCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n;
            int n2 = chronoEntity.getInt(YEAR_OF_ERA);
            if (n2 == Integer.MIN_VALUE) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Missing Hebrew year.");
                return null;
            }
            HebrewMonth hebrewMonth = null;
            if (chronoEntity.contains(ParsedMonthElement.INSTANCE)) {
                n = chronoEntity.getInt(ParsedMonthElement.INSTANCE);
                switch (attributeQuery.get(HebrewMonth.order(), HebrewMonth.Order.CIVIL)) {
                    case CIVIL: {
                        hebrewMonth = HebrewMonth.valueOfCivil(n, HebrewCalendar.isLeapYear(n2));
                        break;
                    }
                    case BIBLICAL: {
                        hebrewMonth = HebrewMonth.valueOfBiblical(n, HebrewCalendar.isLeapYear(n2));
                        break;
                    }
                    default: {
                        hebrewMonth = HebrewMonth.valueOf(n);
                        break;
                    }
                }
            } else if (chronoEntity.contains(MONTH_OF_YEAR)) {
                hebrewMonth = (HebrewMonth)chronoEntity.get(MONTH_OF_YEAR);
            }
            if (hebrewMonth != null) {
                n = chronoEntity.getInt(DAY_OF_MONTH);
                if (n != Integer.MIN_VALUE) {
                    if (CALSYS.isValid(HebrewEra.ANNO_MUNDI, n2, hebrewMonth.getValue(), n)) {
                        return HebrewCalendar.of(n2, hebrewMonth, n);
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hebrew date.");
                }
            } else {
                n = chronoEntity.getInt(DAY_OF_YEAR);
                if (n != Integer.MIN_VALUE) {
                    if (n > 0) {
                        int n3 = 1;
                        int n4 = 0;
                        boolean bl3 = HebrewCalendar.isLeapYear(n2);
                        while (n3 <= 13) {
                            if (n3 == 6 && !bl3) continue;
                            int n5 = HebrewCalendar.lengthOfMonth(n2, HebrewMonth.valueOf(n3));
                            if (n > n4 + n5) {
                                ++n3;
                                n4 += n5;
                                continue;
                            }
                            return HebrewCalendar.of(n2, HebrewMonth.valueOf(n3), n - n4);
                        }
                    }
                    chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Invalid Hebrew date.");
                }
            }
            return null;
        }

        @Override
        public ChronoDisplay preformat(HebrewCalendar hebrewCalendar, AttributeQuery attributeQuery) {
            return hebrewCalendar;
        }

        @Override
        public Chronology<?> preparser() {
            return null;
        }

        @Override
        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.EVENING;
        }

        @Override
        public int getDefaultPivotYear() {
            return HebrewCalendar.nowInSystemTime().getYear() + 20;
        }
    }

    private static enum ParsedMonthElement implements ChronoElement<Integer>
    {
        INSTANCE;


        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public char getSymbol() {
            return '\u0000';
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
        }

        @Override
        public Integer getDefaultMinimum() {
            return 1;
        }

        @Override
        public Integer getDefaultMaximum() {
            return 13;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public boolean isLenient() {
            return false;
        }

        @Override
        public String getDisplayName(Locale locale) {
            return this.name();
        }
    }

    private static class EraRule
    implements ElementRule<HebrewCalendar, HebrewEra> {
        private EraRule() {
        }

        @Override
        public HebrewEra getValue(HebrewCalendar hebrewCalendar) {
            return HebrewEra.ANNO_MUNDI;
        }

        @Override
        public HebrewEra getMinimum(HebrewCalendar hebrewCalendar) {
            return HebrewEra.ANNO_MUNDI;
        }

        @Override
        public HebrewEra getMaximum(HebrewCalendar hebrewCalendar) {
            return HebrewEra.ANNO_MUNDI;
        }

        @Override
        public boolean isValid(HebrewCalendar hebrewCalendar, HebrewEra hebrewEra) {
            return hebrewEra != null;
        }

        @Override
        public HebrewCalendar withValue(HebrewCalendar hebrewCalendar, HebrewEra hebrewEra, boolean bl) {
            if (hebrewEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            return hebrewCalendar;
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HebrewCalendar hebrewCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HebrewCalendar hebrewCalendar) {
            return YEAR_OF_ERA;
        }
    }

    private static class MonthRule
    implements ElementRule<HebrewCalendar, HebrewMonth> {
        private MonthRule() {
        }

        @Override
        public HebrewMonth getValue(HebrewCalendar hebrewCalendar) {
            return hebrewCalendar.month;
        }

        @Override
        public HebrewMonth getMinimum(HebrewCalendar hebrewCalendar) {
            return HebrewMonth.TISHRI;
        }

        @Override
        public HebrewMonth getMaximum(HebrewCalendar hebrewCalendar) {
            return HebrewMonth.ELUL;
        }

        @Override
        public boolean isValid(HebrewCalendar hebrewCalendar, HebrewMonth hebrewMonth) {
            return hebrewMonth != null && (hebrewMonth != HebrewMonth.ADAR_I || hebrewCalendar.isLeapYear());
        }

        @Override
        public HebrewCalendar withValue(HebrewCalendar hebrewCalendar, HebrewMonth hebrewMonth, boolean bl) {
            if (hebrewMonth == null) {
                throw new IllegalArgumentException("Missing month.");
            }
            if (hebrewMonth == HebrewMonth.ADAR_I && !hebrewCalendar.isLeapYear()) {
                throw new IllegalArgumentException("ADAR-I cannot be set in a standard year: " + hebrewCalendar);
            }
            int n = HebrewCalendar.lengthOfMonth(hebrewCalendar.year, hebrewMonth);
            int n2 = Math.min(hebrewCalendar.dom, n);
            return new HebrewCalendar(hebrewCalendar.year, hebrewMonth, n2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HebrewCalendar hebrewCalendar) {
            return DAY_OF_MONTH;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HebrewCalendar hebrewCalendar) {
            return DAY_OF_MONTH;
        }
    }

    private static class IntegerRule
    implements IntElementRule<HebrewCalendar> {
        private final int index;

        IntegerRule(int n) {
            this.index = n;
        }

        @Override
        public Integer getValue(HebrewCalendar hebrewCalendar) {
            return this.getInt(hebrewCalendar);
        }

        @Override
        public Integer getMinimum(HebrewCalendar hebrewCalendar) {
            switch (this.index) {
                case 0: 
                case 2: 
                case 3: {
                    return 1;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getMaximum(HebrewCalendar hebrewCalendar) {
            return this.getMax(hebrewCalendar);
        }

        @Override
        public boolean isValid(HebrewCalendar hebrewCalendar, Integer n) {
            if (n == null) {
                return false;
            }
            Integer n2 = this.getMinimum(hebrewCalendar);
            Integer n3 = this.getMaximum(hebrewCalendar);
            return n2.compareTo(n) <= 0 && n3.compareTo(n) >= 0;
        }

        @Override
        public HebrewCalendar withValue(HebrewCalendar hebrewCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing new value.");
            }
            return this.withValue(hebrewCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(HebrewCalendar hebrewCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(HebrewCalendar hebrewCalendar) {
            if (this.index == 0) {
                return MONTH_OF_YEAR;
            }
            return null;
        }

        @Override
        public int getInt(HebrewCalendar hebrewCalendar) {
            switch (this.index) {
                case 0: {
                    return hebrewCalendar.year;
                }
                case 2: {
                    return hebrewCalendar.dom;
                }
                case 3: {
                    int n = 0;
                    boolean bl = HebrewCalendar.isLeapYear(hebrewCalendar.year);
                    for (int i = 1; i < hebrewCalendar.month.getValue(); ++i) {
                        if (!bl && i == 6) continue;
                        n += CALSYS.getLengthOfMonth(HebrewEra.ANNO_MUNDI, hebrewCalendar.year, i);
                    }
                    return n + hebrewCalendar.dom;
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(HebrewCalendar hebrewCalendar, int n) {
            return n <= this.getMax(hebrewCalendar) && 1 <= n;
        }

        @Override
        public HebrewCalendar withValue(HebrewCalendar hebrewCalendar, int n, boolean bl) {
            if (!this.isValid(hebrewCalendar, n)) {
                throw new IllegalArgumentException("Out of range: " + n);
            }
            switch (this.index) {
                case 0: {
                    int n2 = CALSYS.getLengthOfMonth(HebrewEra.ANNO_MUNDI, n, hebrewCalendar.month.getValue());
                    int n3 = Math.min(hebrewCalendar.dom, n2);
                    return HebrewCalendar.of(n, hebrewCalendar.getMonth(), n3);
                }
                case 2: {
                    return new HebrewCalendar(hebrewCalendar.year, hebrewCalendar.month, n);
                }
                case 3: {
                    int n4 = n - this.getInt(hebrewCalendar);
                    return (HebrewCalendar)hebrewCalendar.plus(CalendarDays.of(n4));
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        private int getMax(HebrewCalendar hebrewCalendar) {
            switch (this.index) {
                case 0: {
                    return 9999;
                }
                case 2: {
                    return HebrewCalendar.lengthOfMonth(hebrewCalendar.year, hebrewCalendar.month);
                }
                case 3: {
                    return HebrewCalendar.lengthOfYear(hebrewCalendar.year);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }
    }

    private static class Transformer
    implements EraYearMonthDaySystem<HebrewCalendar> {
        private Transformer() {
        }

        @Override
        public boolean isValid(CalendarEra calendarEra, int n, int n2, int n3) {
            return calendarEra == HebrewEra.ANNO_MUNDI && n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 13 && n3 >= 1 && n3 <= this.getLengthOfMonth(calendarEra, n, n2);
        }

        @Override
        public int getLengthOfMonth(CalendarEra calendarEra, int n, int n2) {
            if (calendarEra != HebrewEra.ANNO_MUNDI) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 9999 && n2 >= 1 && n2 <= 13) {
                return HebrewCalendar.lengthOfMonth(n, HebrewMonth.valueOf(n2));
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n + ", month=" + HebrewMonth.valueOf(n2));
        }

        @Override
        public int getLengthOfYear(CalendarEra calendarEra, int n) {
            if (calendarEra != HebrewEra.ANNO_MUNDI) {
                throw new IllegalArgumentException("Invalid era: " + calendarEra);
            }
            if (n >= 1 && n <= 9999) {
                return HebrewCalendar.lengthOfYear(n);
            }
            throw new IllegalArgumentException("Out of bounds: year=" + n);
        }

        @Override
        public HebrewCalendar transform(long l) {
            long l2 = EpochDays.RATA_DIE.transform(l, EpochDays.UTC);
            int n = (int)MathUtils.floorDivide(98496L * (l2 - FIXED_EPOCH), 35975351);
            int n2 = n - 1;
            while (HebrewCalendar.hcNewYear(n) <= l2) {
                n2 = n++;
            }
            l2 -= HebrewCalendar.hcNewYear(n2) - 1L;
            boolean bl = HebrewCalendar.isLeapYear(n2);
            int n3 = 1;
            for (int i = 1; i < 13; ++i) {
                if (i == 6 && !bl) {
                    n3 = i + 1;
                    continue;
                }
                int n4 = HebrewCalendar.lengthOfMonth(n2, HebrewMonth.valueOf(i));
                if (l2 - (long)n4 <= 0L) break;
                l2 -= (long)n4;
                n3 = i + 1;
            }
            return HebrewCalendar.of(n2, HebrewMonth.valueOf(n3), (int)l2);
        }

        @Override
        public long transform(HebrewCalendar hebrewCalendar) {
            long l = EpochDays.UTC.transform(HebrewCalendar.hcNewYear(hebrewCalendar.year), EpochDays.RATA_DIE) + (long)hebrewCalendar.dom - 1L;
            boolean bl = HebrewCalendar.isLeapYear(hebrewCalendar.year);
            int n = hebrewCalendar.month.getValue();
            for (int i = 1; i < n; ++i) {
                if (!bl && i == 6) continue;
                l += (long)HebrewCalendar.lengthOfMonth(hebrewCalendar.year, HebrewMonth.valueOf(i));
            }
            return l;
        }

        @Override
        public long getMinimumSinceUTC() {
            HebrewCalendar hebrewCalendar = new HebrewCalendar(1, HebrewMonth.TISHRI, 1);
            return this.transform(hebrewCalendar);
        }

        @Override
        public long getMaximumSinceUTC() {
            HebrewCalendar hebrewCalendar = new HebrewCalendar(9999, HebrewMonth.ELUL, 29);
            return this.transform(hebrewCalendar);
        }

        @Override
        public List<CalendarEra> getEras() {
            HebrewEra hebrewEra = HebrewEra.ANNO_MUNDI;
            return Collections.singletonList(hebrewEra);
        }
    }

    public static enum Unit implements ChronoUnit
    {
        YEARS(3.155732352E7),
        MONTHS(2592000.0),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public int between(HebrewCalendar hebrewCalendar, HebrewCalendar hebrewCalendar2) {
            return (int)hebrewCalendar.until(hebrewCalendar2, this);
        }
    }
}

