/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.i18n.UTF8ResourceControl;
import net.time4j.tz.NameStyle;
import net.time4j.tz.ZoneNameProvider;

public class ZoneNameProviderSPI
implements ZoneNameProvider {
    private static final ConcurrentMap<Locale, Map<String, Map<NameStyle, String>>> NAMES = new ConcurrentHashMap<Locale, Map<String, Map<NameStyle, String>>>();
    private static final Set<String> GMT_ZONES;
    private static final Map<String, Set<String>> TERRITORIES;
    private static final Map<String, String> PRIMARIES;
    private static final ResourceBundle.Control CONTROL;

    @Override
    public Set<String> getPreferredIDs(Locale locale, boolean bl) {
        Object object;
        String string = locale.getCountry();
        if (bl) {
            if (string.equals("US")) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                linkedHashSet.add("America/New_York");
                linkedHashSet.add("America/Chicago");
                linkedHashSet.add("America/Denver");
                linkedHashSet.add("America/Los_Angeles");
                linkedHashSet.add("America/Anchorage");
                linkedHashSet.add("Pacific/Honolulu");
                linkedHashSet.add("America/Adak");
                return Collections.unmodifiableSet(linkedHashSet);
            }
            object = PRIMARIES.get(string);
            if (object != null) {
                return Collections.singleton(object);
            }
        }
        if ((object = TERRITORIES.get(string)) == null) {
            object = Collections.emptySet();
        }
        return object;
    }

    @Override
    public String getDisplayName(String string, NameStyle nameStyle, Locale locale) {
        Object object;
        if (GMT_ZONES.contains(string)) {
            return "";
        }
        Map map = (Map)NAMES.get(locale);
        if (map == null) {
            object = DateFormatSymbols.getInstance(locale);
            String[][] stringArray = ((DateFormatSymbols)object).getZoneStrings();
            map = new HashMap();
            for (String[] stringArray2 : stringArray) {
                EnumMap<NameStyle, String> enumMap = new EnumMap<NameStyle, String>(NameStyle.class);
                enumMap.put(NameStyle.LONG_STANDARD_TIME, stringArray2[1]);
                enumMap.put(NameStyle.SHORT_STANDARD_TIME, stringArray2[2]);
                enumMap.put(NameStyle.LONG_DAYLIGHT_TIME, stringArray2[3]);
                enumMap.put(NameStyle.SHORT_DAYLIGHT_TIME, stringArray2[4]);
                map.put(stringArray2[0], enumMap);
            }
            Map map2 = NAMES.putIfAbsent(locale, map);
            if (map2 != null) {
                map = map2;
            }
        }
        if ((object = (Map)map.get(string)) != null) {
            return (String)object.get((Object)nameStyle);
        }
        return "";
    }

    @Override
    public String getStdFormatPattern(boolean bl, Locale locale) {
        return ZoneNameProviderSPI.getBundle(locale).getString(bl ? "utc-literal" : "offset-pattern");
    }

    static void loadTerritories(Map<String, Set<String>> map, String string) {
        URI uRI = ResourceLoader.getInstance().locate("olson", ZoneNameProviderSPI.class, string);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            inputStream = ZoneNameProviderSPI.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream != null) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray;
                    if (string2.startsWith("#") || string2.isEmpty() || (stringArray = string2.split("\t")).length < 3) continue;
                    for (String string3 : stringArray[0].split(",")) {
                        ZoneNameProviderSPI.addTerritory(map, string3, stringArray[2]);
                    }
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        System.err.println("Warning: File \"" + string + "\" not found.");
    }

    private static void addTerritory(Map<String, Set<String>> map, String string, String string2) {
        Set<String> set = map.get(string);
        if (set == null) {
            set = new LinkedHashSet<String>();
            map.put(string, set);
        }
        set.add(string2);
    }

    private static void addPrimary(Map<String, String> map, String string, String string2) {
        map.put(string, string2);
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("zones/tzname", locale, ZoneNameProviderSPI.class.getClassLoader(), CONTROL);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Z");
        hashSet.add("GMT");
        hashSet.add("GMT0");
        hashSet.add("Greenwich");
        hashSet.add("UCT");
        hashSet.add("UTC");
        hashSet.add("UTC0");
        hashSet.add("Universal");
        hashSet.add("Zulu");
        GMT_ZONES = Collections.unmodifiableSet(hashSet);
        String string = "data/zone1970.tab";
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        ZoneNameProviderSPI.loadTerritories(hashMap, string);
        TERRITORIES = Collections.unmodifiableMap(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        ZoneNameProviderSPI.addPrimary(hashMap2, "CL", "America/Santiago");
        ZoneNameProviderSPI.addPrimary(hashMap2, "CN", "Asia/Shanghai");
        ZoneNameProviderSPI.addPrimary(hashMap2, "DE", "Europe/Berlin");
        ZoneNameProviderSPI.addPrimary(hashMap2, "EC", "America/Guayaquil");
        ZoneNameProviderSPI.addPrimary(hashMap2, "ES", "Europe/Madrid");
        ZoneNameProviderSPI.addPrimary(hashMap2, "MH", "Pacific/Majuro");
        ZoneNameProviderSPI.addPrimary(hashMap2, "MY", "Asia/Kuala_Lumpur");
        ZoneNameProviderSPI.addPrimary(hashMap2, "NZ", "Pacific/Auckland");
        ZoneNameProviderSPI.addPrimary(hashMap2, "PT", "Europe/Lisbon");
        ZoneNameProviderSPI.addPrimary(hashMap2, "UA", "Europe/Kiev");
        ZoneNameProviderSPI.addPrimary(hashMap2, "UZ", "Asia/Tashkent");
        PRIMARIES = Collections.unmodifiableMap(hashMap2);
        CONTROL = new UTF8ResourceControl(){

            @Override
            protected String getModuleName() {
                return "olson";
            }

            @Override
            protected Class<?> getModuleRef() {
                return ZoneNameProviderSPI.class;
            }
        };
    }
}

