/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

public class HistoricExtension
implements ChronoExtension {
    @Override
    public boolean accept(Class<?> clazz) {
        return clazz == PlainDate.class;
    }

    @Override
    public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
        if (locale.getCountry().isEmpty()) {
            return Collections.emptySet();
        }
        return HistoricExtension.getHistory(locale, attributeQuery).getElements();
    }

    @Override
    public <T extends ChronoEntity<T>> T resolve(T t, Locale locale, AttributeQuery attributeQuery) {
        ChronoHistory chronoHistory = HistoricExtension.getHistory(locale, attributeQuery);
        HistoricEra historicEra = null;
        if (t.contains(chronoHistory.era())) {
            historicEra = t.get(chronoHistory.era());
        } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
            historicEra = HistoricEra.AD;
        }
        if (historicEra != null && t.contains(chronoHistory.yearOfEra()) && t.contains(chronoHistory.month()) && t.contains(chronoHistory.dayOfMonth())) {
            int n = t.get(chronoHistory.yearOfEra());
            int n2 = t.get(chronoHistory.month());
            int n3 = t.get(chronoHistory.dayOfMonth());
            HistoricDate historicDate = HistoricDate.of(historicEra, n, n2, n3);
            PlainDate plainDate = chronoHistory.convert(historicDate);
            t.with(chronoHistory.era(), null);
            t.with(chronoHistory.yearOfEra(), null);
            t.with(chronoHistory.month(), null);
            t.with(chronoHistory.dayOfMonth(), null);
            return t.with((ChronoElement<PlainDate>)PlainDate.COMPONENT, (PlainDate)plainDate);
        }
        return t;
    }

    private static ChronoHistory getHistory(Locale locale, AttributeQuery attributeQuery) {
        if (attributeQuery.contains(ChronoHistory.ATTRIBUTE_HISTORIC_VARIANT)) {
            switch (attributeQuery.get(ChronoHistory.ATTRIBUTE_HISTORIC_VARIANT)) {
                case INTRODUCTION_ON_1582_10_15: {
                    return ChronoHistory.ofFirstGregorianReform();
                }
                case PROLEPTIC_JULIAN: {
                    return ChronoHistory.PROLEPTIC_JULIAN;
                }
                case PROLEPTIC_GREGORIAN: {
                    return ChronoHistory.PROLEPTIC_GREGORIAN;
                }
                case SWEDEN: {
                    return ChronoHistory.ofSweden();
                }
            }
            if (attributeQuery.contains(ChronoHistory.ATTRIBUTE_CUTOVER_DATE)) {
                PlainDate plainDate = attributeQuery.get(ChronoHistory.ATTRIBUTE_CUTOVER_DATE);
                return ChronoHistory.ofGregorianReform(plainDate);
            }
        }
        return ChronoHistory.of(locale);
    }
}

