/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import net.time4j.format.DisplayMode;

public interface FormatPatternProvider {
    public static final FormatPatternProvider DEFAULT = new FormatPatternProvider(){

        @Override
        public String getDatePattern(DisplayMode displayMode, Locale locale) {
            int n = this.getFormatStyle(displayMode);
            DateFormat dateFormat = DateFormat.getDateInstance(n, locale);
            return this.getFormatPattern(dateFormat);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale) {
            int n = this.getFormatStyle(displayMode);
            DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
            return this.removeZones(this.getFormatPattern(dateFormat));
        }

        @Override
        public String getDateTimePattern(DisplayMode displayMode, Locale locale) {
            int n = this.getFormatStyle(displayMode);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n, locale);
            return this.getFormatPattern(dateFormat);
        }

        @Override
        public String getIntervalPattern(Locale locale) {
            return "{0} - {1}";
        }

        private int getFormatStyle(DisplayMode displayMode) {
            switch (displayMode) {
                case FULL: {
                    return 0;
                }
                case LONG: {
                    return 1;
                }
                case MEDIUM: {
                    return 2;
                }
                case SHORT: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown: " + (Object)((Object)displayMode));
        }

        private String getFormatPattern(DateFormat dateFormat) {
            if (dateFormat instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)SimpleDateFormat.class.cast(dateFormat)).toPattern();
            }
            throw new IllegalStateException("Cannot retrieve format pattern: " + dateFormat);
        }

        private String removeZones(String string) {
            int n;
            String string2 = string.replace(" z", "");
            if (string2.charAt(string2.length() - 1) == 'z') {
                for (n = string2.length() - 1; n > 0; --n) {
                    if (string2.charAt(n - 1) == 'z') continue;
                    string2 = string2.substring(0, n).trim();
                    break;
                }
            }
            if (string2.charAt(0) == 'z') {
                for (n = 1; n < string2.length(); ++n) {
                    if (string2.charAt(n) == 'z') continue;
                    string2 = string2.substring(n).trim();
                    break;
                }
            }
            return string2;
        }
    };

    public String getDatePattern(DisplayMode var1, Locale var2);

    public String getTimePattern(DisplayMode var1, Locale var2);

    public String getDateTimePattern(DisplayMode var1, Locale var2);

    public String getIntervalPattern(Locale var1);
}

