/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android.spi;

import android.app.Application;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.time4j.android.spi.AndroidTickerSPI;
import net.time4j.base.ResourceLoader;
import net.time4j.calendar.service.GenericTextProviderSPI;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.FormatEngine;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.PluralProvider;
import net.time4j.format.TextProvider;
import net.time4j.format.UnitPatternProvider;
import net.time4j.format.WeekdataProvider;
import net.time4j.i18n.HistoricExtension;
import net.time4j.i18n.IsoTextProviderSPI;
import net.time4j.i18n.PluralProviderSPI;
import net.time4j.i18n.SymbolProviderSPI;
import net.time4j.i18n.UltimateFormatEngine;
import net.time4j.i18n.UnitPatternProviderSPI;
import net.time4j.i18n.WeekdataProviderSPI;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.scale.TickProvider;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.spi.TimezoneRepositoryProviderSPI;
import net.time4j.tz.spi.ZoneNameProviderSPI;

public class AndroidResourceLoader
extends ResourceLoader {
    private static final Map<Class<?>, Iterable<?>> PROVIDERS;
    private static final Set<String> MODULES;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private Application application = null;

    public void init(Application application) {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.application = application;
    }

    @Override
    public URI locate(String string, Class<?> clazz, String string2) {
        try {
            if (MODULES.contains(string)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("net/time4j/");
                stringBuilder.append(string);
                stringBuilder.append('/');
                stringBuilder.append(string2);
                return new URI(stringBuilder.toString());
            }
            URL uRL = clazz.getClassLoader().getResource(string2);
            if (uRL != null) {
                return uRL.toURI();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InputStream load(URI uRI, boolean bl) {
        try {
            if (uRI == null) {
                return null;
            }
            if (uRI.isAbsolute() || this.application == null) {
                URLConnection uRLConnection = uRI.toURL().openConnection();
                uRLConnection.setUseCaches(false);
                return uRLConnection.getInputStream();
            }
            return this.application.getAssets().open(uRI.toString());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public <S> Iterable<S> services(Class<S> clazz) {
        Iterable<?> iterable = PROVIDERS.get(clazz);
        if (iterable == null) {
            return ServiceLoader.load(clazz, clazz.getClassLoader());
        }
        return (Iterable)AndroidResourceLoader.cast(iterable);
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    static {
        HashMap<Class, Iterable<Object>> hashMap = new HashMap<Class, Iterable<Object>>();
        hashMap.put(TextProvider.class, new LazyTextdata());
        hashMap.put(ZoneProvider.class, new LazyZoneData());
        hashMap.put(LeapSecondProvider.class, new LazyLeapseconds());
        hashMap.put(ChronoExtension.class, Collections.singleton(new HistoricExtension()));
        hashMap.put(FormatEngine.class, Collections.singleton(UltimateFormatEngine.INSTANCE));
        hashMap.put(NumberSymbolProvider.class, Collections.singleton(new SymbolProviderSPI()));
        hashMap.put(PluralProvider.class, new LazyPluraldata());
        hashMap.put(UnitPatternProvider.class, Collections.singleton(new UnitPatternProviderSPI()));
        hashMap.put(WeekdataProvider.class, new LazyWeekdata());
        hashMap.put(TickProvider.class, Collections.singleton(new AndroidTickerSPI()));
        PROVIDERS = Collections.unmodifiableMap(hashMap);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("i18n");
        hashSet.add("calendar");
        hashSet.add("tzdata");
        MODULES = Collections.unmodifiableSet(hashSet);
    }

    private static final class PluraldataHolder {
        private static final Iterable<PluralProviderSPI> ITERABLE = Collections.singleton(new PluralProviderSPI());

        private PluraldataHolder() {
        }
    }

    private static final class LazyPluraldata
    implements Iterable<PluralProviderSPI> {
        private LazyPluraldata() {
        }

        @Override
        public Iterator<PluralProviderSPI> iterator() {
            return PluraldataHolder.ITERABLE.iterator();
        }
    }

    private static final class LeapsecondHolder {
        private static final Iterable<LeapSecondProvider> ITERABLE;

        private LeapsecondHolder() {
        }

        static {
            LeapSecondProvider leapSecondProvider = null;
            for (ZoneProvider zoneProvider : ZoneDataHolder.ITERABLE) {
                if (!(zoneProvider instanceof LeapSecondProvider)) continue;
                leapSecondProvider = (LeapSecondProvider)LeapSecondProvider.class.cast(zoneProvider);
                break;
            }
            ITERABLE = leapSecondProvider == null ? Collections.emptyList() : Collections.singleton(leapSecondProvider);
        }
    }

    private static final class LazyLeapseconds
    implements Iterable<LeapSecondProvider> {
        private LazyLeapseconds() {
        }

        @Override
        public Iterator<LeapSecondProvider> iterator() {
            return LeapsecondHolder.ITERABLE.iterator();
        }
    }

    private static final class ZoneDataHolder {
        private static final Iterable<ZoneProvider> ITERABLE;

        private ZoneDataHolder() {
        }

        static {
            TimezoneRepositoryProviderSPI timezoneRepositoryProviderSPI = new TimezoneRepositoryProviderSPI();
            ZoneNameProviderSPI zoneNameProviderSPI = new ZoneNameProviderSPI();
            ITERABLE = Collections.unmodifiableList(Arrays.asList(timezoneRepositoryProviderSPI, zoneNameProviderSPI));
        }
    }

    private static final class LazyZoneData
    implements Iterable<ZoneProvider> {
        private LazyZoneData() {
        }

        @Override
        public Iterator<ZoneProvider> iterator() {
            return ZoneDataHolder.ITERABLE.iterator();
        }
    }

    private static final class WeekdataHolder {
        private static final Iterable<WeekdataProviderSPI> ITERABLE = Collections.singleton(new WeekdataProviderSPI());

        private WeekdataHolder() {
        }
    }

    private static final class LazyWeekdata
    implements Iterable<WeekdataProviderSPI> {
        private LazyWeekdata() {
        }

        @Override
        public Iterator<WeekdataProviderSPI> iterator() {
            return WeekdataHolder.ITERABLE.iterator();
        }
    }

    private static final class TextdataHolder {
        private static final Iterable<TextProvider> ITERABLE;

        private TextdataHolder() {
        }

        static {
            List<TextProvider> list = Arrays.asList(new IsoTextProviderSPI(), new GenericTextProviderSPI());
            ITERABLE = Collections.unmodifiableList(list);
        }
    }

    private static final class LazyTextdata
    implements Iterable<TextProvider> {
        private LazyTextdata() {
        }

        @Override
        public Iterator<TextProvider> iterator() {
            return TextdataHolder.ITERABLE.iterator();
        }
    }
}

