/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import net.time4j.AbstractTimeElement;
import net.time4j.PlainTime;
import net.time4j.ProportionalElement;
import net.time4j.ProportionalFunction;
import net.time4j.RoundingOperator;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.NumericalElement;

final class IntegerTimeElement
extends AbstractTimeElement<Integer>
implements ProportionalElement<Integer, PlainTime>,
NumericalElement<Integer> {
    static final int CLOCK_HOUR_OF_AMPM = 1;
    static final int CLOCK_HOUR_OF_DAY = 2;
    static final int DIGITAL_HOUR_OF_AMPM = 3;
    static final int DIGITAL_HOUR_OF_DAY = 4;
    static final int ISO_HOUR = 5;
    static final int MINUTE_OF_HOUR = 6;
    static final int MINUTE_OF_DAY = 7;
    static final int SECOND_OF_MINUTE = 8;
    static final int SECOND_OF_DAY = 9;
    static final int MILLI_OF_SECOND = 10;
    static final int MICRO_OF_SECOND = 11;
    static final int NANO_OF_SECOND = 12;
    static final int MILLI_OF_DAY = 13;
    private static final long serialVersionUID = -1337148214680014674L;
    private final transient int index;
    private final transient Integer defaultMin;
    private final transient Integer defaultMax;
    private final transient char symbol;
    private final transient ChronoFunction<ChronoEntity<?>, BigDecimal> rf;

    private IntegerTimeElement(String string, int n, Integer n2, Integer n3, char c) {
        super(string);
        boolean bl;
        this.index = n;
        this.defaultMin = n2;
        this.defaultMax = n3;
        this.symbol = c;
        switch (n) {
            case 5: 
            case 7: 
            case 9: 
            case 13: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        this.rf = new ProportionalFunction(this, bl);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public Integer getDefaultMinimum() {
        return this.defaultMin;
    }

    @Override
    public Integer getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public int numerical(Integer n) {
        return n;
    }

    @Override
    public ChronoFunction<ChronoEntity<?>, BigDecimal> ratio() {
        return this.rf;
    }

    @Override
    public ChronoOperator<PlainTime> roundedUp(int n) {
        return new RoundingOperator<PlainTime>(this, Boolean.TRUE, n);
    }

    @Override
    public ChronoOperator<PlainTime> roundedHalf(int n) {
        return new RoundingOperator<PlainTime>(this, null, n);
    }

    @Override
    public ChronoOperator<PlainTime> roundedDown(int n) {
        return new RoundingOperator<PlainTime>(this, Boolean.FALSE, n);
    }

    int getIndex() {
        return this.index;
    }

    static IntegerTimeElement createTimeElement(String string, int n, int n2, int n3, char c) {
        return new IntegerTimeElement(string, n, n2, n3, c);
    }

    static IntegerTimeElement createClockElement(String string, boolean bl) {
        return new IntegerTimeElement(string, bl ? 2 : 1, 1, bl ? 24 : 12, bl ? (char)'k' : 'h');
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainTime.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

