/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Iterator;
import java.util.Locale;
import net.time4j.Platform;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.ChronoPattern;
import net.time4j.format.FormatEngine;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.TemporalFormatter;
import net.time4j.tz.TZID;

class FormatSupport {
    private static final FormatEngine<?> DEFAULT_FORMAT_ENGINE;
    private static final FormatPatternProvider FORMAT_PATTERN_PROVIDER;

    private FormatSupport() {
    }

    static <T extends ChronoEntity<T>, P extends ChronoPattern<P>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, P p, Locale locale) {
        FormatEngine<P> formatEngine = p.getFormatEngine();
        return formatEngine.create(clazz, string, p, locale);
    }

    static <T extends ChronoEntity<T>, P extends ChronoPattern<P>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, P p, Locale locale, TZID tZID) {
        return FormatSupport.createFormatter(clazz, string, p, locale).withTimezone(tZID);
    }

    static <T extends ChronoEntity<T>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, Locale locale) {
        return FormatSupport.createFormatter(clazz, DEFAULT_FORMAT_ENGINE, string, locale);
    }

    static <T extends ChronoEntity<T>> TemporalFormatter<T> createFormatter(Class<T> clazz, String string, Locale locale, TZID tZID) {
        return FormatSupport.createFormatter(clazz, DEFAULT_FORMAT_ENGINE, string, locale).withTimezone(tZID);
    }

    static FormatEngine<?> getDefaultFormatEngine() {
        return DEFAULT_FORMAT_ENGINE;
    }

    static FormatPatternProvider getFormatPatternProvider() {
        return FORMAT_PATTERN_PROVIDER;
    }

    private static <T extends ChronoEntity<T>, P extends ChronoPattern<P>> TemporalFormatter<T> createFormatter(Class<T> clazz, FormatEngine<P> formatEngine, String string, Locale locale) {
        return formatEngine.create(clazz, string, formatEngine.getDefaultPatternType(), locale);
    }

    static {
        Object object;
        FormatPatternProvider formatPatternProvider = null;
        Iterator<FormatPatternProvider> iterator = ResourceLoader.getInstance().services(FormatPatternProvider.class).iterator();
        if (iterator.hasNext()) {
            object = iterator.next();
            formatPatternProvider = object;
        }
        FORMAT_PATTERN_PROVIDER = formatPatternProvider == null ? FormatPatternProvider.DEFAULT : formatPatternProvider;
        iterator = null;
        object = null;
        for (FormatEngine formatEngine : ResourceLoader.getInstance().services(FormatEngine.class)) {
            if (formatEngine.isSupported(ChronoEntity.class)) {
                object = formatEngine;
                break;
            }
            iterator = formatEngine;
        }
        if (object == null) {
            object = iterator == null ? Platform.PATTERN.getFormatEngine() : iterator;
        }
        DEFAULT_FORMAT_ENGINE = object;
    }
}

